/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.onesignal.OSDynamicTriggerController;
import com.onesignal.OSInAppMessage;
import com.onesignal.OSInAppMessageAction;
import com.onesignal.OSInAppMessageDummyController;
import com.onesignal.OSSystemConditionController;
import com.onesignal.OSTriggerController;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalChromeTab;
import com.onesignal.OneSignalPrefs;
import com.onesignal.OneSignalRestClient;
import com.onesignal.WebViewManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class OSInAppMessageController
implements OSDynamicTriggerController.OSDynamicTriggerControllerObserver,
OSSystemConditionController.OSSystemConditionObserver {
    private static ArrayList<String> PREFERRED_VARIANT_ORDER = new ArrayList<String>(){
        {
            this.add("android");
            this.add("app");
            this.add("all");
        }
    };
    public static final String IN_APP_MESSAGES_JSON_KEY = "in_app_messages";
    OSTriggerController triggerController;
    private OSSystemConditionController systemConditionController;
    @NonNull
    private ArrayList<OSInAppMessage> messages = new ArrayList();
    @NonNull
    private final Set<String> triggeredMessages = OSUtils.newConcurrentSet();
    @NonNull
    private final Set<String> impressionedMessages = OSUtils.newConcurrentSet();
    @NonNull
    private final Set<String> clickedClickIds = OSUtils.newConcurrentSet();
    @NonNull
    final ArrayList<OSInAppMessage> messageDisplayQueue = new ArrayList();
    private boolean inAppMessagingEnabled = true;
    @Nullable
    Date lastTimeInAppDismissed;
    @Nullable
    private static OSInAppMessageController sharedInstance;

    public static OSInAppMessageController getController() {
        if (Build.VERSION.SDK_INT <= 18) {
            sharedInstance = new OSInAppMessageDummyController();
        }
        if (sharedInstance == null) {
            sharedInstance = new OSInAppMessageController();
        }
        return sharedInstance;
    }

    protected OSInAppMessageController() {
        Set<String> tempClickedMessageIdsSet;
        Set<String> tempImpressionedSet;
        this.triggerController = new OSTriggerController(this);
        this.systemConditionController = new OSSystemConditionController(this);
        Set<String> tempTriggeredSet = OneSignalPrefs.getStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_DISPLAYED_IAMS", null);
        if (tempTriggeredSet != null) {
            this.triggeredMessages.addAll(tempTriggeredSet);
        }
        if ((tempImpressionedSet = OneSignalPrefs.getStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_IMPRESSIONED_IAMS", null)) != null) {
            this.impressionedMessages.addAll(tempImpressionedSet);
        }
        if ((tempClickedMessageIdsSet = OneSignalPrefs.getStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_CLICKED_CLICK_IDS_IAMS", null)) != null) {
            this.clickedClickIds.addAll(tempClickedMessageIdsSet);
        }
    }

    void initWithCachedInAppMessages() {
        if (!this.messages.isEmpty()) {
            return;
        }
        String cachedIamsStr = OneSignalPrefs.getString(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_CACHED_IAMS", null);
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "initWithCachedInAppMessages: " + cachedIamsStr);
        if (cachedIamsStr == null) {
            return;
        }
        try {
            this.processInAppMessageJson(new JSONArray(cachedIamsStr));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    void receivedInAppMessageJson(@NonNull JSONArray json) throws JSONException {
        OneSignalPrefs.saveString(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_CACHED_IAMS", json.toString());
        this.processInAppMessageJson(json);
    }

    private void processInAppMessageJson(@NonNull JSONArray json) throws JSONException {
        ArrayList<OSInAppMessage> newMessages = new ArrayList<OSInAppMessage>();
        for (int i = 0; i < json.length(); ++i) {
            JSONObject messageJson = json.getJSONObject(i);
            OSInAppMessage message = new OSInAppMessage(messageJson);
            newMessages.add(message);
        }
        this.messages = newMessages;
        this.evaluateInAppMessages();
    }

    private void evaluateInAppMessages() {
        if (this.systemConditionController.systemConditionsAvailable()) {
            for (OSInAppMessage message : this.messages) {
                if (!this.triggerController.evaluateMessageTriggers(message)) continue;
                this.messageCanBeDisplayed(message);
            }
        }
    }

    @Nullable
    private static String variantIdForMessage(@NonNull OSInAppMessage message) {
        String languageIdentifier = OSUtils.getCorrectedLanguage();
        for (String variant : PREFERRED_VARIANT_ORDER) {
            if (!message.variants.containsKey(variant)) continue;
            HashMap<String, String> variantMap = message.variants.get(variant);
            if (variantMap.containsKey(languageIdentifier)) {
                return variantMap.get(languageIdentifier);
            }
            return variantMap.get("default");
        }
        return null;
    }

    private static void printHttpSuccessForInAppMessageRequest(String requestType, String response) {
        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "Successful post for in-app message " + requestType + " request: " + response);
    }

    private static void printHttpErrorForInAppMessageRequest(String requestType, int statusCode, String response) {
        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.ERROR, "Encountered a " + statusCode + " error while attempting in-app message " + requestType + " request: " + response);
    }

    void onMessageWasShown(final @NonNull OSInAppMessage message) {
        if (message.isPreview) {
            return;
        }
        if (this.impressionedMessages.contains(message.messageId)) {
            return;
        }
        this.impressionedMessages.add(message.messageId);
        final String variantId = OSInAppMessageController.variantIdForMessage(message);
        if (variantId == null) {
            return;
        }
        try {
            JSONObject json = new JSONObject(){
                {
                    this.put("app_id", OneSignal.appId);
                    this.put("player_id", OneSignal.getUserId());
                    this.put("variant_id", variantId);
                    this.put("device_type", new OSUtils().getDeviceType());
                    this.put("first_impression", true);
                }
            };
            OneSignalRestClient.post("in_app_messages/" + message.messageId + "/impression", json, new OneSignalRestClient.ResponseHandler(){

                @Override
                void onSuccess(String response) {
                    OSInAppMessageController.printHttpSuccessForInAppMessageRequest("impression", response);
                    OneSignalPrefs.saveStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_IMPRESSIONED_IAMS", OSInAppMessageController.this.impressionedMessages);
                }

                @Override
                void onFailure(int statusCode, String response, Throwable throwable) {
                    OSInAppMessageController.printHttpErrorForInAppMessageRequest("impression", statusCode, response);
                    OSInAppMessageController.this.impressionedMessages.remove(message.messageId);
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.ERROR, "Unable to execute in-app message impression HTTP request due to invalid JSON");
        }
    }

    void onMessageActionOccurredOnMessage(@NonNull OSInAppMessage message, @NonNull JSONObject actionJson) {
        OSInAppMessageAction action = new OSInAppMessageAction(actionJson);
        action.firstClick = message.takeActionAsUnique();
        this.firePublicClickHandler(action);
        this.fireClickAction(action);
        this.fireRESTCallForClick(message, action);
    }

    void onMessageActionOccurredOnPreview(@NonNull OSInAppMessage message, @NonNull JSONObject actionJson) {
        OSInAppMessageAction action = new OSInAppMessageAction(actionJson);
        action.firstClick = message.takeActionAsUnique();
        this.firePublicClickHandler(action);
        this.fireClickAction(action);
    }

    private void firePublicClickHandler(final @NonNull OSInAppMessageAction action) {
        if (OneSignal.mInitBuilder.mInAppMessageClickHandler == null) {
            return;
        }
        OSUtils.runOnMainUIThread(new Runnable(){

            @Override
            public void run() {
                OneSignal.mInitBuilder.mInAppMessageClickHandler.inAppMessageClicked(action);
            }
        });
    }

    private void fireClickAction(@NonNull OSInAppMessageAction action) {
        if (action.clickUrl != null && !action.clickUrl.isEmpty()) {
            if (action.urlTarget == OSInAppMessageAction.OSInAppMessageActionUrlType.BROWSER) {
                OSUtils.openURLInBrowser(action.clickUrl);
            } else if (action.urlTarget == OSInAppMessageAction.OSInAppMessageActionUrlType.IN_APP_WEBVIEW) {
                OneSignalChromeTab.open(action.clickUrl, true);
            }
        }
    }

    private void fireRESTCallForClick(@NonNull OSInAppMessage message, final @NonNull OSInAppMessageAction action) {
        final String variantId = OSInAppMessageController.variantIdForMessage(message);
        if (variantId == null) {
            return;
        }
        if (this.clickedClickIds.contains(action.clickId)) {
            return;
        }
        this.clickedClickIds.add(action.clickId);
        try {
            JSONObject json = new JSONObject(){
                {
                    this.put("app_id", OneSignal.appId);
                    this.put("device_type", new OSUtils().getDeviceType());
                    this.put("player_id", OneSignal.getUserId());
                    this.put("click_id", action.clickId);
                    this.put("click_name", action.clickName);
                    this.put("variant_id", variantId);
                    if (action.firstClick) {
                        this.put("first_click", true);
                    }
                }
            };
            OneSignalRestClient.post("in_app_messages/" + message.messageId + "/click", json, new OneSignalRestClient.ResponseHandler(){

                @Override
                void onSuccess(String response) {
                    OSInAppMessageController.printHttpSuccessForInAppMessageRequest("engagement", response);
                    OneSignalPrefs.saveStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_CLICKED_CLICK_IDS_IAMS", OSInAppMessageController.this.clickedClickIds);
                }

                @Override
                void onFailure(int statusCode, String response, Throwable throwable) {
                    OSInAppMessageController.printHttpErrorForInAppMessageRequest("engagement", statusCode, response);
                    OSInAppMessageController.this.clickedClickIds.remove(action.clickId);
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.ERROR, "Unable to execute in-app message action HTTP request due to invalid JSON");
        }
    }

    private void messageCanBeDisplayed(@NonNull OSInAppMessage message) {
        if (!this.inAppMessagingEnabled) {
            return;
        }
        if (this.triggeredMessages.contains(message.messageId) && !message.isPreview) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "In-App message with id '" + message.messageId + "' already displayed or is already preparing to be display!");
            return;
        }
        this.queueMessageForDisplay(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueMessageForDisplay(@NonNull OSInAppMessage message) {
        ArrayList<OSInAppMessage> arrayList = this.messageDisplayQueue;
        synchronized (arrayList) {
            this.messageDisplayQueue.add(message);
            if (!message.isPreview) {
                this.triggeredMessages.add(message.messageId);
            }
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "queueMessageForDisplay: " + this.messageDisplayQueue);
            if (this.messageDisplayQueue.size() > 1) {
                return;
            }
            this.displayMessage(message);
        }
    }

    boolean isDisplayingInApp() {
        return this.messageDisplayQueue.size() > 0;
    }

    @Nullable
    OSInAppMessage getCurrentDisplayedInAppMessage() {
        return this.isDisplayingInApp() ? this.messageDisplayQueue.get(0) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void messageWasDismissed(@NonNull OSInAppMessage message) {
        ArrayList<OSInAppMessage> arrayList = this.messageDisplayQueue;
        synchronized (arrayList) {
            if (!this.messageDisplayQueue.remove(message)) {
                if (!message.isPreview) {
                    OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "An in-app message was removed from the display queue before it was finished displaying.");
                }
                return;
            }
            if (!message.isPreview) {
                this.persistDisplayedIams();
            }
            if (this.messageDisplayQueue.size() > 0) {
                this.displayMessage(this.messageDisplayQueue.get(0));
            } else {
                this.lastTimeInAppDismissed = new Date();
                this.evaluateInAppMessages();
            }
        }
    }

    private void persistDisplayedIams() {
        OneSignalPrefs.saveStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_DISPLAYED_IAMS", this.getAllDismissedIams());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private Set<String> getAllDismissedIams() {
        HashSet<String> dismissedIams = new HashSet<String>(this.triggeredMessages);
        ArrayList<OSInAppMessage> arrayList = this.messageDisplayQueue;
        synchronized (arrayList) {
            for (OSInAppMessage message : this.messageDisplayQueue) {
                dismissedIams.remove(message.messageId);
            }
        }
        return dismissedIams;
    }

    @Nullable
    private static String htmlPathForMessage(OSInAppMessage message) {
        String variantId = OSInAppMessageController.variantIdForMessage(message);
        if (variantId == null) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.ERROR, "Unable to find a variant for in-app message " + message.messageId);
            return null;
        }
        return "in_app_messages/" + message.messageId + "/variants/" + variantId + "/html?app_id=" + OneSignal.appId;
    }

    private void displayMessage(final OSInAppMessage message) {
        String htmlPath = OSInAppMessageController.htmlPathForMessage(message);
        OneSignalRestClient.getSync(htmlPath, new OneSignalRestClient.ResponseHandler(){

            @Override
            void onFailure(int statusCode, String response, Throwable throwable) {
                OSInAppMessageController.printHttpErrorForInAppMessageRequest("html", statusCode, response);
            }

            @Override
            void onSuccess(String response) {
                try {
                    JSONObject jsonResponse = new JSONObject(response);
                    String htmlStr = jsonResponse.getString("html");
                    double displayDuration = jsonResponse.optDouble("display_duration");
                    message.setDisplayDuration(displayDuration);
                    WebViewManager.showHTMLString(message, htmlStr);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, null);
    }

    void displayPreviewMessage(@NonNull String previewUUID) {
        String htmlPath = "in_app_messages/device_preview?preview_id=" + previewUUID + "&app_id=" + OneSignal.appId;
        OneSignalRestClient.get(htmlPath, new OneSignalRestClient.ResponseHandler(){

            @Override
            void onFailure(int statusCode, String response, Throwable throwable) {
                OSInAppMessageController.printHttpErrorForInAppMessageRequest("html", statusCode, response);
            }

            @Override
            void onSuccess(String response) {
                try {
                    JSONObject jsonResponse = new JSONObject(response);
                    String htmlStr = jsonResponse.getString("html");
                    OSInAppMessage message = new OSInAppMessage(true);
                    double displayDuration = jsonResponse.optDouble("display_duration");
                    message.setDisplayDuration(displayDuration);
                    WebViewManager.showHTMLString(message, htmlStr);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, null);
    }

    @Override
    public void messageTriggerConditionChanged() {
        this.evaluateInAppMessages();
    }

    void addTriggers(Map<String, Object> newTriggers) {
        this.triggerController.addTriggers(newTriggers);
        this.evaluateInAppMessages();
    }

    void removeTriggersForKeys(Collection<String> keys) {
        this.triggerController.removeTriggersForKeys(keys);
        this.evaluateInAppMessages();
    }

    void setInAppMessagingEnabled(boolean enabled) {
        this.inAppMessagingEnabled = enabled;
        if (enabled) {
            this.evaluateInAppMessages();
        }
    }

    @Nullable
    Object getTriggerValue(String key) {
        return this.triggerController.getTriggerValue(key);
    }
}

