/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.support.annotation.NonNull;
import android.support.v4.app.NotificationManagerCompat;
import com.onesignal.BadgeCountUpdater;
import com.onesignal.NotificationBundleProcessor;
import com.onesignal.NotificationSummaryManager;
import com.onesignal.OSInAppMessageController;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import org.json.JSONArray;
import org.json.JSONObject;

class NotificationOpenedProcessor {
    NotificationOpenedProcessor() {
    }

    static void processFromContext(Context context, Intent intent) {
        if (!NotificationOpenedProcessor.isOneSignalIntent(intent)) {
            return;
        }
        OneSignal.setAppContext(context);
        NotificationOpenedProcessor.handleDismissFromActionButtonPress(context, intent);
        NotificationOpenedProcessor.processIntent(context, intent);
    }

    private static boolean isOneSignalIntent(Intent intent) {
        return intent.hasExtra("onesignal_data") || intent.hasExtra("summary") || intent.hasExtra("notificationId");
    }

    private static void handleDismissFromActionButtonPress(Context context, Intent intent) {
        if (intent.getBooleanExtra("action_button", false)) {
            NotificationManagerCompat.from((Context)context).cancel(intent.getIntExtra("notificationId", 0));
            context.sendBroadcast(new Intent("android.intent.action.CLOSE_SYSTEM_DIALOGS"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processIntent(Context context, Intent intent) {
        String summaryGroup = intent.getStringExtra("summary");
        boolean dismissed = intent.getBooleanExtra("dismissed", false);
        JSONArray dataArray = null;
        if (!dismissed) {
            try {
                JSONObject jsonData = new JSONObject(intent.getStringExtra("onesignal_data"));
                if (NotificationOpenedProcessor.handleIAMPreviewOpen(context, jsonData)) {
                    return;
                }
                jsonData.put("notificationId", intent.getIntExtra("notificationId", 0));
                intent.putExtra("onesignal_data", jsonData.toString());
                dataArray = NotificationBundleProcessor.newJsonArray(new JSONObject(intent.getStringExtra("onesignal_data")));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(context);
        SQLiteDatabase writableDb = null;
        try {
            String group;
            writableDb = dbHelper.getWritableDbWithRetries();
            writableDb.beginTransaction();
            if (!dismissed && summaryGroup != null) {
                NotificationOpenedProcessor.addChildNotifications(dataArray, summaryGroup, writableDb);
            }
            NotificationOpenedProcessor.markNotificationsConsumed(context, intent, writableDb);
            if (summaryGroup == null && (group = intent.getStringExtra("grp")) != null) {
                NotificationSummaryManager.updateSummaryNotificationAfterChildRemoved(context, writableDb, group, dismissed);
            }
            writableDb.setTransactionSuccessful();
        }
        catch (Exception e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error processing notification open or dismiss record! ", e);
        }
        finally {
            if (writableDb != null) {
                try {
                    writableDb.endTransaction();
                }
                catch (Throwable t) {
                    OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error closing transaction! ", t);
                }
            }
        }
        if (!dismissed) {
            OneSignal.handleNotificationOpen(context, dataArray, intent.getBooleanExtra("from_alert", false));
        }
    }

    private static boolean handleIAMPreviewOpen(@NonNull Context context, @NonNull JSONObject jsonData) {
        String previewUUID = NotificationBundleProcessor.inAppPreviewPushUUID(jsonData);
        if (previewUUID == null) {
            return false;
        }
        OneSignal.startOrResumeApp(context);
        OSInAppMessageController.getController().displayPreviewMessage(previewUUID);
        return true;
    }

    private static void addChildNotifications(JSONArray dataArray, String summaryGroup, SQLiteDatabase writableDb) {
        String[] retColumn = new String[]{"full_data"};
        String[] whereArgs = new String[]{summaryGroup};
        Cursor cursor = writableDb.query("notification", retColumn, "group_id = ? AND dismissed = 0 AND opened = 0 AND is_summary = 0", whereArgs, null, null, null);
        if (cursor.getCount() > 1) {
            cursor.moveToFirst();
            do {
                try {
                    String jsonStr = cursor.getString(cursor.getColumnIndex("full_data"));
                    dataArray.put((Object)new JSONObject(jsonStr));
                }
                catch (Throwable t) {
                    OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Could not parse JSON of sub notification in group: " + summaryGroup);
                }
            } while (cursor.moveToNext());
        }
        cursor.close();
    }

    private static void markNotificationsConsumed(Context context, Intent intent, SQLiteDatabase writableDb) {
        String whereStr;
        String group = intent.getStringExtra("summary");
        String[] whereArgs = null;
        if (group != null) {
            whereStr = "group_id = ?";
            whereArgs = new String[]{group};
        } else {
            whereStr = "android_notification_id = " + intent.getIntExtra("notificationId", 0);
        }
        writableDb.update("notification", NotificationOpenedProcessor.newContentValuesWithConsumed(intent), whereStr, whereArgs);
        BadgeCountUpdater.update(writableDb, context);
    }

    private static ContentValues newContentValuesWithConsumed(Intent intent) {
        ContentValues values = new ContentValues();
        boolean dismissed = intent.getBooleanExtra("dismissed", false);
        if (dismissed) {
            values.put("dismissed", Integer.valueOf(1));
        } else {
            values.put("opened", Integer.valueOf(1));
        }
        return values;
    }
}

