/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import com.onesignal.OneSignal;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Scanner;
import org.json.JSONObject;

class OneSignalRestClient {
    private static final String BASE_URL = "https://onesignal.com/api/v1/";
    private static final int TIMEOUT = 120000;
    private static final int GET_TIMEOUT = 60000;

    OneSignalRestClient() {
    }

    private static int getThreadTimeout(int timeout) {
        return timeout + 5000;
    }

    static void put(final String url, final JSONObject jsonBody, final ResponseHandler responseHandler) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                OneSignalRestClient.makeRequest(url, "PUT", jsonBody, responseHandler, 120000);
            }
        }).start();
    }

    static void post(final String url, final JSONObject jsonBody, final ResponseHandler responseHandler) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                OneSignalRestClient.makeRequest(url, "POST", jsonBody, responseHandler, 120000);
            }
        }).start();
    }

    static void get(final String url, final ResponseHandler responseHandler) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                OneSignalRestClient.makeRequest(url, null, null, responseHandler, 60000);
            }
        }).start();
    }

    static void getSync(String url, ResponseHandler responseHandler) {
        OneSignalRestClient.makeRequest(url, null, null, responseHandler, 60000);
    }

    static void putSync(String url, JSONObject jsonBody, ResponseHandler responseHandler) {
        OneSignalRestClient.makeRequest(url, "PUT", jsonBody, responseHandler, 120000);
    }

    static void postSync(String url, JSONObject jsonBody, ResponseHandler responseHandler) {
        OneSignalRestClient.makeRequest(url, "POST", jsonBody, responseHandler, 120000);
    }

    private static void makeRequest(final String url, final String method, final JSONObject jsonBody, final ResponseHandler responseHandler, final int timeout) {
        if (method != null && OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName(null)) {
            return;
        }
        final Thread[] callbackThread = new Thread[1];
        Thread connectionThread = new Thread(new Runnable(){

            @Override
            public void run() {
                callbackThread[0] = OneSignalRestClient.startHTTPConnection(url, method, jsonBody, responseHandler, timeout);
            }
        }, "OS_HTTPConnection");
        connectionThread.start();
        try {
            connectionThread.join(OneSignalRestClient.getThreadTimeout(timeout));
            if (connectionThread.getState() != Thread.State.TERMINATED) {
                connectionThread.interrupt();
            }
            if (callbackThread[0] != null) {
                callbackThread[0].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Thread startHTTPConnection(String url, String method, JSONObject jsonBody, ResponseHandler responseHandler, int timeout) {
        HttpURLConnection con = null;
        int httpResponse = -1;
        String json = null;
        Thread callbackThread = null;
        try {
            Scanner scanner;
            InputStream inputStream;
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "OneSignalRestClient: Making request to: https://onesignal.com/api/v1/" + url);
            con = (HttpURLConnection)new URL(BASE_URL + url).openConnection();
            con.setUseCaches(false);
            con.setConnectTimeout(timeout);
            con.setReadTimeout(timeout);
            if (jsonBody != null) {
                con.setDoInput(true);
            }
            if (method != null) {
                con.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                con.setRequestMethod(method);
                con.setDoOutput(true);
            }
            if (jsonBody != null) {
                String strJsonBody = jsonBody.toString();
                OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "OneSignalRestClient: " + method + " SEND JSON: " + strJsonBody);
                byte[] sendBytes = strJsonBody.getBytes("UTF-8");
                con.setFixedLengthStreamingMode(sendBytes.length);
                OutputStream outputStream = con.getOutputStream();
                outputStream.write(sendBytes);
            }
            httpResponse = con.getResponseCode();
            OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "OneSignalRestClient: After con.getResponseCode  to: https://onesignal.com/api/v1/" + url);
            if (httpResponse == 200) {
                OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "OneSignalRestClient: Successfully finished request to: https://onesignal.com/api/v1/" + url);
                inputStream = con.getInputStream();
                scanner = new Scanner(inputStream, "UTF-8");
                json = scanner.useDelimiter("\\A").hasNext() ? scanner.next() : "";
                scanner.close();
                OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, method + " RECEIVED JSON: " + json);
                callbackThread = OneSignalRestClient.callResponseHandlerOnSuccess(responseHandler, json);
            } else {
                OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "OneSignalRestClient: Failed request to: https://onesignal.com/api/v1/" + url);
                inputStream = con.getErrorStream();
                if (inputStream == null) {
                    inputStream = con.getInputStream();
                }
                if (inputStream != null) {
                    scanner = new Scanner(inputStream, "UTF-8");
                    json = scanner.useDelimiter("\\A").hasNext() ? scanner.next() : "";
                    scanner.close();
                    OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "OneSignalRestClient: " + method + " RECEIVED JSON: " + json);
                } else {
                    OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "OneSignalRestClient: " + method + " HTTP Code: " + httpResponse + " No response body!");
                }
                callbackThread = OneSignalRestClient.callResponseHandlerOnFailure(responseHandler, httpResponse, json, null);
            }
        }
        catch (Throwable t) {
            if (t instanceof ConnectException || t instanceof UnknownHostException) {
                OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "OneSignalRestClient: Could not send last request, device is offline. Throwable: " + t.getClass().getName());
            } else {
                OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "OneSignalRestClient: " + method + " Error thrown from network stack. ", t);
            }
            callbackThread = OneSignalRestClient.callResponseHandlerOnFailure(responseHandler, httpResponse, null, t);
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        return callbackThread;
    }

    private static Thread callResponseHandlerOnSuccess(final ResponseHandler handler, final String response) {
        if (handler == null) {
            return null;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                handler.onSuccess(response);
            }
        });
        thread.start();
        return thread;
    }

    private static Thread callResponseHandlerOnFailure(final ResponseHandler handler, final int statusCode, final String response, final Throwable throwable) {
        if (handler == null) {
            return null;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                handler.onFailure(statusCode, response, throwable);
            }
        });
        thread.start();
        return thread;
    }

    static class ResponseHandler {
        ResponseHandler() {
        }

        void onSuccess(String response) {
        }

        void onFailure(int statusCode, String response, Throwable throwable) {
        }
    }
}

