/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Application;
import android.app.NotificationManager;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.Base64;
import android.util.Log;
import com.onesignal.ActivityLifecycleHandler;
import com.onesignal.ActivityLifecycleListener;
import com.onesignal.AdvertisingIdProviderGPS;
import com.onesignal.AdvertisingIdentifierProvider;
import com.onesignal.BadgeCountUpdater;
import com.onesignal.DelayedConsentInitializationParameters;
import com.onesignal.LocationGMS;
import com.onesignal.NotificationBundleProcessor;
import com.onesignal.NotificationChannelManager;
import com.onesignal.NotificationRestorer;
import com.onesignal.NotificationSummaryManager;
import com.onesignal.OSEmailSubscriptionChangedInternalObserver;
import com.onesignal.OSEmailSubscriptionObserver;
import com.onesignal.OSEmailSubscriptionState;
import com.onesignal.OSEmailSubscriptionStateChanges;
import com.onesignal.OSNotification;
import com.onesignal.OSNotificationAction;
import com.onesignal.OSNotificationOpenResult;
import com.onesignal.OSNotificationPayload;
import com.onesignal.OSObservable;
import com.onesignal.OSPermissionChangedInternalObserver;
import com.onesignal.OSPermissionObserver;
import com.onesignal.OSPermissionState;
import com.onesignal.OSPermissionStateChanges;
import com.onesignal.OSPermissionSubscriptionState;
import com.onesignal.OSSubscriptionChangedInternalObserver;
import com.onesignal.OSSubscriptionObserver;
import com.onesignal.OSSubscriptionState;
import com.onesignal.OSSubscriptionStateChanges;
import com.onesignal.OSUtils;
import com.onesignal.OneSignalChromeTab;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.OneSignalPrefs;
import com.onesignal.OneSignalRestClient;
import com.onesignal.OneSignalStateSynchronizer;
import com.onesignal.OneSignalSyncServiceUtils;
import com.onesignal.PushRegistrator;
import com.onesignal.PushRegistratorADM;
import com.onesignal.PushRegistratorFCM;
import com.onesignal.PushRegistratorGCM;
import com.onesignal.RootToolsInternalMethods;
import com.onesignal.TrackAmazonPurchase;
import com.onesignal.TrackFirebaseAnalytics;
import com.onesignal.TrackGooglePurchase;
import com.onesignal.UserStateSynchronizer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OneSignal {
    static final long MIN_ON_FOCUS_TIME = 60L;
    private static final long MIN_ON_SESSION_TIME = 30L;
    private static EmailUpdateHandler emailUpdateHandler;
    private static EmailUpdateHandler emailLogoutHandler;
    static String appId;
    private static String mGoogleProjectNumber;
    private static boolean mGoogleProjectNumberIsRemote;
    static Context appContext;
    private static LOG_LEVEL visualLogLevel;
    private static LOG_LEVEL logCatLevel;
    private static String userId;
    private static String emailId;
    private static int subscribableStatus;
    static boolean initDone;
    private static boolean foreground;
    static ExecutorService pendingTaskExecutor;
    public static ConcurrentLinkedQueue<Runnable> taskQueueWaitingForInit;
    static AtomicLong lastTaskId;
    private static IdsAvailableHandler idsAvailableHandler;
    private static long lastTrackedFocusTime;
    private static long unSentActiveTime;
    private static TrackGooglePurchase trackGooglePurchase;
    private static TrackAmazonPurchase trackAmazonPurchase;
    private static TrackFirebaseAnalytics trackFirebaseAnalytics;
    public static final String VERSION = "031000";
    private static AdvertisingIdentifierProvider mainAdIdProvider;
    private static int deviceType;
    public static String sdkType;
    private static OSUtils osUtils;
    private static String lastRegistrationId;
    private static boolean registerForPushFired;
    private static boolean locationFired;
    private static boolean awlFired;
    private static boolean promptedLocation;
    private static LocationGMS.LocationPoint lastLocationPoint;
    static boolean shareLocation;
    static Builder mInitBuilder;
    private static Collection<JSONArray> unprocessedOpenedNotifis;
    private static HashSet<String> postedOpenedNotifIds;
    private static GetTagsHandler pendingGetTagsHandler;
    private static boolean getTagsCall;
    private static boolean waitingToPostStateSync;
    private static boolean sendAsSession;
    private static JSONObject awl;
    static boolean mEnterp;
    private static boolean useEmailAuth;
    static boolean requiresUserPrivacyConsent;
    static DelayedConsentInitializationParameters delayedInitParams;
    private static OSPermissionState currentPermissionState;
    static OSPermissionState lastPermissionState;
    private static OSObservable<OSPermissionObserver, OSPermissionStateChanges> permissionStateChangesObserver;
    private static OSSubscriptionState currentSubscriptionState;
    static OSSubscriptionState lastSubscriptionState;
    private static OSObservable<OSSubscriptionObserver, OSSubscriptionStateChanges> subscriptionStateChangesObserver;
    private static OSEmailSubscriptionState currentEmailSubscriptionState;
    static OSEmailSubscriptionState lastEmailSubscriptionState;
    private static OSObservable<OSEmailSubscriptionObserver, OSEmailSubscriptionStateChanges> emailSubscriptionStateChangesObserver;
    private static IAPUpdateJob iapUpdateJob;
    private static PushRegistrator mPushRegistrator;
    private static int androidParamsReties;

    private static OSPermissionState getCurrentPermissionState(Context context) {
        if (context == null) {
            return null;
        }
        if (currentPermissionState == null) {
            currentPermissionState = new OSPermissionState(false);
            OneSignal.currentPermissionState.observable.addObserverStrong(new OSPermissionChangedInternalObserver());
        }
        return currentPermissionState;
    }

    private static OSPermissionState getLastPermissionState(Context context) {
        if (context == null) {
            return null;
        }
        if (lastPermissionState == null) {
            lastPermissionState = new OSPermissionState(true);
        }
        return lastPermissionState;
    }

    static OSObservable<OSPermissionObserver, OSPermissionStateChanges> getPermissionStateChangesObserver() {
        if (permissionStateChangesObserver == null) {
            permissionStateChangesObserver = new OSObservable("onOSPermissionChanged", true);
        }
        return permissionStateChangesObserver;
    }

    private static OSSubscriptionState getCurrentSubscriptionState(Context context) {
        if (context == null) {
            return null;
        }
        if (currentSubscriptionState == null) {
            currentSubscriptionState = new OSSubscriptionState(false, OneSignal.getCurrentPermissionState(context).getEnabled());
            OneSignal.getCurrentPermissionState((Context)context).observable.addObserver(currentSubscriptionState);
            OneSignal.currentSubscriptionState.observable.addObserverStrong(new OSSubscriptionChangedInternalObserver());
        }
        return currentSubscriptionState;
    }

    private static OSSubscriptionState getLastSubscriptionState(Context context) {
        if (context == null) {
            return null;
        }
        if (lastSubscriptionState == null) {
            lastSubscriptionState = new OSSubscriptionState(true, false);
        }
        return lastSubscriptionState;
    }

    static OSObservable<OSSubscriptionObserver, OSSubscriptionStateChanges> getSubscriptionStateChangesObserver() {
        if (subscriptionStateChangesObserver == null) {
            subscriptionStateChangesObserver = new OSObservable("onOSSubscriptionChanged", true);
        }
        return subscriptionStateChangesObserver;
    }

    private static OSEmailSubscriptionState getCurrentEmailSubscriptionState(Context context) {
        if (context == null) {
            return null;
        }
        if (currentEmailSubscriptionState == null) {
            currentEmailSubscriptionState = new OSEmailSubscriptionState(false);
            OneSignal.currentEmailSubscriptionState.observable.addObserverStrong(new OSEmailSubscriptionChangedInternalObserver());
        }
        return currentEmailSubscriptionState;
    }

    private static OSEmailSubscriptionState getLastEmailSubscriptionState(Context context) {
        if (context == null) {
            return null;
        }
        if (lastEmailSubscriptionState == null) {
            lastEmailSubscriptionState = new OSEmailSubscriptionState(true);
        }
        return lastEmailSubscriptionState;
    }

    static OSObservable<OSEmailSubscriptionObserver, OSEmailSubscriptionStateChanges> getEmailSubscriptionStateChangesObserver() {
        if (emailSubscriptionStateChangesObserver == null) {
            emailSubscriptionStateChangesObserver = new OSObservable("onOSEmailSubscriptionChanged", true);
        }
        return emailSubscriptionStateChangesObserver;
    }

    public static Builder getCurrentOrNewInitBuilder() {
        if (mInitBuilder == null) {
            mInitBuilder = new Builder();
        }
        return mInitBuilder;
    }

    static void setAppContext(Context context) {
        appContext = context.getApplicationContext();
        OneSignalPrefs.startDelayedWrite();
    }

    public static Builder startInit(Context context) {
        return new Builder(context);
    }

    private static void init(Builder inBuilder) {
        if (OneSignal.getCurrentOrNewInitBuilder().mDisplayOptionCarryOver) {
            inBuilder.mDisplayOption = OneSignal.getCurrentOrNewInitBuilder().mDisplayOption;
        }
        mInitBuilder = inBuilder;
        Context context = OneSignal.mInitBuilder.mContext;
        OneSignal.mInitBuilder.mContext = null;
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            String sender_id = bundle.getString("onesignal_google_project_number");
            if (sender_id != null && sender_id.length() > 4) {
                sender_id = sender_id.substring(4);
            }
            String requireSetting = bundle.getString("com.onesignal.PrivacyConsent");
            OneSignal.setRequiresUserPrivacyConsent("ENABLE".equalsIgnoreCase(requireSetting));
            OneSignal.init(context, sender_id, bundle.getString("onesignal_app_id"), OneSignal.mInitBuilder.mNotificationOpenedHandler, OneSignal.mInitBuilder.mNotificationReceivedHandler);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void init(Context context, String googleProjectNumber, String oneSignalAppId) {
        OneSignal.init(context, googleProjectNumber, oneSignalAppId, null, null);
    }

    public static void init(Context context, String googleProjectNumber, String oneSignalAppId, NotificationOpenedHandler notificationOpenedHandler) {
        OneSignal.init(context, googleProjectNumber, oneSignalAppId, notificationOpenedHandler, null);
    }

    public static void init(Context context, String googleProjectNumber, String oneSignalAppId, NotificationOpenedHandler notificationOpenedHandler, NotificationReceivedHandler notificationReceivedHandler) {
        boolean contextIsActivity;
        OneSignal.setAppContext(context);
        if (requiresUserPrivacyConsent && !OneSignal.userProvidedPrivacyConsent()) {
            OneSignal.Log(LOG_LEVEL.VERBOSE, "OneSignal SDK initialization delayed, user privacy consent is set to required for this application.");
            delayedInitParams = new DelayedConsentInitializationParameters(context, googleProjectNumber, oneSignalAppId, notificationOpenedHandler, notificationReceivedHandler);
            return;
        }
        mInitBuilder = OneSignal.getCurrentOrNewInitBuilder();
        OneSignal.mInitBuilder.mDisplayOptionCarryOver = false;
        OneSignal.mInitBuilder.mNotificationOpenedHandler = notificationOpenedHandler;
        OneSignal.mInitBuilder.mNotificationReceivedHandler = notificationReceivedHandler;
        if (!mGoogleProjectNumberIsRemote) {
            mGoogleProjectNumber = googleProjectNumber;
        }
        if ((subscribableStatus = (osUtils = new OSUtils()).initializationChecker(context, deviceType = osUtils.getDeviceType(), oneSignalAppId)) == -999) {
            return;
        }
        if (initDone) {
            if (OneSignal.mInitBuilder.mNotificationOpenedHandler != null) {
                OneSignal.fireCallbackForOpenedNotifications();
            }
            return;
        }
        foreground = contextIsActivity = context instanceof Activity;
        appId = oneSignalAppId;
        OneSignal.saveFilterOtherGCMReceivers(OneSignal.mInitBuilder.mFilterOtherGCMReceivers);
        if (contextIsActivity) {
            ActivityLifecycleHandler.curActivity = (Activity)context;
            NotificationRestorer.asyncRestore(appContext);
        } else {
            ActivityLifecycleHandler.nextResumeIsFirstActivity = true;
        }
        lastTrackedFocusTime = SystemClock.elapsedRealtime();
        OneSignalStateSynchronizer.initUserState();
        ((Application)appContext).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new ActivityLifecycleListener());
        try {
            Class.forName("com.amazon.device.iap.PurchasingListener");
            trackAmazonPurchase = new TrackAmazonPurchase(appContext);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        String oldAppId = OneSignal.getSavedAppId();
        if (oldAppId != null) {
            if (!oldAppId.equals(appId)) {
                OneSignal.Log(LOG_LEVEL.DEBUG, "APP ID changed, clearing user id as it is no longer valid.");
                OneSignal.SaveAppId(appId);
                OneSignalStateSynchronizer.resetCurrentState();
            }
        } else {
            BadgeCountUpdater.updateCount(0, appContext);
            OneSignal.SaveAppId(appId);
        }
        OSPermissionChangedInternalObserver.handleInternalChanges(OneSignal.getCurrentPermissionState(appContext));
        if (foreground || OneSignal.getUserId() == null) {
            sendAsSession = OneSignal.isPastOnSessionTime();
            OneSignal.setLastSessionTime(System.currentTimeMillis());
            OneSignal.startRegistrationOrOnSession();
        }
        if (OneSignal.mInitBuilder.mNotificationOpenedHandler != null) {
            OneSignal.fireCallbackForOpenedNotifications();
        }
        if (TrackGooglePurchase.CanTrack(appContext)) {
            trackGooglePurchase = new TrackGooglePurchase(appContext);
        }
        if (TrackFirebaseAnalytics.CanTrack()) {
            trackFirebaseAnalytics = new TrackFirebaseAnalytics(appContext);
        }
        PushRegistratorFCM.disableFirebaseInstanceIdService(appContext);
        initDone = true;
        OneSignal.startPendingTasks();
    }

    private static void onTaskRan(long taskId) {
        if (lastTaskId.get() == taskId) {
            OneSignal.Log(LOG_LEVEL.INFO, "Last Pending Task has ran, shutting down");
            pendingTaskExecutor.shutdown();
        }
    }

    private static void startPendingTasks() {
        if (!taskQueueWaitingForInit.isEmpty()) {
            pendingTaskExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(@NonNull Runnable runnable) {
                    Thread newThread = new Thread(runnable);
                    newThread.setName("OS_PENDING_EXECUTOR_" + newThread.getId());
                    return newThread;
                }
            });
            while (!taskQueueWaitingForInit.isEmpty()) {
                pendingTaskExecutor.submit(taskQueueWaitingForInit.poll());
            }
        }
    }

    private static void addTaskToQueue(PendingTaskRunnable task) {
        task.taskId = OneSignal.lastTaskId.incrementAndGet();
        if (pendingTaskExecutor == null) {
            OneSignal.Log(LOG_LEVEL.INFO, "Adding a task to the pending queue with ID: " + task.taskId);
            taskQueueWaitingForInit.add(task);
        } else if (!pendingTaskExecutor.isShutdown()) {
            OneSignal.Log(LOG_LEVEL.INFO, "Executor is still running, add to the executor with ID: " + task.taskId);
            pendingTaskExecutor.submit(task);
        }
    }

    private static boolean shouldRunTaskThroughQueue() {
        if (initDone && pendingTaskExecutor == null) {
            return false;
        }
        if (!initDone && pendingTaskExecutor == null) {
            return true;
        }
        return pendingTaskExecutor != null && !pendingTaskExecutor.isShutdown();
    }

    private static void startRegistrationOrOnSession() {
        if (waitingToPostStateSync) {
            return;
        }
        waitingToPostStateSync = true;
        registerForPushFired = false;
        if (sendAsSession) {
            locationFired = false;
        }
        OneSignal.startLocationUpdate();
        OneSignal.makeAndroidParamsRequest();
        promptedLocation = promptedLocation || OneSignal.mInitBuilder.mPromptLocation;
    }

    private static void startLocationUpdate() {
        LocationGMS.LocationHandler locationHandler = new LocationGMS.LocationHandler(){

            @Override
            public LocationGMS.CALLBACK_TYPE getType() {
                return LocationGMS.CALLBACK_TYPE.STARTUP;
            }

            @Override
            public void complete(LocationGMS.LocationPoint point) {
                lastLocationPoint = point;
                locationFired = true;
                OneSignal.registerUser();
            }
        };
        boolean doPrompt = OneSignal.mInitBuilder.mPromptLocation && !promptedLocation;
        LocationGMS.getLocation(appContext, doPrompt, locationHandler);
    }

    private static PushRegistrator getPushRegistrator() {
        if (mPushRegistrator != null) {
            return mPushRegistrator;
        }
        mPushRegistrator = deviceType == 2 ? new PushRegistratorADM() : (OSUtils.hasFCMLibrary() ? new PushRegistratorFCM() : new PushRegistratorGCM());
        return mPushRegistrator;
    }

    private static void registerForPushToken() {
        OneSignal.getPushRegistrator().registerForPush(appContext, mGoogleProjectNumber, new PushRegistrator.RegisteredHandler(){

            @Override
            public void complete(String id2, int status) {
                if (status < 1) {
                    if (OneSignalStateSynchronizer.getRegistrationId() == null && (subscribableStatus == 1 || OneSignal.pushStatusRuntimeError(subscribableStatus))) {
                        subscribableStatus = status;
                    }
                } else if (OneSignal.pushStatusRuntimeError(subscribableStatus)) {
                    subscribableStatus = status;
                }
                lastRegistrationId = id2;
                registerForPushFired = true;
                OneSignal.getCurrentSubscriptionState(appContext).setPushToken(id2);
                OneSignal.registerUser();
            }
        });
    }

    private static boolean pushStatusRuntimeError(int subscribableStatus) {
        return subscribableStatus < -6;
    }

    private static void makeAndroidParamsRequest() {
        if (awlFired) {
            OneSignal.registerForPushToken();
            return;
        }
        OneSignalRestClient.ResponseHandler responseHandler = new OneSignalRestClient.ResponseHandler(){

            @Override
            void onFailure(int statusCode, String response, Throwable throwable) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            int sleepTime = 30000 + androidParamsReties * 10000;
                            if (sleepTime > 90000) {
                                sleepTime = 90000;
                            }
                            OneSignal.Log(LOG_LEVEL.INFO, "Failed to get Android parameters, trying again in " + sleepTime / 1000 + " seconds.");
                            Thread.sleep(sleepTime);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        androidParamsReties++;
                        OneSignal.makeAndroidParamsRequest();
                    }
                }, "OS_PARAMS_REQUEST").start();
            }

            @Override
            void onSuccess(String response) {
                try {
                    JSONObject responseJson = new JSONObject(response);
                    if (responseJson.has("android_sender_id")) {
                        mGoogleProjectNumberIsRemote = true;
                        mGoogleProjectNumber = responseJson.getString("android_sender_id");
                    }
                    mEnterp = responseJson.optBoolean("enterp", false);
                    useEmailAuth = responseJson.optBoolean("use_email_auth", false);
                    awl = responseJson.getJSONObject("awl_list");
                    boolean firebaseAnalytics = responseJson.optBoolean("fba", false);
                    OneSignalPrefs.saveBool(OneSignalPrefs.PREFS_ONESIGNAL, "GT_FIREBASE_TRACKING_ENABLED", firebaseAnalytics);
                    NotificationChannelManager.processChannelList(appContext, responseJson);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                awlFired = true;
                OneSignal.registerForPushToken();
            }
        };
        String awl_url = "apps/" + appId + "/android_params.js";
        String userId = OneSignal.getUserId();
        if (userId != null) {
            awl_url = awl_url + "?player_id=" + userId;
        }
        OneSignal.Log(LOG_LEVEL.DEBUG, "Starting request to get Android parameters.");
        OneSignalRestClient.get(awl_url, responseHandler);
    }

    private static void fireCallbackForOpenedNotifications() {
        for (JSONArray dataArray : unprocessedOpenedNotifis) {
            OneSignal.runNotificationOpenedCallback(dataArray, true, false);
        }
        unprocessedOpenedNotifis.clear();
    }

    public static void onesignalLog(LOG_LEVEL level, String message) {
        OneSignal.Log(level, message);
    }

    public static boolean userProvidedPrivacyConsent() {
        return OneSignal.getSavedUserConsentStatus();
    }

    public static void provideUserConsent(boolean consent) {
        boolean previousConsentStatus = OneSignal.userProvidedPrivacyConsent();
        OneSignal.saveUserConsentStatus(consent);
        if (!previousConsentStatus && consent && delayedInitParams != null) {
            OneSignal.init(OneSignal.delayedInitParams.context, OneSignal.delayedInitParams.googleProjectNumber, OneSignal.delayedInitParams.appId, OneSignal.delayedInitParams.openedHandler, OneSignal.delayedInitParams.receivedHandler);
            delayedInitParams = null;
        }
    }

    public static void setRequiresUserPrivacyConsent(boolean required) {
        if (requiresUserPrivacyConsent && !required) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Cannot change requiresUserPrivacyConsent() from TRUE to FALSE");
            return;
        }
        requiresUserPrivacyConsent = required;
    }

    public static boolean requiresUserPrivacyConsent() {
        return requiresUserPrivacyConsent && !OneSignal.userProvidedPrivacyConsent();
    }

    static boolean shouldLogUserPrivacyConsentErrorMessageForMethodName(String methodName) {
        if (requiresUserPrivacyConsent && !OneSignal.userProvidedPrivacyConsent()) {
            if (methodName != null) {
                OneSignal.Log(LOG_LEVEL.WARN, "Method " + methodName + " was called before the user provided privacy consent. Your application is set to require the user's privacy consent before the OneSignal SDK can be initialized. Please ensure the user has provided consent before calling this method. You can check the latest OneSignal consent status by calling OneSignal.userProvidedPrivacyConsent()");
            }
            return true;
        }
        return false;
    }

    public static void setLogLevel(LOG_LEVEL inLogCatLevel, LOG_LEVEL inVisualLogLevel) {
        logCatLevel = inLogCatLevel;
        visualLogLevel = inVisualLogLevel;
    }

    public static void setLogLevel(int inLogCatLevel, int inVisualLogLevel) {
        OneSignal.setLogLevel(OneSignal.getLogLevel(inLogCatLevel), OneSignal.getLogLevel(inVisualLogLevel));
    }

    private static LOG_LEVEL getLogLevel(int level) {
        switch (level) {
            case 0: {
                return LOG_LEVEL.NONE;
            }
            case 1: {
                return LOG_LEVEL.FATAL;
            }
            case 2: {
                return LOG_LEVEL.ERROR;
            }
            case 3: {
                return LOG_LEVEL.WARN;
            }
            case 4: {
                return LOG_LEVEL.INFO;
            }
            case 5: {
                return LOG_LEVEL.DEBUG;
            }
            case 6: {
                return LOG_LEVEL.VERBOSE;
            }
        }
        if (level < 0) {
            return LOG_LEVEL.NONE;
        }
        return LOG_LEVEL.VERBOSE;
    }

    private static boolean atLogLevel(LOG_LEVEL level) {
        return level.compareTo(visualLogLevel) < 1 || level.compareTo(logCatLevel) < 1;
    }

    static void Log(LOG_LEVEL level, String message) {
        OneSignal.Log(level, message, null);
    }

    static void Log(final LOG_LEVEL level, String message, Throwable throwable) {
        String TAG = "OneSignal";
        if (level.compareTo(logCatLevel) < 1) {
            if (level == LOG_LEVEL.VERBOSE) {
                Log.v((String)"OneSignal", (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.DEBUG) {
                Log.d((String)"OneSignal", (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.INFO) {
                Log.i((String)"OneSignal", (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.WARN) {
                Log.w((String)"OneSignal", (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.ERROR || level == LOG_LEVEL.FATAL) {
                Log.e((String)"OneSignal", (String)message, (Throwable)throwable);
            }
        }
        if (level.compareTo(visualLogLevel) < 1 && ActivityLifecycleHandler.curActivity != null) {
            try {
                String fullMessage = message + "\n";
                if (throwable != null) {
                    fullMessage = fullMessage + throwable.getMessage();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    throwable.printStackTrace(pw);
                    fullMessage = fullMessage + sw.toString();
                }
                final String finalFullMessage = fullMessage;
                OSUtils.runOnMainUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (ActivityLifecycleHandler.curActivity != null) {
                            new AlertDialog.Builder((Context)ActivityLifecycleHandler.curActivity).setTitle((CharSequence)level.toString()).setMessage((CharSequence)finalFullMessage).show();
                        }
                    }
                });
            }
            catch (Throwable t) {
                Log.e((String)"OneSignal", (String)"Error showing logging message.", (Throwable)t);
            }
        }
    }

    private static void logHttpError(String errorString, int statusCode, Throwable throwable, String errorResponse) {
        String jsonError = "";
        if (errorResponse != null && OneSignal.atLogLevel(LOG_LEVEL.INFO)) {
            jsonError = "\n" + errorResponse + "\n";
        }
        OneSignal.Log(LOG_LEVEL.WARN, "HTTP code: " + statusCode + " " + errorString + jsonError, throwable);
    }

    @WorkerThread
    static boolean onAppLostFocus() {
        foreground = false;
        LocationGMS.onFocusChange();
        if (!initDone) {
            return false;
        }
        if (trackAmazonPurchase != null) {
            trackAmazonPurchase.checkListener();
        }
        if (lastTrackedFocusTime == -1L) {
            return false;
        }
        long time_elapsed = (long)((double)(SystemClock.elapsedRealtime() - lastTrackedFocusTime) / 1000.0 + 0.5);
        lastTrackedFocusTime = SystemClock.elapsedRealtime();
        if (time_elapsed < 0L || time_elapsed > 86400L) {
            return false;
        }
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Android Context not found, please call OneSignal.init when your app starts.");
            return false;
        }
        boolean scheduleSyncService = OneSignal.scheduleSyncService();
        OneSignal.setLastSessionTime(System.currentTimeMillis());
        long unSentActiveTime = OneSignal.GetUnsentActiveTime();
        long totalTimeActive = unSentActiveTime + time_elapsed;
        OneSignal.SaveUnsentActiveTime(totalTimeActive);
        if (totalTimeActive < 60L || OneSignal.getUserId() == null) {
            return totalTimeActive >= 60L;
        }
        if (!scheduleSyncService) {
            OneSignalSyncServiceUtils.scheduleSyncTask(appContext);
        }
        OneSignalSyncServiceUtils.syncOnFocusTime();
        return false;
    }

    static boolean scheduleSyncService() {
        boolean locationScheduled;
        boolean unsyncedChanges = OneSignalStateSynchronizer.persist();
        if (unsyncedChanges) {
            OneSignalSyncServiceUtils.scheduleSyncTask(appContext);
        }
        return (locationScheduled = LocationGMS.scheduleUpdate(appContext)) || unsyncedChanges;
    }

    static void sendOnFocus(long totalTimeActive, boolean synchronous) {
        try {
            JSONObject jsonBody = new JSONObject().put("app_id", (Object)appId).put("type", 1).put("state", (Object)"ping").put("active_time", totalTimeActive);
            OneSignal.addNetType(jsonBody);
            OneSignal.sendOnFocusToPlayer(OneSignal.getUserId(), jsonBody, synchronous);
            String emailId = OneSignal.getEmailId();
            if (emailId != null) {
                OneSignal.sendOnFocusToPlayer(emailId, jsonBody, synchronous);
            }
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Generating on_focus:JSON Failed.", t);
        }
    }

    private static void sendOnFocusToPlayer(String userId, JSONObject jsonBody, boolean synchronous) {
        String url = "players/" + userId + "/on_focus";
        OneSignalRestClient.ResponseHandler responseHandler = new OneSignalRestClient.ResponseHandler(){

            @Override
            void onFailure(int statusCode, String response, Throwable throwable) {
                OneSignal.logHttpError("sending on_focus Failed", statusCode, throwable, response);
            }

            @Override
            void onSuccess(String response) {
                OneSignal.SaveUnsentActiveTime(0L);
            }
        };
        if (synchronous) {
            OneSignalRestClient.postSync(url, jsonBody, responseHandler);
        } else {
            OneSignalRestClient.post(url, jsonBody, responseHandler);
        }
    }

    static void onAppFocus() {
        foreground = true;
        LocationGMS.onFocusChange();
        lastTrackedFocusTime = SystemClock.elapsedRealtime();
        sendAsSession = OneSignal.isPastOnSessionTime();
        OneSignal.setLastSessionTime(System.currentTimeMillis());
        OneSignal.startRegistrationOrOnSession();
        if (trackGooglePurchase != null) {
            trackGooglePurchase.trackIAP();
        }
        NotificationRestorer.asyncRestore(appContext);
        OneSignal.getCurrentPermissionState(appContext).refreshAsTo();
        if (trackFirebaseAnalytics != null && OneSignal.getFirebaseAnalyticsEnabled(appContext)) {
            trackFirebaseAnalytics.trackInfluenceOpenEvent();
        }
        OneSignalSyncServiceUtils.cancelSyncTask(appContext);
    }

    static boolean isForeground() {
        return foreground;
    }

    private static void addNetType(JSONObject jsonObj) {
        try {
            jsonObj.put("net_type", (Object)osUtils.getNetType());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static int getTimeZoneOffset() {
        TimeZone timezone = Calendar.getInstance().getTimeZone();
        int offset = timezone.getRawOffset();
        if (timezone.inDaylightTime(new Date())) {
            offset += timezone.getDSTSavings();
        }
        return offset / 1000;
    }

    private static void registerUser() {
        OneSignal.Log(LOG_LEVEL.DEBUG, "registerUser: registerForPushFired:" + registerForPushFired + ", locationFired: " + locationFired + ", awlFired: " + awlFired);
        if (!(registerForPushFired && locationFired && awlFired)) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    OneSignal.registerUserTask();
                    OneSignalChromeTab.setup(appContext, appId, userId, AdvertisingIdProviderGPS.getLastValue());
                }
                catch (JSONException t) {
                    OneSignal.Log(LOG_LEVEL.FATAL, "FATAL Error registering device!", t);
                }
            }
        }, "OS_REG_USER").start();
    }

    private static void registerUserTask() throws JSONException {
        String packageName = appContext.getPackageName();
        PackageManager packageManager = appContext.getPackageManager();
        JSONObject deviceInfo = new JSONObject();
        deviceInfo.put("app_id", (Object)appId);
        String adId = mainAdIdProvider.getIdentifier(appContext);
        if (adId != null) {
            deviceInfo.put("ad_id", (Object)adId);
        }
        deviceInfo.put("device_os", (Object)Build.VERSION.RELEASE);
        deviceInfo.put("timezone", OneSignal.getTimeZoneOffset());
        deviceInfo.put("language", (Object)OSUtils.getCorrectedLanguage());
        deviceInfo.put("sdk", (Object)VERSION);
        deviceInfo.put("sdk_type", (Object)sdkType);
        deviceInfo.put("android_package", (Object)packageName);
        deviceInfo.put("device_model", (Object)Build.MODEL);
        try {
            deviceInfo.put("game_version", packageManager.getPackageInfo((String)packageName, (int)0).versionCode);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        try {
            List packList = packageManager.getInstalledPackages(0);
            JSONArray pkgs = new JSONArray();
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            for (int i = 0; i < packList.size(); ++i) {
                md.update(((PackageInfo)packList.get((int)i)).packageName.getBytes());
                String pck = Base64.encodeToString((byte[])md.digest(), (int)2);
                if (!awl.has(pck)) continue;
                pkgs.put((Object)pck);
            }
            deviceInfo.put("pkgs", (Object)pkgs);
        }
        catch (Throwable packList) {
            // empty catch block
        }
        deviceInfo.put("net_type", (Object)osUtils.getNetType());
        deviceInfo.put("carrier", (Object)osUtils.getCarrierName());
        deviceInfo.put("rooted", RootToolsInternalMethods.isRooted());
        OneSignalStateSynchronizer.updateDeviceInfo(deviceInfo);
        JSONObject pushState = new JSONObject();
        pushState.put("identifier", (Object)lastRegistrationId);
        pushState.put("subscribableStatus", subscribableStatus);
        pushState.put("androidPermission", OneSignal.areNotificationsEnabledForSubscribedState());
        pushState.put("device_type", deviceType);
        OneSignalStateSynchronizer.updatePushState(pushState);
        if (shareLocation && lastLocationPoint != null) {
            OneSignalStateSynchronizer.updateLocation(lastLocationPoint);
        }
        if (sendAsSession) {
            OneSignalStateSynchronizer.setSyncAsNewSession();
        }
        waitingToPostStateSync = false;
    }

    @Deprecated
    public static void syncHashedEmail(final String email) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("SyncHashedEmail()")) {
            return;
        }
        if (!OSUtils.isValidEmail(email)) {
            return;
        }
        Runnable runSyncHashedEmail = new Runnable(){

            @Override
            public void run() {
                String trimmedEmail = email.trim();
                OneSignalStateSynchronizer.syncHashedEmail(trimmedEmail.toLowerCase());
            }
        };
        if (appContext == null || OneSignal.shouldRunTaskThroughQueue()) {
            OneSignal.Log(LOG_LEVEL.ERROR, "You should initialize OneSignal before calling syncHashedEmail! Moving this operation to a pending task queue.");
            OneSignal.addTaskToQueue(new PendingTaskRunnable(runSyncHashedEmail));
            return;
        }
        runSyncHashedEmail.run();
    }

    public static void setEmail(@NonNull String email, EmailUpdateHandler callback) {
        OneSignal.setEmail(email, null, callback);
    }

    public static void setEmail(@NonNull String email) {
        OneSignal.setEmail(email, null, null);
    }

    public static void setEmail(@NonNull String email, @Nullable String emailAuthHash) {
        OneSignal.setEmail(email, emailAuthHash, null);
    }

    public static void setEmail(final @NonNull String email, final @Nullable String emailAuthHash, @Nullable EmailUpdateHandler callback) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("setEmail()")) {
            return;
        }
        if (!OSUtils.isValidEmail(email)) {
            String errorMessage = "Email is invalid";
            if (callback != null) {
                callback.onFailure(new EmailUpdateError(EmailErrorType.VALIDATION, errorMessage));
            }
            OneSignal.Log(LOG_LEVEL.ERROR, errorMessage);
            return;
        }
        if (useEmailAuth && emailAuthHash == null) {
            String errorMessage = "Email authentication (auth token) is set to REQUIRED for this application. Please provide an auth token from your backend server or change the setting in the OneSignal dashboard.";
            if (callback != null) {
                callback.onFailure(new EmailUpdateError(EmailErrorType.REQUIRES_EMAIL_AUTH, errorMessage));
            }
            OneSignal.Log(LOG_LEVEL.ERROR, errorMessage);
            return;
        }
        emailUpdateHandler = callback;
        Runnable runSetEmail = new Runnable(){

            @Override
            public void run() {
                String trimmedEmail = email.trim();
                String internalEmailAuthHash = emailAuthHash;
                if (internalEmailAuthHash != null) {
                    internalEmailAuthHash.toLowerCase();
                }
                OneSignal.getCurrentEmailSubscriptionState(appContext).setEmailAddress(trimmedEmail);
                OneSignalStateSynchronizer.setEmail(trimmedEmail.toLowerCase(), internalEmailAuthHash);
            }
        };
        if (appContext == null || OneSignal.shouldRunTaskThroughQueue()) {
            OneSignal.Log(LOG_LEVEL.ERROR, "You should initialize OneSignal before calling setEmail! Moving this operation to a pending task queue.");
            OneSignal.addTaskToQueue(new PendingTaskRunnable(runSetEmail));
            return;
        }
        runSetEmail.run();
    }

    public static void logoutEmail() {
        OneSignal.logoutEmail(null);
    }

    public static void logoutEmail(@Nullable EmailUpdateHandler callback) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("logoutEmail()")) {
            return;
        }
        if (OneSignal.getEmailId() == null) {
            String message = "logoutEmail not valid as email was not set or already logged out!";
            if (callback != null) {
                callback.onFailure(new EmailUpdateError(EmailErrorType.INVALID_OPERATION, "logoutEmail not valid as email was not set or already logged out!"));
            }
            OneSignal.Log(LOG_LEVEL.ERROR, "logoutEmail not valid as email was not set or already logged out!");
            return;
        }
        emailLogoutHandler = callback;
        Runnable emailLogout = new Runnable(){

            @Override
            public void run() {
                OneSignalStateSynchronizer.logoutEmail();
            }
        };
        if (appContext == null || OneSignal.shouldRunTaskThroughQueue()) {
            OneSignal.Log(LOG_LEVEL.ERROR, "You should initialize OneSignal before calling logoutEmail! Moving this operation to a pending task queue.");
            OneSignal.addTaskToQueue(new PendingTaskRunnable(emailLogout));
            return;
        }
        emailLogout.run();
    }

    public static void sendTag(String key, String value) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("sendTag()")) {
            return;
        }
        try {
            OneSignal.sendTags(new JSONObject().put(key, (Object)value));
        }
        catch (JSONException t) {
            t.printStackTrace();
        }
    }

    public static void sendTags(String jsonString) {
        try {
            OneSignal.sendTags(new JSONObject(jsonString));
        }
        catch (JSONException t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Generating JSONObject for sendTags failed!", t);
        }
    }

    public static void sendTags(JSONObject keyValues) {
        OneSignal.sendTags(keyValues, null);
    }

    public static void sendTags(final JSONObject keyValues, ChangeTagsUpdateHandler handler) {
        final ChangeTagsUpdateHandler tagsHandler = handler;
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("sendTags()")) {
            return;
        }
        Runnable sendTagsRunnable = new Runnable(){

            @Override
            public void run() {
                if (keyValues == null) {
                    if (tagsHandler != null) {
                        tagsHandler.onFailure(new SendTagsError(-1, "Attempted to send null tags"));
                    }
                    return;
                }
                JSONObject existingKeys = OneSignalStateSynchronizer.getTags((boolean)false).result;
                JSONObject toSend = new JSONObject();
                Iterator keys = keyValues.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    try {
                        Object value = keyValues.opt(key);
                        if (value instanceof JSONArray || value instanceof JSONObject) {
                            OneSignal.Log(LOG_LEVEL.ERROR, "Omitting key '" + key + "'! sendTags DO NOT supported nested values!");
                            continue;
                        }
                        if (keyValues.isNull(key) || "".equals(value)) {
                            if (existingKeys == null || !existingKeys.has(key)) continue;
                            toSend.put(key, (Object)"");
                            continue;
                        }
                        toSend.put(key, (Object)value.toString());
                    }
                    catch (Throwable throwable) {}
                }
                if (!toSend.toString().equals("{}")) {
                    OneSignalStateSynchronizer.sendTags(toSend, tagsHandler);
                } else {
                    tagsHandler.onSuccess(existingKeys);
                }
            }
        };
        if (appContext == null || OneSignal.shouldRunTaskThroughQueue()) {
            OneSignal.Log(LOG_LEVEL.ERROR, "You must initialize OneSignal before modifying tags!Moving this operation to a pending task queue.");
            if (tagsHandler != null) {
                tagsHandler.onFailure(new SendTagsError(-1, "You must initialize OneSignal before modifying tags!Moving this operation to a pending task queue."));
            }
            OneSignal.addTaskToQueue(new PendingTaskRunnable(sendTagsRunnable));
            return;
        }
        sendTagsRunnable.run();
    }

    public static void postNotification(String json, PostNotificationResponseHandler handler) {
        try {
            OneSignal.postNotification(new JSONObject(json), handler);
        }
        catch (JSONException e) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Invalid postNotification JSON format: " + json);
        }
    }

    public static void postNotification(JSONObject json, final PostNotificationResponseHandler handler) {
        block6: {
            if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("postNotification()")) {
                return;
            }
            try {
                if (!json.has("app_id")) {
                    json.put("app_id", (Object)OneSignal.getSavedAppId());
                }
                OneSignalRestClient.post("notifications/", json, new OneSignalRestClient.ResponseHandler(){

                    @Override
                    public void onSuccess(String response) {
                        OneSignal.Log(LOG_LEVEL.DEBUG, "HTTP create notification success: " + (response != null ? response : "null"));
                        if (handler != null) {
                            try {
                                JSONObject jsonObject = new JSONObject(response);
                                if (jsonObject.has("errors")) {
                                    handler.onFailure(jsonObject);
                                } else {
                                    handler.onSuccess(new JSONObject(response));
                                }
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                    }

                    @Override
                    void onFailure(int statusCode, String response, Throwable throwable) {
                        OneSignal.logHttpError("create notification failed", statusCode, throwable, response);
                        if (handler != null) {
                            try {
                                if (statusCode == 0) {
                                    response = "{\"error\": \"HTTP no response error\"}";
                                }
                                handler.onFailure(new JSONObject(response));
                            }
                            catch (Throwable t) {
                                try {
                                    handler.onFailure(new JSONObject("{\"error\": \"Unknown response!\"}"));
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                });
            }
            catch (JSONException e) {
                OneSignal.Log(LOG_LEVEL.ERROR, "HTTP create notification json exception!", e);
                if (handler == null) break block6;
                try {
                    handler.onFailure(new JSONObject("{'error': 'HTTP create notification json exception!'}"));
                }
                catch (JSONException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static void getTags(final GetTagsHandler getTagsHandler) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("getTags()")) {
            return;
        }
        pendingGetTagsHandler = getTagsHandler;
        Runnable getTagsRunnable = new Runnable(){

            @Override
            public void run() {
                if (getTagsHandler == null) {
                    OneSignal.Log(LOG_LEVEL.ERROR, "getTagsHandler is null!");
                    return;
                }
                if (OneSignal.getUserId() == null) {
                    return;
                }
                OneSignal.internalFireGetTagsCallback(pendingGetTagsHandler);
            }
        };
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "You must initialize OneSignal before getting tags! Moving this tag operation to a pending queue.");
            taskQueueWaitingForInit.add(getTagsRunnable);
            return;
        }
        getTagsRunnable.run();
    }

    private static void internalFireGetTagsCallback(final GetTagsHandler getTagsHandler) {
        if (getTagsHandler == null) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                UserStateSynchronizer.GetTagsResult tags = OneSignalStateSynchronizer.getTags(!getTagsCall);
                if (tags.serverSuccess) {
                    getTagsCall = true;
                }
                if (tags.result == null || tags.toString().equals("{}")) {
                    getTagsHandler.tagsAvailable(null);
                } else {
                    getTagsHandler.tagsAvailable(tags.result);
                }
            }
        }, "OS_GETTAGS_CALLBACK").start();
    }

    public static void deleteTag(String key) {
        OneSignal.deleteTag(key, null);
    }

    public static void deleteTag(String key, ChangeTagsUpdateHandler handler) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("deleteTag()")) {
            return;
        }
        ArrayList<String> tempList = new ArrayList<String>(1);
        tempList.add(key);
        OneSignal.deleteTags(tempList, handler);
    }

    public static void deleteTags(Collection<String> keys) {
        OneSignal.deleteTags(keys, null);
    }

    public static void deleteTags(Collection<String> keys, ChangeTagsUpdateHandler handler) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("deleteTags()")) {
            return;
        }
        try {
            JSONObject jsonTags = new JSONObject();
            for (String key : keys) {
                jsonTags.put(key, (Object)"");
            }
            OneSignal.sendTags(jsonTags, handler);
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON for deleteTags.", t);
        }
    }

    public static void deleteTags(String jsonArrayString) {
        OneSignal.deleteTags(jsonArrayString, null);
    }

    public static void deleteTags(String jsonArrayString, ChangeTagsUpdateHandler handler) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("deleteTags()")) {
            return;
        }
        try {
            JSONObject jsonTags = new JSONObject();
            JSONArray jsonArray = new JSONArray(jsonArrayString);
            for (int i = 0; i < jsonArray.length(); ++i) {
                jsonTags.put(jsonArray.getString(i), (Object)"");
            }
            OneSignal.sendTags(jsonTags, handler);
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON for deleteTags.", t);
        }
    }

    public static void idsAvailable(IdsAvailableHandler inIdsAvailableHandler) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("idsAvailable()")) {
            return;
        }
        idsAvailableHandler = inIdsAvailableHandler;
        Runnable runIdsAvailable = new Runnable(){

            @Override
            public void run() {
                if (OneSignal.getUserId() != null) {
                    OSUtils.runOnMainUIThread(new Runnable(){

                        @Override
                        public void run() {
                            OneSignal.internalFireIdsAvailableCallback();
                        }
                    });
                }
            }
        };
        if (appContext == null || OneSignal.shouldRunTaskThroughQueue()) {
            OneSignal.Log(LOG_LEVEL.ERROR, "You must initialize OneSignal before getting tags! Moving this tag operation to a pending queue.");
            OneSignal.addTaskToQueue(new PendingTaskRunnable(runIdsAvailable));
            return;
        }
        runIdsAvailable.run();
    }

    static void fireIdsAvailableCallback() {
        if (idsAvailableHandler != null) {
            OSUtils.runOnMainUIThread(new Runnable(){

                @Override
                public void run() {
                    OneSignal.internalFireIdsAvailableCallback();
                }
            });
        }
    }

    private static synchronized void internalFireIdsAvailableCallback() {
        String userId;
        if (idsAvailableHandler == null) {
            return;
        }
        String regId = OneSignalStateSynchronizer.getRegistrationId();
        if (!OneSignalStateSynchronizer.getSubscribed()) {
            regId = null;
        }
        if ((userId = OneSignal.getUserId()) == null) {
            return;
        }
        idsAvailableHandler.idsAvailable(userId, regId);
        if (regId != null) {
            idsAvailableHandler = null;
        }
    }

    static void sendPurchases(JSONArray purchases, boolean newAsExisting, OneSignalRestClient.ResponseHandler responseHandler) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("sendPurchases()")) {
            return;
        }
        if (OneSignal.getUserId() == null) {
            iapUpdateJob = new IAPUpdateJob(purchases);
            OneSignal.iapUpdateJob.newAsExisting = newAsExisting;
            OneSignal.iapUpdateJob.restResponseHandler = responseHandler;
            return;
        }
        try {
            JSONObject jsonBody = new JSONObject();
            jsonBody.put("app_id", (Object)appId);
            if (newAsExisting) {
                jsonBody.put("existing", true);
            }
            jsonBody.put("purchases", (Object)purchases);
            OneSignalRestClient.post("players/" + OneSignal.getUserId() + "/on_purchase", jsonBody, responseHandler);
            if (OneSignal.getEmailId() != null) {
                OneSignalRestClient.post("players/" + OneSignal.getEmailId() + "/on_purchase", jsonBody, null);
            }
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON for sendPurchases.", t);
        }
    }

    private static boolean openURLFromNotification(Context context, JSONArray dataArray) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName(null)) {
            return false;
        }
        int jsonArraySize = dataArray.length();
        boolean urlOpened = false;
        for (int i = 0; i < jsonArraySize; ++i) {
            try {
                JSONObject customJSON;
                JSONObject data = dataArray.getJSONObject(i);
                if (!data.has("custom") || !(customJSON = new JSONObject(data.optString("custom"))).has("u")) continue;
                String url = customJSON.optString("u", null);
                if (!url.contains("://")) {
                    url = "http://" + url;
                }
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url.trim()));
                intent.addFlags(0x58080000);
                context.startActivity(intent);
                urlOpened = true;
                continue;
            }
            catch (Throwable t) {
                OneSignal.Log(LOG_LEVEL.ERROR, "Error parsing JSON item " + i + "/" + jsonArraySize + " for launching a web URL.", t);
            }
        }
        return urlOpened;
    }

    private static void runNotificationOpenedCallback(JSONArray dataArray, boolean shown, boolean fromAlert) {
        if (mInitBuilder == null || OneSignal.mInitBuilder.mNotificationOpenedHandler == null) {
            unprocessedOpenedNotifis.add(dataArray);
            return;
        }
        OneSignal.fireNotificationOpenedHandler(OneSignal.generateOsNotificationOpenResult(dataArray, shown, fromAlert));
    }

    @NonNull
    private static OSNotificationOpenResult generateOsNotificationOpenResult(JSONArray dataArray, boolean shown, boolean fromAlert) {
        int jsonArraySize = dataArray.length();
        boolean firstMessage = true;
        OSNotificationOpenResult openResult = new OSNotificationOpenResult();
        OSNotification notification = new OSNotification();
        notification.isAppInFocus = OneSignal.isAppActive();
        notification.shown = shown;
        notification.androidNotificationId = dataArray.optJSONObject(0).optInt("notificationId");
        String actionSelected = null;
        for (int i = 0; i < jsonArraySize; ++i) {
            try {
                JSONObject data = dataArray.getJSONObject(i);
                notification.payload = NotificationBundleProcessor.OSNotificationPayloadFrom(data);
                if (actionSelected == null && data.has("actionSelected")) {
                    actionSelected = data.optString("actionSelected", null);
                }
                if (firstMessage) {
                    firstMessage = false;
                    continue;
                }
                if (notification.groupedNotifications == null) {
                    notification.groupedNotifications = new ArrayList<OSNotificationPayload>();
                }
                notification.groupedNotifications.add(notification.payload);
                continue;
            }
            catch (Throwable t) {
                OneSignal.Log(LOG_LEVEL.ERROR, "Error parsing JSON item " + i + "/" + jsonArraySize + " for callback.", t);
            }
        }
        openResult.notification = notification;
        openResult.action = new OSNotificationAction();
        openResult.action.actionID = actionSelected;
        openResult.action.type = actionSelected != null ? OSNotificationAction.ActionType.ActionTaken : OSNotificationAction.ActionType.Opened;
        openResult.notification.displayType = fromAlert ? OSNotification.DisplayType.InAppAlert : OSNotification.DisplayType.Notification;
        return openResult;
    }

    private static void fireNotificationOpenedHandler(final OSNotificationOpenResult openedResult) {
        OSUtils.runOnMainUIThread(new Runnable(){

            @Override
            public void run() {
                OneSignal.mInitBuilder.mNotificationOpenedHandler.notificationOpened(openedResult);
            }
        });
    }

    static void handleNotificationReceived(JSONArray data, boolean displayed, boolean fromAlert) {
        OSNotificationOpenResult openResult = OneSignal.generateOsNotificationOpenResult(data, displayed, fromAlert);
        if (trackFirebaseAnalytics != null && OneSignal.getFirebaseAnalyticsEnabled(appContext)) {
            trackFirebaseAnalytics.trackReceivedEvent(openResult);
        }
        if (mInitBuilder == null || OneSignal.mInitBuilder.mNotificationReceivedHandler == null) {
            return;
        }
        OneSignal.mInitBuilder.mNotificationReceivedHandler.notificationReceived(openResult.notification);
    }

    public static void handleNotificationOpen(Context inContext, JSONArray data, boolean fromAlert) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName(null)) {
            return;
        }
        OneSignal.notificationOpenedRESTCall(inContext, data);
        if (trackFirebaseAnalytics != null && OneSignal.getFirebaseAnalyticsEnabled(appContext)) {
            trackFirebaseAnalytics.trackOpenedEvent(OneSignal.generateOsNotificationOpenResult(data, true, fromAlert));
        }
        boolean urlOpened = false;
        boolean defaultOpenActionDisabled = "DISABLE".equals(OSUtils.getManifestMeta(inContext, "com.onesignal.NotificationOpened.DEFAULT"));
        if (!defaultOpenActionDisabled) {
            urlOpened = OneSignal.openURLFromNotification(inContext, data);
        }
        OneSignal.runNotificationOpenedCallback(data, true, fromAlert);
        if (!(fromAlert || urlOpened || defaultOpenActionDisabled)) {
            OneSignal.fireIntentFromNotificationOpen(inContext);
        }
    }

    private static void fireIntentFromNotificationOpen(Context inContext) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName(null)) {
            return;
        }
        Intent launchIntent = inContext.getPackageManager().getLaunchIntentForPackage(inContext.getPackageName());
        if (launchIntent != null) {
            launchIntent.setFlags(0x10020000);
            inContext.startActivity(launchIntent);
        }
    }

    private static void notificationOpenedRESTCall(Context inContext, JSONArray dataArray) {
        for (int i = 0; i < dataArray.length(); ++i) {
            try {
                JSONObject data = dataArray.getJSONObject(i);
                JSONObject customJson = new JSONObject(data.optString("custom", null));
                String notificationId = customJson.optString("i", null);
                if (postedOpenedNotifIds.contains(notificationId)) continue;
                postedOpenedNotifIds.add(notificationId);
                JSONObject jsonBody = new JSONObject();
                jsonBody.put("app_id", (Object)OneSignal.getSavedAppId(inContext));
                jsonBody.put("player_id", (Object)OneSignal.getSavedUserId(inContext));
                jsonBody.put("opened", true);
                OneSignalRestClient.put("notifications/" + notificationId, jsonBody, new OneSignalRestClient.ResponseHandler(){

                    @Override
                    void onFailure(int statusCode, String response, Throwable throwable) {
                        OneSignal.logHttpError("sending Notification Opened Failed", statusCode, throwable, response);
                    }
                });
                continue;
            }
            catch (Throwable t) {
                OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON to send notification opened.", t);
            }
        }
    }

    private static void SaveAppId(String appId) {
        if (appContext == null) {
            return;
        }
        OneSignalPrefs.saveString(OneSignalPrefs.PREFS_ONESIGNAL, "GT_APP_ID", appId);
    }

    static String getSavedAppId() {
        return OneSignal.getSavedAppId(appContext);
    }

    private static String getSavedAppId(Context inContext) {
        if (inContext == null) {
            return "";
        }
        return OneSignalPrefs.getString(OneSignalPrefs.PREFS_ONESIGNAL, "GT_APP_ID", null);
    }

    static boolean getSavedUserConsentStatus() {
        return OneSignal.getSavedUserConsentStatus(appContext);
    }

    private static boolean getSavedUserConsentStatus(Context inContext) {
        if (inContext == null) {
            return false;
        }
        return OneSignalPrefs.getBool(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_USER_PROVIDED_CONSENT", false);
    }

    static void saveUserConsentStatus(boolean consent) {
        if (appContext == null) {
            return;
        }
        OneSignalPrefs.saveBool(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_USER_PROVIDED_CONSENT", consent);
    }

    private static String getSavedUserId(Context inContext) {
        if (inContext == null) {
            return "";
        }
        return OneSignalPrefs.getString(OneSignalPrefs.PREFS_ONESIGNAL, "GT_PLAYER_ID", null);
    }

    static String getUserId() {
        if (userId == null && appContext != null) {
            userId = OneSignalPrefs.getString(OneSignalPrefs.PREFS_ONESIGNAL, "GT_PLAYER_ID", null);
        }
        return userId;
    }

    static void saveUserId(String id2) {
        userId = id2;
        if (appContext == null) {
            return;
        }
        OneSignalPrefs.saveString(OneSignalPrefs.PREFS_ONESIGNAL, "GT_PLAYER_ID", userId);
    }

    static String getEmailId() {
        if ("".equals(emailId)) {
            return null;
        }
        if (emailId == null && appContext != null) {
            emailId = OneSignalPrefs.getString(OneSignalPrefs.PREFS_ONESIGNAL, "OS_EMAIL_ID", null);
        }
        return emailId;
    }

    static void saveEmailId(String id2) {
        emailId = id2;
        if (appContext == null) {
            return;
        }
        OneSignalPrefs.saveString(OneSignalPrefs.PREFS_ONESIGNAL, "OS_EMAIL_ID", "".equals(emailId) ? null : emailId);
    }

    static boolean getFilterOtherGCMReceivers(Context context) {
        return OneSignalPrefs.getBool(OneSignalPrefs.PREFS_ONESIGNAL, "OS_FILTER_OTHER_GCM_RECEIVERS", false);
    }

    static void saveFilterOtherGCMReceivers(boolean set) {
        if (appContext == null) {
            return;
        }
        OneSignalPrefs.saveBool(OneSignalPrefs.PREFS_ONESIGNAL, "OS_FILTER_OTHER_GCM_RECEIVERS", set);
    }

    static void updateUserIdDependents(String userId) {
        OneSignal.saveUserId(userId);
        OneSignal.fireIdsAvailableCallback();
        OneSignal.internalFireGetTagsCallback(pendingGetTagsHandler);
        OneSignal.getCurrentSubscriptionState(appContext).setUserId(userId);
        if (iapUpdateJob != null) {
            OneSignal.sendPurchases(OneSignal.iapUpdateJob.toReport, OneSignal.iapUpdateJob.newAsExisting, OneSignal.iapUpdateJob.restResponseHandler);
            iapUpdateJob = null;
        }
        OneSignalStateSynchronizer.refreshEmailState();
        OneSignalChromeTab.setup(appContext, appId, userId, AdvertisingIdProviderGPS.getLastValue());
    }

    static void updateEmailIdDependents(String emailId) {
        OneSignal.saveEmailId(emailId);
        OneSignal.getCurrentEmailSubscriptionState(appContext).setEmailUserId(emailId);
        try {
            JSONObject updateJson = new JSONObject().put("parent_player_id", (Object)emailId);
            OneSignalStateSynchronizer.updatePushState(updateJson);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    static boolean getFirebaseAnalyticsEnabled(Context context) {
        return OneSignalPrefs.getBool(OneSignalPrefs.PREFS_ONESIGNAL, "GT_FIREBASE_TRACKING_ENABLED", false);
    }

    public static void enableVibrate(boolean enable) {
        if (appContext == null) {
            return;
        }
        OneSignalPrefs.saveBool(OneSignalPrefs.PREFS_ONESIGNAL, "GT_VIBRATE_ENABLED", enable);
    }

    static boolean getVibrate(Context context) {
        return OneSignalPrefs.getBool(OneSignalPrefs.PREFS_ONESIGNAL, "GT_VIBRATE_ENABLED", true);
    }

    public static void enableSound(boolean enable) {
        if (appContext == null) {
            return;
        }
        OneSignalPrefs.saveBool(OneSignalPrefs.PREFS_ONESIGNAL, "GT_SOUND_ENABLED", enable);
    }

    static boolean getSoundEnabled(Context context) {
        return OneSignalPrefs.getBool(OneSignalPrefs.PREFS_ONESIGNAL, "GT_SOUND_ENABLED", true);
    }

    static void setLastSessionTime(long time) {
        OneSignalPrefs.saveLong(OneSignalPrefs.PREFS_ONESIGNAL, "OS_LAST_SESSION_TIME", time);
    }

    private static long getLastSessionTime(Context context) {
        return OneSignalPrefs.getLong(OneSignalPrefs.PREFS_ONESIGNAL, "OS_LAST_SESSION_TIME", -31000L);
    }

    public static void setInFocusDisplaying(OSInFocusDisplayOption displayOption) {
        OneSignal.getCurrentOrNewInitBuilder().mDisplayOptionCarryOver = true;
        OneSignal.getCurrentOrNewInitBuilder().mDisplayOption = displayOption;
    }

    public static void setInFocusDisplaying(int displayOption) {
        OneSignal.setInFocusDisplaying(OneSignal.getInFocusDisplaying(displayOption));
    }

    public static OSInFocusDisplayOption currentInFocusDisplayOption() {
        return OneSignal.getCurrentOrNewInitBuilder().mDisplayOption;
    }

    private static OSInFocusDisplayOption getInFocusDisplaying(int displayOption) {
        switch (displayOption) {
            case 0: {
                return OSInFocusDisplayOption.None;
            }
            case 1: {
                return OSInFocusDisplayOption.InAppAlert;
            }
            case 2: {
                return OSInFocusDisplayOption.Notification;
            }
        }
        if (displayOption < 0) {
            return OSInFocusDisplayOption.None;
        }
        return OSInFocusDisplayOption.Notification;
    }

    static boolean getNotificationsWhenActiveEnabled() {
        if (mInitBuilder == null) {
            return true;
        }
        return OneSignal.mInitBuilder.mDisplayOption == OSInFocusDisplayOption.Notification;
    }

    static boolean getInAppAlertNotificationEnabled() {
        if (mInitBuilder == null) {
            return false;
        }
        return OneSignal.mInitBuilder.mDisplayOption == OSInFocusDisplayOption.InAppAlert;
    }

    public static void setSubscription(final boolean enable) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("setSubscription()")) {
            return;
        }
        Runnable runSetSubscription = new Runnable(){

            @Override
            public void run() {
                OneSignal.getCurrentSubscriptionState(appContext).setUserSubscriptionSetting(enable);
                OneSignalStateSynchronizer.setSubscription(enable);
            }
        };
        if (appContext == null || OneSignal.shouldRunTaskThroughQueue()) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Moving subscription action to a waiting task queue.");
            OneSignal.addTaskToQueue(new PendingTaskRunnable(runSetSubscription));
            return;
        }
        runSetSubscription.run();
    }

    public static void setLocationShared(boolean enable) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("setLocationShared()")) {
            return;
        }
        shareLocation = enable;
        if (!enable) {
            OneSignalStateSynchronizer.clearLocation();
        }
        OneSignal.Log(LOG_LEVEL.DEBUG, "shareLocation:" + shareLocation);
    }

    public static void promptLocation() {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("promptLocation()")) {
            return;
        }
        Runnable runPromptLocation = new Runnable(){

            @Override
            public void run() {
                LocationGMS.LocationHandler locationHandler = new LocationGMS.LocationHandler(){

                    @Override
                    public LocationGMS.CALLBACK_TYPE getType() {
                        return LocationGMS.CALLBACK_TYPE.PROMPT_LOCATION;
                    }

                    @Override
                    public void complete(LocationGMS.LocationPoint point) {
                        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("promptLocation()")) {
                            return;
                        }
                        if (point != null) {
                            OneSignalStateSynchronizer.updateLocation(point);
                        }
                    }
                };
                LocationGMS.getLocation(appContext, true, locationHandler);
                promptedLocation = true;
            }
        };
        if (appContext == null || OneSignal.shouldRunTaskThroughQueue()) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not prompt for location at this time - moving this operation to awaiting queue.");
            OneSignal.addTaskToQueue(new PendingTaskRunnable(runPromptLocation));
            return;
        }
        runPromptLocation.run();
    }

    public static void clearOneSignalNotifications() {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("clearOneSignalNotifications()")) {
            return;
        }
        Runnable runClearOneSignalNotifications = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                NotificationManager notificationManager = (NotificationManager)appContext.getSystemService("notification");
                OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(appContext);
                try (Cursor cursor = null;){
                    SQLiteDatabase readableDb = dbHelper.getReadableDbWithRetries();
                    String[] retColumn = new String[]{"android_notification_id"};
                    cursor = readableDb.query("notification", retColumn, "dismissed = 0 AND opened = 0", null, null, null, null);
                    if (cursor.moveToFirst()) {
                        do {
                            int existingId = cursor.getInt(cursor.getColumnIndex("android_notification_id"));
                            notificationManager.cancel(existingId);
                        } while (cursor.moveToNext());
                    }
                    SQLiteDatabase writableDb = null;
                    try {
                        writableDb = dbHelper.getWritableDbWithRetries();
                        writableDb.beginTransaction();
                        String whereStr = "opened = 0";
                        ContentValues values = new ContentValues();
                        values.put("dismissed", Integer.valueOf(1));
                        writableDb.update("notification", values, whereStr, null);
                        writableDb.setTransactionSuccessful();
                    }
                    catch (Throwable t) {
                        OneSignal.Log(LOG_LEVEL.ERROR, "Error marking all notifications as dismissed! ", t);
                    }
                    finally {
                        if (writableDb != null) {
                            try {
                                writableDb.endTransaction();
                            }
                            catch (Throwable t) {
                                OneSignal.Log(LOG_LEVEL.ERROR, "Error closing transaction! ", t);
                            }
                        }
                    }
                    BadgeCountUpdater.updateCount(0, appContext);
                }
            }
        };
        if (appContext == null || OneSignal.shouldRunTaskThroughQueue()) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not clear notifications at this time - moving this operation toa waiting task queue.");
            OneSignal.addTaskToQueue(new PendingTaskRunnable(runClearOneSignalNotifications));
            return;
        }
        runClearOneSignalNotifications.run();
    }

    public static void cancelNotification(final int id2) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("cancelNotification()")) {
            return;
        }
        Runnable runCancelNotification = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(appContext);
                SQLiteDatabase writableDb = null;
                try {
                    writableDb = dbHelper.getWritableDbWithRetries();
                    writableDb.beginTransaction();
                    String whereStr = "android_notification_id = " + id2 + " AND " + "opened" + " = 0 AND " + "dismissed" + " = 0";
                    ContentValues values = new ContentValues();
                    values.put("dismissed", Integer.valueOf(1));
                    int records = writableDb.update("notification", values, whereStr, null);
                    if (records > 0) {
                        NotificationSummaryManager.updatePossibleDependentSummaryOnDismiss(appContext, writableDb, id2);
                    }
                    BadgeCountUpdater.update(writableDb, appContext);
                    writableDb.setTransactionSuccessful();
                }
                catch (Throwable t) {
                    OneSignal.Log(LOG_LEVEL.ERROR, "Error marking a notification id " + id2 + " as dismissed! ", t);
                }
                finally {
                    if (writableDb != null) {
                        try {
                            writableDb.endTransaction();
                        }
                        catch (Throwable t) {
                            OneSignal.Log(LOG_LEVEL.ERROR, "Error closing transaction! ", t);
                        }
                    }
                }
            }
        };
        if (appContext == null || OneSignal.shouldRunTaskThroughQueue()) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not clear notification id: " + id2 + " at this time - movingthis operation to a waiting task queue. The notification will still be canceledfrom NotificationManager at this time.");
            taskQueueWaitingForInit.add(runCancelNotification);
            return;
        }
        runCancelNotification.run();
        NotificationManager notificationManager = (NotificationManager)appContext.getSystemService("notification");
        notificationManager.cancel(id2);
    }

    public static void cancelGroupedNotifications(final String group) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("cancelGroupedNotifications()")) {
            return;
        }
        Runnable runCancelGroupedNotifications = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                NotificationManager notificationManager = (NotificationManager)appContext.getSystemService("notification");
                OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(appContext);
                Cursor cursor = null;
                try {
                    SQLiteDatabase readableDb = dbHelper.getReadableDbWithRetries();
                    String[] retColumn = new String[]{"android_notification_id"};
                    String whereStr = "group_id = ? AND dismissed = 0 AND opened = 0";
                    String[] whereArgs = new String[]{group};
                    cursor = readableDb.query("notification", retColumn, whereStr, whereArgs, null, null, null);
                    while (cursor.moveToNext()) {
                        int notifId = cursor.getInt(cursor.getColumnIndex("android_notification_id"));
                        if (notifId == -1) continue;
                        notificationManager.cancel(notifId);
                    }
                }
                catch (Throwable t) {
                    OneSignal.Log(LOG_LEVEL.ERROR, "Error getting android notifications part of group: " + group, t);
                }
                finally {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                SQLiteDatabase writableDb = null;
                try {
                    writableDb = dbHelper.getWritableDbWithRetries();
                    writableDb.beginTransaction();
                    String whereStr = "group_id = ? AND opened = 0 AND dismissed = 0";
                    String[] whereArgs = new String[]{group};
                    ContentValues values = new ContentValues();
                    values.put("dismissed", Integer.valueOf(1));
                    writableDb.update("notification", values, whereStr, whereArgs);
                    BadgeCountUpdater.update(writableDb, appContext);
                    writableDb.setTransactionSuccessful();
                }
                catch (Throwable t) {
                    OneSignal.Log(LOG_LEVEL.ERROR, "Error marking a notifications with group " + group + " as dismissed! ", t);
                }
                finally {
                    if (writableDb != null) {
                        try {
                            writableDb.endTransaction();
                        }
                        catch (Throwable t) {
                            OneSignal.Log(LOG_LEVEL.ERROR, "Error closing transaction! ", t);
                        }
                    }
                }
            }
        };
        if (appContext == null || OneSignal.shouldRunTaskThroughQueue()) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not clear notifications part of group " + group + " - movingthis operation to a waiting task queue.");
            OneSignal.addTaskToQueue(new PendingTaskRunnable(runCancelGroupedNotifications));
            return;
        }
        runCancelGroupedNotifications.run();
    }

    public static void removeNotificationOpenedHandler() {
        OneSignal.getCurrentOrNewInitBuilder().mNotificationOpenedHandler = null;
    }

    public static void removeNotificationReceivedHandler() {
        OneSignal.getCurrentOrNewInitBuilder().mNotificationReceivedHandler = null;
    }

    public static void addPermissionObserver(OSPermissionObserver observer) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("addPermissionObserver()")) {
            return;
        }
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not add permission observer");
            return;
        }
        OneSignal.getPermissionStateChangesObserver().addObserver(observer);
        if (OneSignal.getCurrentPermissionState(appContext).compare(OneSignal.getLastPermissionState(appContext))) {
            OSPermissionChangedInternalObserver.fireChangesToPublicObserver(OneSignal.getCurrentPermissionState(appContext));
        }
    }

    public static void removePermissionObserver(OSPermissionObserver observer) {
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not modify permission observer");
            return;
        }
        OneSignal.getPermissionStateChangesObserver().removeObserver(observer);
    }

    public static void addSubscriptionObserver(OSSubscriptionObserver observer) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("addSubscriptionObserver()")) {
            return;
        }
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not add subscription observer");
            return;
        }
        OneSignal.getSubscriptionStateChangesObserver().addObserver(observer);
        if (OneSignal.getCurrentSubscriptionState(appContext).compare(OneSignal.getLastSubscriptionState(appContext))) {
            OSSubscriptionChangedInternalObserver.fireChangesToPublicObserver(OneSignal.getCurrentSubscriptionState(appContext));
        }
    }

    public static void removeSubscriptionObserver(OSSubscriptionObserver observer) {
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not modify subscription observer");
            return;
        }
        OneSignal.getSubscriptionStateChangesObserver().removeObserver(observer);
    }

    public static void addEmailSubscriptionObserver(@NonNull OSEmailSubscriptionObserver observer) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("addEmailSubscriptionObserver()")) {
            return;
        }
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not add email subscription observer");
            return;
        }
        OneSignal.getEmailSubscriptionStateChangesObserver().addObserver(observer);
        if (OneSignal.getCurrentEmailSubscriptionState(appContext).compare(OneSignal.getLastEmailSubscriptionState(appContext))) {
            OSEmailSubscriptionChangedInternalObserver.fireChangesToPublicObserver(OneSignal.getCurrentEmailSubscriptionState(appContext));
        }
    }

    public static void removeEmailSubscriptionObserver(@NonNull OSEmailSubscriptionObserver observer) {
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not modify email subscription observer");
            return;
        }
        OneSignal.getEmailSubscriptionStateChangesObserver().removeObserver(observer);
    }

    public static OSPermissionSubscriptionState getPermissionSubscriptionState() {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("getPermissionSubscriptionState()")) {
            return null;
        }
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not get OSPermissionSubscriptionState");
            return null;
        }
        OSPermissionSubscriptionState status = new OSPermissionSubscriptionState();
        status.subscriptionStatus = OneSignal.getCurrentSubscriptionState(appContext);
        status.permissionStatus = OneSignal.getCurrentPermissionState(appContext);
        status.emailSubscriptionStatus = OneSignal.getCurrentEmailSubscriptionState(appContext);
        return status;
    }

    static long GetUnsentActiveTime() {
        if (unSentActiveTime == -1L && appContext != null) {
            unSentActiveTime = OneSignalPrefs.getLong(OneSignalPrefs.PREFS_ONESIGNAL, "GT_UNSENT_ACTIVE_TIME", 0L);
        }
        OneSignal.Log(LOG_LEVEL.INFO, "GetUnsentActiveTime: " + unSentActiveTime);
        return unSentActiveTime;
    }

    private static void SaveUnsentActiveTime(long time) {
        unSentActiveTime = time;
        if (appContext == null) {
            return;
        }
        OneSignal.Log(LOG_LEVEL.INFO, "SaveUnsentActiveTime: " + unSentActiveTime);
        OneSignalPrefs.saveLong(OneSignalPrefs.PREFS_ONESIGNAL, "GT_UNSENT_ACTIVE_TIME", time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isDuplicateNotification(String id2, Context context) {
        if (id2 == null || "".equals(id2)) {
            return false;
        }
        boolean exists = false;
        OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(context);
        try (Cursor cursor = null;){
            SQLiteDatabase readableDb = dbHelper.getReadableDbWithRetries();
            String[] retColumn = new String[]{"notification_id"};
            String[] whereArgs = new String[]{id2};
            cursor = readableDb.query("notification", retColumn, "notification_id = ?", whereArgs, null, null, null);
            exists = cursor.moveToFirst();
        }
        if (exists) {
            OneSignal.Log(LOG_LEVEL.DEBUG, "Duplicate GCM message received, skip processing of " + id2);
            return true;
        }
        return false;
    }

    static boolean notValidOrDuplicated(Context context, JSONObject jsonPayload) {
        String id2 = OneSignal.getNotificationIdFromGCMJsonPayload(jsonPayload);
        return id2 == null || OneSignal.isDuplicateNotification(id2, context);
    }

    static String getNotificationIdFromGCMBundle(Bundle bundle) {
        if (bundle.isEmpty()) {
            return null;
        }
        try {
            if (bundle.containsKey("custom")) {
                JSONObject customJSON = new JSONObject(bundle.getString("custom"));
                if (customJSON.has("i")) {
                    return customJSON.optString("i", null);
                }
                OneSignal.Log(LOG_LEVEL.DEBUG, "Not a OneSignal formatted GCM message. No 'i' field in custom.");
            } else {
                OneSignal.Log(LOG_LEVEL.DEBUG, "Not a OneSignal formatted GCM message. No 'custom' field in the bundle.");
            }
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.DEBUG, "Could not parse bundle, probably not a OneSignal notification.", t);
        }
        return null;
    }

    private static String getNotificationIdFromGCMJsonPayload(JSONObject jsonPayload) {
        try {
            JSONObject customJSON = new JSONObject(jsonPayload.optString("custom"));
            return customJSON.optString("i", null);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static boolean isAppActive() {
        return initDone && OneSignal.isForeground();
    }

    static void updateOnSessionDependents() {
        sendAsSession = false;
        OneSignal.setLastSessionTime(System.currentTimeMillis());
    }

    private static boolean isPastOnSessionTime() {
        if (sendAsSession) {
            return true;
        }
        return (System.currentTimeMillis() - OneSignal.getLastSessionTime(appContext)) / 1000L >= 30L;
    }

    static boolean areNotificationsEnabledForSubscribedState() {
        if (OneSignal.mInitBuilder.mUnsubscribeWhenNotificationsAreDisabled) {
            return OSUtils.areNotificationsEnabled(appContext);
        }
        return true;
    }

    static void handleSuccessfulEmailLogout() {
        if (emailLogoutHandler != null) {
            emailLogoutHandler.onSuccess();
            emailLogoutHandler = null;
        }
    }

    static void handleFailedEmailLogout() {
        if (emailLogoutHandler != null) {
            emailLogoutHandler.onFailure(new EmailUpdateError(EmailErrorType.NETWORK, "Failed due to network failure. Will retry on next sync."));
            emailLogoutHandler = null;
        }
    }

    static void fireEmailUpdateSuccess() {
        if (emailUpdateHandler != null) {
            emailUpdateHandler.onSuccess();
            emailUpdateHandler = null;
        }
    }

    static void fireEmailUpdateFailure() {
        if (emailUpdateHandler != null) {
            emailUpdateHandler.onFailure(new EmailUpdateError(EmailErrorType.NETWORK, "Failed due to network failure. Will retry on next sync."));
            emailUpdateHandler = null;
        }
    }

    static {
        visualLogLevel = LOG_LEVEL.NONE;
        logCatLevel = LOG_LEVEL.WARN;
        userId = null;
        emailId = null;
        taskQueueWaitingForInit = new ConcurrentLinkedQueue();
        lastTaskId = new AtomicLong();
        lastTrackedFocusTime = 1L;
        unSentActiveTime = -1L;
        mainAdIdProvider = new AdvertisingIdProviderGPS();
        sdkType = "native";
        shareLocation = true;
        unprocessedOpenedNotifis = new ArrayList<JSONArray>();
        postedOpenedNotifIds = new HashSet();
        requiresUserPrivacyConsent = false;
        androidParamsReties = 0;
    }

    private static class PendingTaskRunnable
    implements Runnable {
        private Runnable innerTask;
        private long taskId;

        PendingTaskRunnable(Runnable innerTask) {
            this.innerTask = innerTask;
        }

        @Override
        public void run() {
            this.innerTask.run();
            OneSignal.onTaskRan(this.taskId);
        }
    }

    private static class IAPUpdateJob {
        JSONArray toReport;
        boolean newAsExisting;
        OneSignalRestClient.ResponseHandler restResponseHandler;

        IAPUpdateJob(JSONArray toReport) {
            this.toReport = toReport;
        }
    }

    public static class Builder {
        Context mContext;
        NotificationOpenedHandler mNotificationOpenedHandler;
        NotificationReceivedHandler mNotificationReceivedHandler;
        boolean mPromptLocation;
        boolean mDisableGmsMissingPrompt;
        boolean mUnsubscribeWhenNotificationsAreDisabled;
        boolean mFilterOtherGCMReceivers;
        boolean mDisplayOptionCarryOver;
        OSInFocusDisplayOption mDisplayOption = OSInFocusDisplayOption.InAppAlert;

        private Builder() {
        }

        private Builder(Context context) {
            this.mContext = context;
        }

        private void setDisplayOptionCarryOver(boolean carryOver) {
            this.mDisplayOptionCarryOver = carryOver;
        }

        public Builder setNotificationOpenedHandler(NotificationOpenedHandler handler) {
            this.mNotificationOpenedHandler = handler;
            return this;
        }

        public Builder setNotificationReceivedHandler(NotificationReceivedHandler handler) {
            this.mNotificationReceivedHandler = handler;
            return this;
        }

        public Builder autoPromptLocation(boolean enable) {
            this.mPromptLocation = enable;
            return this;
        }

        public Builder disableGmsMissingPrompt(boolean disable) {
            this.mDisableGmsMissingPrompt = disable;
            return this;
        }

        public Builder inFocusDisplaying(OSInFocusDisplayOption displayOption) {
            OneSignal.getCurrentOrNewInitBuilder().mDisplayOptionCarryOver = false;
            this.mDisplayOption = displayOption;
            return this;
        }

        public Builder unsubscribeWhenNotificationsAreDisabled(boolean set) {
            this.mUnsubscribeWhenNotificationsAreDisabled = set;
            return this;
        }

        public Builder filterOtherGCMReceivers(boolean set) {
            this.mFilterOtherGCMReceivers = set;
            return this;
        }

        public void init() {
            OneSignal.init(this);
        }
    }

    public static interface PostNotificationResponseHandler {
        public void onSuccess(JSONObject var1);

        public void onFailure(JSONObject var1);
    }

    public static interface EmailUpdateHandler {
        public void onSuccess();

        public void onFailure(EmailUpdateError var1);
    }

    public static class EmailUpdateError {
        private EmailErrorType type;
        private String message;

        EmailUpdateError(EmailErrorType type, String message) {
            this.type = type;
            this.message = message;
        }

        public EmailErrorType getType() {
            return this.type;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static enum EmailErrorType {
        VALIDATION,
        REQUIRES_EMAIL_AUTH,
        INVALID_OPERATION,
        NETWORK;

    }

    public static class SendTagsError {
        private String message;
        private int code;

        SendTagsError(int errorCode, String errorMessage) {
            this.message = errorMessage;
            this.code = errorCode;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static interface ChangeTagsUpdateHandler {
        public void onSuccess(JSONObject var1);

        public void onFailure(SendTagsError var1);
    }

    public static interface GetTagsHandler {
        public void tagsAvailable(JSONObject var1);
    }

    public static interface IdsAvailableHandler {
        public void idsAvailable(String var1, String var2);
    }

    public static interface NotificationReceivedHandler {
        public void notificationReceived(OSNotification var1);
    }

    public static interface NotificationOpenedHandler {
        public void notificationOpened(OSNotificationOpenResult var1);
    }

    public static enum OSInFocusDisplayOption {
        None,
        InAppAlert,
        Notification;

    }

    public static enum LOG_LEVEL {
        NONE,
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        VERBOSE;

    }
}

