/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.R;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.text.SpannableString;
import android.text.style.StyleSpan;
import android.widget.RemoteViews;
import com.onesignal.ActivityLifecycleHandler;
import com.onesignal.AndroidSupportV4Compat;
import com.onesignal.NotificationExtenderService;
import com.onesignal.NotificationOpenedActivity;
import com.onesignal.NotificationOpenedProcessor;
import com.onesignal.NotificationOpenedReceiver;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.R;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class GenerateNotification {
    private static Context currentContext = null;
    private static String packageName = null;
    private static Resources contextResources = null;
    private static Class<?> notificationOpenedClass;
    private static boolean openerIsBroadcast;

    GenerateNotification() {
    }

    static void setStatics(Context inContext) {
        currentContext = inContext;
        packageName = currentContext.getPackageName();
        contextResources = currentContext.getResources();
        PackageManager packageManager = currentContext.getPackageManager();
        Intent intent = new Intent(currentContext, NotificationOpenedReceiver.class);
        intent.setPackage(currentContext.getPackageName());
        if (packageManager.queryBroadcastReceivers(intent, 0).size() > 0) {
            openerIsBroadcast = true;
            notificationOpenedClass = NotificationOpenedReceiver.class;
        } else {
            notificationOpenedClass = NotificationOpenedActivity.class;
        }
    }

    static void fromJsonPayload(Context inContext, boolean restoring, int notificationId, JSONObject jsonPayload, boolean showAsAlert, NotificationExtenderService.OverrideSettings overrideSettings) {
        GenerateNotification.setStatics(inContext);
        if (!restoring && showAsAlert && ActivityLifecycleHandler.curActivity != null) {
            GenerateNotification.showNotificationAsAlert(jsonPayload, ActivityLifecycleHandler.curActivity, notificationId);
            return;
        }
        GenerateNotification.showNotification(notificationId, restoring, jsonPayload, overrideSettings);
    }

    private static void showNotificationAsAlert(final JSONObject gcmJson, final Activity activity, final int notificationId) {
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
                builder.setTitle(GenerateNotification.getTitle(gcmJson));
                builder.setMessage((CharSequence)gcmJson.optString("alert"));
                ArrayList buttonsLabels = new ArrayList();
                ArrayList buttonIds = new ArrayList();
                GenerateNotification.addAlertButtons((Context)activity, gcmJson, buttonsLabels, buttonIds);
                final ArrayList finalButtonIds = buttonIds;
                Intent buttonIntent = GenerateNotification.getNewBaseIntent(notificationId);
                buttonIntent.putExtra("action_button", true);
                buttonIntent.putExtra("from_alert", true);
                buttonIntent.putExtra("onesignal_data", gcmJson.toString());
                if (gcmJson.has("grp")) {
                    buttonIntent.putExtra("grp", gcmJson.optString("grp"));
                }
                final Intent finalButtonIntent = buttonIntent;
                DialogInterface.OnClickListener buttonListener = new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        int index = which + 3;
                        if (finalButtonIds.size() > 1) {
                            try {
                                JSONObject newJsonData = new JSONObject(gcmJson.toString());
                                newJsonData.put("actionSelected", finalButtonIds.get(index));
                                finalButtonIntent.putExtra("onesignal_data", newJsonData.toString());
                                NotificationOpenedProcessor.processIntent((Context)activity, finalButtonIntent);
                            }
                            catch (Throwable t) {}
                        } else {
                            NotificationOpenedProcessor.processIntent((Context)activity, finalButtonIntent);
                        }
                    }
                };
                builder.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialogInterface) {
                        NotificationOpenedProcessor.processIntent((Context)activity, finalButtonIntent);
                    }
                });
                for (int i = 0; i < buttonsLabels.size(); ++i) {
                    if (i == 0) {
                        builder.setNeutralButton((CharSequence)buttonsLabels.get(i), buttonListener);
                        continue;
                    }
                    if (i == 1) {
                        builder.setNegativeButton((CharSequence)buttonsLabels.get(i), buttonListener);
                        continue;
                    }
                    if (i != 2) continue;
                    builder.setPositiveButton((CharSequence)buttonsLabels.get(i), buttonListener);
                }
                AlertDialog alertDialog = builder.create();
                alertDialog.setCanceledOnTouchOutside(false);
                alertDialog.show();
            }
        });
    }

    private static CharSequence getTitle(JSONObject gcmBundle) {
        String title = gcmBundle.optString("title", null);
        if (title != null) {
            return title;
        }
        return currentContext.getPackageManager().getApplicationLabel(currentContext.getApplicationInfo());
    }

    private static PendingIntent getNewActionPendingIntent(int requestCode, Intent intent) {
        if (openerIsBroadcast) {
            return PendingIntent.getBroadcast((Context)currentContext, (int)requestCode, (Intent)intent, (int)0x8000000);
        }
        return PendingIntent.getActivity((Context)currentContext, (int)requestCode, (Intent)intent, (int)0x8000000);
    }

    private static Intent getNewBaseIntent(int notificationId) {
        Intent intent = new Intent(currentContext, notificationOpenedClass).putExtra("notificationId", notificationId);
        if (openerIsBroadcast) {
            return intent;
        }
        return intent.addFlags(0x24000000);
    }

    private static Intent getNewBaseDeleteIntent(int notificationId) {
        Intent intent = new Intent(currentContext, notificationOpenedClass).putExtra("notificationId", notificationId).putExtra("dismissed", true);
        if (openerIsBroadcast) {
            return intent;
        }
        return intent.addFlags(0x18010000);
    }

    private static NotificationCompat.Builder getBaseNotificationCompatBuilder(JSONObject gcmBundle) {
        Bitmap bigPictureIcon;
        int notificationIcon = GenerateNotification.getSmallIconId(gcmBundle);
        int notificationDefaults = 0;
        if (OneSignal.getVibrate(currentContext)) {
            notificationDefaults = 2;
        }
        String message = gcmBundle.optString("alert", null);
        NotificationCompat.Builder notifBuilder = new NotificationCompat.Builder(currentContext).setAutoCancel(true).setSmallIcon(notificationIcon).setContentTitle(GenerateNotification.getTitle(gcmBundle)).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)message)).setContentText((CharSequence)message).setTicker((CharSequence)message);
        try {
            BigInteger accentColor = GenerateNotification.getAccentColor(gcmBundle);
            if (accentColor != null) {
                notifBuilder.setColor(accentColor.intValue());
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        BigInteger ledColor = null;
        if (gcmBundle.has("ledc")) {
            try {
                ledColor = new BigInteger(gcmBundle.optString("ledc"), 16);
                notifBuilder.setLights(ledColor.intValue(), 2000, 5000);
            }
            catch (Throwable t) {
                notificationDefaults |= 4;
            }
        } else {
            notificationDefaults |= 4;
        }
        try {
            int visibility = 1;
            if (gcmBundle.has("vis")) {
                visibility = Integer.parseInt(gcmBundle.optString("vis"));
            }
            notifBuilder.setVisibility(visibility);
        }
        catch (Throwable t) {
            // empty catch block
        }
        Bitmap largeIcon = GenerateNotification.getLargeIcon(gcmBundle);
        if (largeIcon != null) {
            notifBuilder.setLargeIcon(largeIcon);
        }
        if ((bigPictureIcon = GenerateNotification.getBitmap(gcmBundle.optString("bicon", null))) != null) {
            notifBuilder.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture(bigPictureIcon).setSummaryText((CharSequence)message));
        }
        if (OneSignal.getSoundEnabled(currentContext)) {
            Uri soundUri = GenerateNotification.getCustomSound(gcmBundle);
            if (soundUri != null) {
                notifBuilder.setSound(soundUri);
            } else {
                notificationDefaults |= 1;
            }
        }
        notifBuilder.setDefaults(notificationDefaults);
        return notifBuilder;
    }

    private static void removeNotifyOptions(NotificationCompat.Builder builder) {
        builder.setDefaults(0).setSound(null).setVibrate(null).setTicker(null);
    }

    static void showNotification(int notificationId, boolean restoring, JSONObject gcmBundle, NotificationExtenderService.OverrideSettings overrideSettings) {
        Random random = new Random();
        String group = gcmBundle.optString("grp", null);
        NotificationCompat.Builder notifBuilder = GenerateNotification.getBaseNotificationCompatBuilder(gcmBundle);
        GenerateNotification.addNotificationActionButtons(gcmBundle, notifBuilder, notificationId, null);
        try {
            GenerateNotification.addBackgroundImage(gcmBundle, notifBuilder);
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Could not set background notification image!", t);
        }
        if (overrideSettings != null && overrideSettings.extender != null) {
            notifBuilder.extend(overrideSettings.extender);
        }
        if (group != null) {
            PendingIntent contentIntent = GenerateNotification.getNewActionPendingIntent(random.nextInt(), GenerateNotification.getNewBaseIntent(notificationId).putExtra("onesignal_data", gcmBundle.toString()).putExtra("grp", group));
            notifBuilder.setContentIntent(contentIntent);
            PendingIntent deleteIntent = GenerateNotification.getNewActionPendingIntent(random.nextInt(), GenerateNotification.getNewBaseDeleteIntent(notificationId).putExtra("grp", group));
            notifBuilder.setDeleteIntent(deleteIntent);
            notifBuilder.setGroup(group);
            GenerateNotification.createSummaryNotification(restoring, gcmBundle);
        } else {
            PendingIntent contentIntent = GenerateNotification.getNewActionPendingIntent(random.nextInt(), GenerateNotification.getNewBaseIntent(notificationId).putExtra("onesignal_data", gcmBundle.toString()));
            notifBuilder.setContentIntent(contentIntent);
            PendingIntent deleteIntent = GenerateNotification.getNewActionPendingIntent(random.nextInt(), GenerateNotification.getNewBaseDeleteIntent(notificationId));
            notifBuilder.setDeleteIntent(deleteIntent);
        }
        if (restoring) {
            GenerateNotification.removeNotifyOptions(notifBuilder);
        }
        if (group == null || Build.VERSION.SDK_INT > 17) {
            NotificationManagerCompat.from((Context)currentContext).notify(notificationId, notifBuilder.build());
        }
    }

    private static void createSummaryNotification(boolean restoring, JSONObject gcmBundle) {
        GenerateNotification.createSummaryNotification(null, restoring, gcmBundle);
    }

    static void createSummaryNotification(Context inContext, boolean updateSummary, JSONObject gcmBundle) {
        Notification summaryNotification;
        if (updateSummary && inContext != null) {
            GenerateNotification.setStatics(inContext);
        }
        String group = gcmBundle.optString("grp", null);
        Random random = new Random();
        PendingIntent summaryDeleteIntent = GenerateNotification.getNewActionPendingIntent(random.nextInt(), GenerateNotification.getNewBaseDeleteIntent(0).putExtra("summary", group));
        OneSignalDbHelper dbHelper = new OneSignalDbHelper(currentContext);
        SQLiteDatabase writableDb = dbHelper.getWritableDatabase();
        String[] retColumn = new String[]{"android_notification_id", "full_data", "is_summary", "title", "message"};
        String[] whereArgs = new String[]{group};
        Cursor cursor = writableDb.query("notification", retColumn, "group_id = ? AND dismissed = 0 AND opened = 0", whereArgs, null, null, "_id DESC");
        int summaryNotificationId = random.nextInt();
        String firstFullData = null;
        ArrayList<SpannableString> summeryList = null;
        if (cursor.moveToFirst()) {
            summeryList = new ArrayList<SpannableString>();
            do {
                if (cursor.getInt(cursor.getColumnIndex("is_summary")) == 1) {
                    summaryNotificationId = cursor.getInt(cursor.getColumnIndex("android_notification_id"));
                    continue;
                }
                String title = cursor.getString(cursor.getColumnIndex("title"));
                title = title == null ? "" : title + " ";
                String msg = cursor.getString(cursor.getColumnIndex("message"));
                SpannableString spannableString = new SpannableString((CharSequence)(title + msg));
                if (title.length() > 0) {
                    spannableString.setSpan((Object)new StyleSpan(1), 0, title.length(), 0);
                }
                summeryList.add(spannableString);
                if (firstFullData != null) continue;
                firstFullData = cursor.getString(cursor.getColumnIndex("full_data"));
            } while (cursor.moveToNext());
            if (updateSummary) {
                try {
                    gcmBundle = new JSONObject(firstFullData);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        if (!(summeryList == null || updateSummary && summeryList.size() <= 1)) {
            int notificationCount = summeryList.size() + (updateSummary ? 0 : 1);
            String summaryMessage = gcmBundle.optString("grp_msg", null);
            summaryMessage = summaryMessage == null ? notificationCount + " new messages" : summaryMessage.replace("$[notif_count]", "" + notificationCount);
            JSONObject summaryDataBundle = new JSONObject();
            try {
                summaryDataBundle.put("alert", (Object)summaryMessage);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            Intent summaryIntent = GenerateNotification.getNewBaseIntent(summaryNotificationId).putExtra("summary", group).putExtra("onesignal_data", summaryDataBundle.toString());
            PendingIntent summaryContentIntent = GenerateNotification.getNewActionPendingIntent(random.nextInt(), summaryIntent);
            NotificationCompat.Builder summeryBuilder = GenerateNotification.getBaseNotificationCompatBuilder(gcmBundle);
            if (updateSummary) {
                GenerateNotification.removeNotifyOptions(summeryBuilder);
            }
            summeryBuilder.setContentIntent(summaryContentIntent).setDeleteIntent(summaryDeleteIntent).setContentTitle(currentContext.getPackageManager().getApplicationLabel(currentContext.getApplicationInfo())).setContentText((CharSequence)summaryMessage).setNumber(notificationCount).setOnlyAlertOnce(updateSummary).setGroup(group).setGroupSummary(true);
            if (!updateSummary) {
                summeryBuilder.setTicker((CharSequence)summaryMessage);
            }
            NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
            if (!updateSummary) {
                String line1Title = gcmBundle.optString("title", null);
                line1Title = line1Title == null ? "" : line1Title + " ";
                String message = gcmBundle.optString("alert");
                SpannableString spannableString = new SpannableString((CharSequence)(line1Title + message));
                if (line1Title.length() > 0) {
                    spannableString.setSpan((Object)new StyleSpan(1), 0, line1Title.length(), 0);
                }
                inboxStyle.addLine((CharSequence)spannableString);
            }
            for (SpannableString line : summeryList) {
                inboxStyle.addLine((CharSequence)line);
            }
            inboxStyle.setBigContentTitle((CharSequence)summaryMessage);
            summeryBuilder.setStyle((NotificationCompat.Style)inboxStyle);
            summaryNotification = summeryBuilder.build();
        } else {
            ContentValues values = new ContentValues();
            values.put("android_notification_id", Integer.valueOf(summaryNotificationId));
            values.put("group_id", group);
            values.put("is_summary", Integer.valueOf(1));
            writableDb.insert("notification", null, values);
            NotificationCompat.Builder notifBuilder = GenerateNotification.getBaseNotificationCompatBuilder(gcmBundle);
            if (updateSummary) {
                GenerateNotification.removeNotifyOptions(notifBuilder);
            }
            PendingIntent summaryContentIntent = GenerateNotification.getNewActionPendingIntent(random.nextInt(), GenerateNotification.getNewBaseIntent(summaryNotificationId).putExtra("onesignal_data", gcmBundle.toString()).putExtra("summary", group));
            GenerateNotification.addNotificationActionButtons(gcmBundle, notifBuilder, summaryNotificationId, group);
            notifBuilder.setContentIntent(summaryContentIntent).setDeleteIntent(summaryDeleteIntent).setOnlyAlertOnce(updateSummary).setGroup(group).setGroupSummary(true);
            summaryNotification = notifBuilder.build();
        }
        NotificationManagerCompat.from((Context)currentContext).notify(summaryNotificationId, summaryNotification);
        cursor.close();
        writableDb.close();
    }

    private static void addBackgroundImage(JSONObject gcmBundle, NotificationCompat.Builder notifBuilder) throws Throwable {
        Bitmap bg_image = null;
        JSONObject jsonBgImage = null;
        String jsonStrBgImage = gcmBundle.optString("bg_img", null);
        if (jsonStrBgImage != null) {
            jsonBgImage = new JSONObject(jsonStrBgImage);
            bg_image = GenerateNotification.getBitmap(jsonBgImage.optString("img", null));
        }
        if (bg_image == null) {
            bg_image = GenerateNotification.getBitmapFromAssetsOrResourceName("onesignal_bgimage_default_image");
        }
        if (bg_image != null) {
            RemoteViews customView = new RemoteViews(currentContext.getPackageName(), R.layout.onesignal_bgimage_notif_layout);
            customView.setTextViewText(R.id.os_bgimage_notif_title, GenerateNotification.getTitle(gcmBundle));
            customView.setTextViewText(R.id.os_bgimage_notif_body, (CharSequence)gcmBundle.optString("alert"));
            GenerateNotification.setTextColor(customView, jsonBgImage, R.id.os_bgimage_notif_title, "tc", "onesignal_bgimage_notif_title_color");
            GenerateNotification.setTextColor(customView, jsonBgImage, R.id.os_bgimage_notif_body, "bc", "onesignal_bgimage_notif_body_color");
            customView.setImageViewBitmap(R.id.os_bgimage_notif_bgimage, bg_image);
            notifBuilder.setContent(customView);
            notifBuilder.setStyle(null);
        }
    }

    private static void setTextColor(RemoteViews customView, JSONObject gcmBundle, int viewId, String colorPayloadKey, String colorDefaultResource) {
        Integer color = GenerateNotification.safeGetColorFromHex(gcmBundle, colorPayloadKey);
        if (color != null) {
            customView.setTextColor(viewId, color.intValue());
        } else {
            int colorId = contextResources.getIdentifier(colorDefaultResource, "color", packageName);
            if (colorId != 0) {
                customView.setTextColor(viewId, AndroidSupportV4Compat.ContextCompat.getColor(currentContext, colorId));
            }
        }
    }

    private static Integer safeGetColorFromHex(JSONObject gcmBundle, String colorKey) {
        try {
            if (gcmBundle != null && gcmBundle.has(colorKey)) {
                return new BigInteger(gcmBundle.optString(colorKey), 16).intValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static boolean isValidResourceName(String name) {
        return name != null && !name.matches("^[0-9]");
    }

    private static Bitmap getLargeIcon(JSONObject gcmBundle) {
        if (Build.VERSION.SDK_INT < 11) {
            return null;
        }
        Bitmap bitmap = GenerateNotification.getBitmap(gcmBundle.optString("licon"));
        if (bitmap == null) {
            bitmap = GenerateNotification.getBitmapFromAssetsOrResourceName("ic_onesignal_large_icon_default");
        }
        if (bitmap == null) {
            return null;
        }
        try {
            int systemLargeIconHeight = (int)contextResources.getDimension(17104902);
            int systemLargeIconWidth = (int)contextResources.getDimension(0x1050005);
            int bitmapHeight = bitmap.getHeight();
            int bitmapWidth = bitmap.getWidth();
            if (bitmapWidth > systemLargeIconWidth || bitmapHeight > systemLargeIconHeight) {
                int newWidth = systemLargeIconWidth;
                int newHeight = systemLargeIconHeight;
                if (bitmapHeight > bitmapWidth) {
                    float ratio = (float)bitmapWidth / (float)bitmapHeight;
                    newWidth = (int)((float)newHeight * ratio);
                } else if (bitmapWidth > bitmapHeight) {
                    float ratio = (float)bitmapHeight / (float)bitmapWidth;
                    newHeight = (int)((float)newWidth * ratio);
                }
                return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)newWidth, (int)newHeight, (boolean)true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bitmap;
    }

    private static Bitmap getBitmapFromAssetsOrResourceName(String bitmapStr) {
        try {
            Bitmap bitmap = null;
            try {
                bitmap = BitmapFactory.decodeStream((InputStream)currentContext.getAssets().open(bitmapStr));
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (bitmap != null) {
                return bitmap;
            }
            List<String> image_extensions = Arrays.asList(".png", ".webp", ".jpg", ".gif", ".bmp");
            for (String extension : image_extensions) {
                try {
                    bitmap = BitmapFactory.decodeStream((InputStream)currentContext.getAssets().open(bitmapStr + extension));
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (bitmap == null) continue;
                return bitmap;
            }
            int bitmapId = GenerateNotification.getResourceIcon(bitmapStr);
            if (bitmapId != 0) {
                return BitmapFactory.decodeResource((Resources)contextResources, (int)bitmapId);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static Bitmap getBitmapFromURL(String location) {
        try {
            return BitmapFactory.decodeStream((InputStream)new URL(location).openConnection().getInputStream());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Bitmap getBitmap(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith("http://") || name.startsWith("https://")) {
            return GenerateNotification.getBitmapFromURL(name);
        }
        return GenerateNotification.getBitmapFromAssetsOrResourceName(name);
    }

    private static int getResourceIcon(String iconName) {
        if (!GenerateNotification.isValidResourceName(iconName)) {
            return 0;
        }
        int notificationIcon = GenerateNotification.getDrawableId(iconName);
        if (notificationIcon != 0) {
            return notificationIcon;
        }
        try {
            return R.drawable.class.getField(iconName).getInt(null);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    private static int getSmallIconId(JSONObject gcmBundle) {
        int notificationIcon = GenerateNotification.getResourceIcon(gcmBundle.optString("sicon", null));
        if (notificationIcon != 0) {
            return notificationIcon;
        }
        notificationIcon = GenerateNotification.getDrawableId("ic_stat_onesignal_default");
        if (notificationIcon != 0) {
            return notificationIcon;
        }
        notificationIcon = GenerateNotification.getDrawableId("corona_statusbar_icon_default");
        if (notificationIcon != 0) {
            return notificationIcon;
        }
        notificationIcon = GenerateNotification.getDrawableId("ic_os_notification_fallback_white_24dp");
        if (notificationIcon != 0) {
            return notificationIcon;
        }
        return 17301598;
    }

    private static int getDrawableId(String name) {
        return contextResources.getIdentifier(name, "drawable", packageName);
    }

    private static Uri getCustomSound(JSONObject gcmBundle) {
        int soundId;
        String sound = gcmBundle.optString("sound", null);
        if (GenerateNotification.isValidResourceName(sound) && (soundId = contextResources.getIdentifier(sound, "raw", packageName)) != 0) {
            return Uri.parse((String)("android.resource://" + packageName + "/" + soundId));
        }
        soundId = contextResources.getIdentifier("onesignal_default_sound", "raw", packageName);
        if (soundId != 0) {
            return Uri.parse((String)("android.resource://" + packageName + "/" + soundId));
        }
        return null;
    }

    private static BigInteger getAccentColor(JSONObject gcmBundle) {
        try {
            if (gcmBundle.has("bgac")) {
                return new BigInteger(gcmBundle.optString("bgac", null), 16);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            String defaultColor = OSUtils.getManifestMeta(currentContext, "com.onesignal.NotificationAccentColor.DEFAULT");
            if (defaultColor != null) {
                return new BigInteger(defaultColor, 16);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static void addNotificationActionButtons(JSONObject gcmBundle, NotificationCompat.Builder mBuilder, int notificationId, String groupSummary) {
        try {
            JSONObject additionalDataJSON;
            JSONObject customJson = new JSONObject(gcmBundle.optString("custom"));
            if (customJson.has("a") && (additionalDataJSON = customJson.getJSONObject("a")).has("actionButtons")) {
                JSONArray buttons = additionalDataJSON.getJSONArray("actionButtons");
                for (int i = 0; i < buttons.length(); ++i) {
                    JSONObject button = buttons.optJSONObject(i);
                    JSONObject bundle = new JSONObject(gcmBundle.toString());
                    Intent buttonIntent = GenerateNotification.getNewBaseIntent(notificationId);
                    buttonIntent.setAction("" + i);
                    buttonIntent.putExtra("action_button", true);
                    bundle.put("actionSelected", (Object)button.optString("id"));
                    buttonIntent.putExtra("onesignal_data", bundle.toString());
                    if (groupSummary != null) {
                        buttonIntent.putExtra("summary", groupSummary);
                    } else if (gcmBundle.has("grp")) {
                        buttonIntent.putExtra("grp", gcmBundle.optString("grp"));
                    }
                    PendingIntent buttonPIntent = GenerateNotification.getNewActionPendingIntent(notificationId, buttonIntent);
                    int buttonIcon = 0;
                    if (button.has("icon")) {
                        buttonIcon = GenerateNotification.getResourceIcon(button.optString("icon"));
                    }
                    mBuilder.addAction(buttonIcon, (CharSequence)button.optString("text"), buttonPIntent);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void addAlertButtons(Context context, JSONObject gcmBundle, List<String> buttonsLabels, List<String> buttonsIds) {
        try {
            JSONObject additionalDataJSON;
            JSONObject customJson = new JSONObject(gcmBundle.optString("custom"));
            if (customJson.has("a") && (additionalDataJSON = customJson.getJSONObject("a")).has("actionButtons")) {
                JSONArray buttons = additionalDataJSON.optJSONArray("actionButtons");
                for (int i = 0; i < buttons.length(); ++i) {
                    JSONObject button = buttons.getJSONObject(i);
                    buttonsLabels.add(button.optString("text"));
                    buttonsIds.add(button.optString("id"));
                }
            }
            if (buttonsLabels.size() < 3) {
                buttonsLabels.add(OSUtils.getResourceString(context, "onesignal_in_app_alert_ok_button_text", "Ok"));
                buttonsIds.add("__DEFAULT__");
            }
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Failed to parse buttons for alert dialog.", t);
        }
    }
}

