/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import com.onesignal.BadgeCountUpdater;
import com.onesignal.GenerateNotification;
import com.onesignal.NotificationExtenderService;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class NotificationBundleProcessor {
    static final String DEFAULT_ACTION = "__DEFAULT__";

    NotificationBundleProcessor() {
    }

    static void ProcessFromGCMIntentService(Context context, Bundle bundle, NotificationExtenderService.OverrideSettings overrideSettings) {
        if (OneSignal.notValidOrDuplicated(context, bundle)) {
            return;
        }
        NotificationBundleProcessor.Process(context, bundle, overrideSettings);
    }

    static int Process(Context context, Bundle bundle, NotificationExtenderService.OverrideSettings overrideSettings) {
        boolean showAsAlert = OneSignal.getInAppAlertNotificationEnabled(context);
        int notificationId = GenerateNotification.fromBundle(context, bundle, showAsAlert && OneSignal.isAppActive(), overrideSettings);
        NotificationBundleProcessor.saveNotification(context, bundle, false, notificationId);
        return notificationId;
    }

    static JSONArray bundleAsJsonArray(Bundle bundle) {
        JSONArray jsonArray = new JSONArray();
        jsonArray.put((Object)NotificationBundleProcessor.bundleAsJSONObject(bundle));
        return jsonArray;
    }

    static void saveNotification(Context context, Bundle bundle, boolean opened, int notificationId) {
        try {
            JSONObject customJSON = new JSONObject(bundle.getString("custom"));
            OneSignalDbHelper dbHelper = new OneSignalDbHelper(context);
            SQLiteDatabase writableDb = dbHelper.getWritableDatabase();
            ContentValues values = new ContentValues();
            values.put("notification_id", customJSON.getString("i"));
            if (bundle.containsKey("grp")) {
                values.put("group_id", bundle.getString("grp"));
            }
            values.put("opened", Integer.valueOf(opened ? 1 : 0));
            if (!opened) {
                values.put("android_notification_id", Integer.valueOf(notificationId));
            }
            if (bundle.containsKey("title")) {
                values.put("title", bundle.getString("title"));
            }
            values.put("message", bundle.getString("alert"));
            values.put("full_data", NotificationBundleProcessor.bundleAsJSONObject(bundle).toString());
            writableDb.insert("notification", null, values);
            writableDb.delete("notification", "created_time < " + (System.currentTimeMillis() / 1000L - 604800L) + " AND " + "(" + "dismissed" + " = 1 OR " + "opened" + " = 1" + ")", null);
            if (!opened) {
                BadgeCountUpdater.update(writableDb, context);
            }
            writableDb.close();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    static JSONObject bundleAsJSONObject(Bundle bundle) {
        JSONObject json = new JSONObject();
        Set keys = bundle.keySet();
        for (String key : keys) {
            try {
                json.put(key, bundle.get(key));
            }
            catch (JSONException e) {}
        }
        return json;
    }

    static void prepareBundle(Bundle gcmBundle) {
        if (gcmBundle.containsKey("o")) {
            try {
                JSONObject customJSON = new JSONObject(gcmBundle.getString("custom"));
                JSONObject additionalDataJSON = customJSON.has("a") ? customJSON.getJSONObject("a") : new JSONObject();
                JSONArray buttons = new JSONArray(gcmBundle.getString("o"));
                gcmBundle.remove("o");
                for (int i = 0; i < buttons.length(); ++i) {
                    String buttonId;
                    JSONObject button = buttons.getJSONObject(i);
                    String buttonText = button.getString("n");
                    button.remove("n");
                    if (button.has("i")) {
                        buttonId = button.getString("i");
                        button.remove("i");
                    } else {
                        buttonId = buttonText;
                    }
                    button.put("id", (Object)buttonId);
                    button.put("text", (Object)buttonText);
                    if (!button.has("p")) continue;
                    button.put("icon", (Object)button.getString("p"));
                    button.remove("p");
                }
                additionalDataJSON.put("actionButtons", (Object)buttons);
                additionalDataJSON.put("actionSelected", (Object)DEFAULT_ACTION);
                if (!customJSON.has("a")) {
                    customJSON.put("a", (Object)additionalDataJSON);
                }
                gcmBundle.putString("custom", customJSON.toString());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }
}

