/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.shortcutbadger;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.util.Log;
import com.onesignal.shortcutbadger.Badger;
import com.onesignal.shortcutbadger.ShortcutBadgeException;
import com.onesignal.shortcutbadger.impl.AdwHomeBadger;
import com.onesignal.shortcutbadger.impl.ApexHomeBadger;
import com.onesignal.shortcutbadger.impl.AsusHomeLauncher;
import com.onesignal.shortcutbadger.impl.DefaultBadger;
import com.onesignal.shortcutbadger.impl.NewHtcHomeBadger;
import com.onesignal.shortcutbadger.impl.NovaHomeBadger;
import com.onesignal.shortcutbadger.impl.SolidHomeBadger;
import com.onesignal.shortcutbadger.impl.SonyHomeBadger;
import com.onesignal.shortcutbadger.impl.XiaomiHomeBadger;
import java.util.LinkedList;
import java.util.List;

public final class ShortcutBadger {
    private static final String LOG_TAG = ShortcutBadger.class.getSimpleName();
    private static final List<Class<? extends Badger>> BADGERS = new LinkedList<Class<? extends Badger>>();
    private static Badger sShortcutBadger;
    private static ComponentName sComponentName;

    public static boolean applyCount(Context context, int badgeCount) {
        try {
            ShortcutBadger.applyCountOrThrow(context, badgeCount);
            return true;
        }
        catch (ShortcutBadgeException e) {
            Log.e((String)LOG_TAG, (String)("Unable to execute badge:" + e.getMessage()));
            return false;
        }
    }

    public static void applyCountOrThrow(Context context, int badgeCount) throws ShortcutBadgeException {
        if (sShortcutBadger == null) {
            ShortcutBadger.initBadger(context);
        }
        try {
            sShortcutBadger.executeBadge(context, sComponentName, badgeCount);
        }
        catch (Throwable e) {
            throw new ShortcutBadgeException("Unable to execute badge:" + e.getMessage());
        }
    }

    public static boolean removeCount(Context context) {
        return ShortcutBadger.applyCount(context, 0);
    }

    public static void removeCountOrThrow(Context context) throws ShortcutBadgeException {
        ShortcutBadger.applyCountOrThrow(context, 0);
    }

    private static void initBadger(Context context) {
        sComponentName = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName()).getComponent();
        Log.d((String)LOG_TAG, (String)"Finding badger");
        try {
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.addCategory("android.intent.category.HOME");
            ResolveInfo resolveInfo = context.getPackageManager().resolveActivity(intent, 65536);
            String currentHomePackage = resolveInfo.activityInfo.packageName;
            for (Class<? extends Badger> badger : BADGERS) {
                Badger shortcutBadger = badger.newInstance();
                if (!shortcutBadger.getSupportLaunchers().contains(currentHomePackage)) continue;
                sShortcutBadger = shortcutBadger;
                break;
            }
            if (sShortcutBadger == null && Build.MANUFACTURER.equalsIgnoreCase("Xiaomi")) {
                sShortcutBadger = new XiaomiHomeBadger();
                return;
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
        }
        if (sShortcutBadger == null) {
            sShortcutBadger = new DefaultBadger();
        }
        Log.d((String)LOG_TAG, (String)("Current badger:" + sShortcutBadger.getClass().getCanonicalName()));
    }

    private ShortcutBadger() {
    }

    static {
        BADGERS.add(AdwHomeBadger.class);
        BADGERS.add(ApexHomeBadger.class);
        BADGERS.add(NewHtcHomeBadger.class);
        BADGERS.add(NovaHomeBadger.class);
        BADGERS.add(SolidHomeBadger.class);
        BADGERS.add(SonyHomeBadger.class);
        BADGERS.add(XiaomiHomeBadger.class);
        BADGERS.add(AsusHomeLauncher.class);
    }
}

