/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import com.onesignal.GcmBroadcastReceiver;
import com.onesignal.NotificationBundleProcessor;
import com.onesignal.OSNotificationDisplayedResult;
import com.onesignal.OSNotificationPayload;
import com.onesignal.OneSignal;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class NotificationExtenderService
extends IntentService {
    private OSNotificationDisplayedResult osNotificationDisplayedResult;
    private Bundle currentExtras;

    public NotificationExtenderService() {
        super("NotificationExtenderService");
    }

    protected final OSNotificationDisplayedResult displayNotification(OverrideSettings overrideSettings) {
        if (this.osNotificationDisplayedResult != null || overrideSettings == null) {
            return null;
        }
        OSNotificationDisplayedResult osNotificationDisplayedResult = new OSNotificationDisplayedResult();
        osNotificationDisplayedResult.notificationId = NotificationBundleProcessor.Process((Context)this, this.currentExtras, overrideSettings);
        return osNotificationDisplayedResult;
    }

    protected abstract boolean onNotificationProcessing(OSNotificationPayload var1);

    protected final void onHandleIntent(Intent intent) {
        this.processIntent(intent);
        GcmBroadcastReceiver.completeWakefulIntent((Intent)intent);
    }

    private void processIntent(Intent intent) {
        this.currentExtras = intent.getExtras();
        if (OneSignal.notValidOrDuplicated((Context)this, this.currentExtras)) {
            return;
        }
        OSNotificationPayload notification = new OSNotificationPayload();
        try {
            JSONObject customJson = new JSONObject(this.currentExtras.getString("custom"));
            notification.notificationId = customJson.optString("i");
            notification.additionalData = customJson.optJSONObject("a");
            notification.launchUrl = customJson.optString("u", null);
            notification.message = this.currentExtras.getString("alert");
            notification.title = this.currentExtras.getString("title");
            notification.smallIcon = this.currentExtras.getString("sicon");
            notification.bigPicture = this.currentExtras.getString("bicon");
            notification.largeIcon = this.currentExtras.getString("licon");
            notification.sound = this.currentExtras.getString("sound");
            notification.group = this.currentExtras.getString("grp");
            notification.groupMessage = this.currentExtras.getString("grp_msg");
            notification.backgroundColor = this.currentExtras.getString("bgac");
            notification.ledColor = this.currentExtras.getString("ledc");
            notification.visibility = Integer.parseInt(this.currentExtras.getString("vis"));
            notification.backgroundData = "1".equals(this.currentExtras.getString("bgn"));
            notification.fromProjectNumber = this.currentExtras.getString("from");
            if (notification.additionalData != null && notification.additionalData.has("actionButtons")) {
                JSONArray jsonActionButtons = notification.additionalData.getJSONArray("actionButtons");
                notification.actionButtons = new ArrayList<OSNotificationPayload.ActionButton>();
                for (int i = 0; i < jsonActionButtons.length(); ++i) {
                    JSONObject jsonActionButton = jsonActionButtons.getJSONObject(i);
                    OSNotificationPayload.ActionButton actionButton = new OSNotificationPayload.ActionButton();
                    actionButton.id = jsonActionButton.getString("id");
                    actionButton.text = jsonActionButton.getString("text");
                    actionButton.icon = jsonActionButton.optString("icon", null);
                    notification.actionButtons.add(actionButton);
                }
                notification.additionalData.remove("actionSelected");
                notification.additionalData.remove("actionButtons");
            }
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error assigning OSNotificationPayload values!", t);
        }
        this.osNotificationDisplayedResult = null;
        boolean developerProcessed = this.onNotificationProcessing(notification);
        if (this.osNotificationDisplayedResult == null) {
            if (developerProcessed) {
                NotificationBundleProcessor.saveNotification((Context)this, this.currentExtras, true, -1);
            } else {
                NotificationBundleProcessor.Process((Context)this, this.currentExtras, null);
            }
        }
    }

    static Intent getIntent(Context context, Bundle extras) {
        Intent intent;
        PackageManager packageManager = context.getPackageManager();
        List resolveInfo = packageManager.queryIntentServices(intent = new Intent().setAction("com.onesignal.NotificationExtender").setPackage(context.getPackageName()), 128);
        if (resolveInfo.size() < 1) {
            return null;
        }
        intent.putExtras(extras);
        return intent;
    }

    public class OverrideSettings {
        public NotificationCompat.Extender extender;
    }
}

