/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.HandlerThread;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalRestClient;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

class OneSignalStateSynchronizer {
    private static boolean onSessionDone = false;
    private static boolean postSessionCalled = false;
    private static boolean waitingForSessionResponse = false;
    private static UserState currentUserState;
    private static UserState toSyncUserState;
    static HashMap<Integer, NetworkHandlerThread> networkHandlerThreads;
    private static Context appContext;
    private static final String[] LOCATION_FIELDS;
    private static final Set<String> LOCATION_FIELDS_SET;

    OneSignalStateSynchronizer() {
    }

    private static JSONObject generateJsonDiff(JSONObject cur, JSONObject changedTo, JSONObject baseOutput, Set<String> includeFields) {
        Iterator keys = changedTo.keys();
        JSONObject output = baseOutput != null ? baseOutput : new JSONObject();
        while (keys.hasNext()) {
            try {
                String key = (String)keys.next();
                Object value = changedTo.get(key);
                if (cur.has(key)) {
                    Object curValue;
                    if (value instanceof JSONObject) {
                        JSONObject returnedJson;
                        String returnedJsonStr;
                        curValue = cur.getJSONObject(key);
                        JSONObject outValue = null;
                        if (baseOutput != null && baseOutput.has(key)) {
                            outValue = baseOutput.getJSONObject(key);
                        }
                        if ((returnedJsonStr = (returnedJson = OneSignalStateSynchronizer.generateJsonDiff(curValue, (JSONObject)value, outValue, includeFields)).toString()).equals("{}")) continue;
                        output.put(key, (Object)new JSONObject(returnedJsonStr));
                        continue;
                    }
                    if (includeFields != null && includeFields.contains(key)) {
                        output.put(key, value);
                        continue;
                    }
                    curValue = cur.get(key);
                    if (value.equals(curValue)) continue;
                    if (curValue instanceof Integer && !"".equals(value)) {
                        if (((Number)curValue).doubleValue() == ((Number)value).doubleValue()) continue;
                        output.put(key, value);
                        continue;
                    }
                    output.put(key, value);
                    continue;
                }
                if (value instanceof JSONObject) {
                    output.put(key, (Object)new JSONObject(value.toString()));
                    continue;
                }
                output.put(key, value);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return output;
    }

    private static JSONObject getTagsWithoutDeletedKeys(JSONObject jsonObject) {
        if (jsonObject.has("tags")) {
            JSONObject toReturn = new JSONObject();
            JSONObject keyValues = jsonObject.optJSONObject("tags");
            Iterator keys = keyValues.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                try {
                    Object value = keyValues.get(key);
                    if ("".equals(value)) continue;
                    toReturn.put(key, value);
                }
                catch (Throwable t) {}
            }
            return toReturn;
        }
        return null;
    }

    public static void stopAndPersist() {
        for (Map.Entry<Integer, NetworkHandlerThread> handlerThread : networkHandlerThreads.entrySet()) {
            handlerThread.getValue().stopScheduledRunnable();
        }
        if (toSyncUserState != null) {
            OneSignalStateSynchronizer.toSyncUserState.persistState();
        }
    }

    static void initUserState(Context context) {
        appContext = context;
        if (currentUserState != null) {
            return;
        }
        OneSignalStateSynchronizer oneSignalStateSynchronizer = new OneSignalStateSynchronizer();
        oneSignalStateSynchronizer.getClass();
        currentUserState = oneSignalStateSynchronizer.new UserState("CURRENT_STATE", true);
        OneSignalStateSynchronizer oneSignalStateSynchronizer2 = new OneSignalStateSynchronizer();
        oneSignalStateSynchronizer2.getClass();
        toSyncUserState = oneSignalStateSynchronizer2.new UserState("TOSYNC_STATE", true);
    }

    static UserState getNewUserState() {
        OneSignalStateSynchronizer oneSignalStateSynchronizer = new OneSignalStateSynchronizer();
        oneSignalStateSynchronizer.getClass();
        return oneSignalStateSynchronizer.new UserState("nonPersist", false);
    }

    static void syncUserState(boolean fromSyncService) {
        boolean isSessionCall = !onSessionDone && postSessionCalled && !waitingForSessionResponse;
        final JSONObject jsonBody = OneSignalStateSynchronizer.currentUserState.generateJsonDiff(OneSignalStateSynchronizer.toSyncUserState, isSessionCall);
        final JSONObject dependDiff = OneSignalStateSynchronizer.generateJsonDiff(OneSignalStateSynchronizer.currentUserState.dependValues, OneSignalStateSynchronizer.toSyncUserState.dependValues, null, null);
        if (jsonBody == null) {
            OneSignalStateSynchronizer.currentUserState.persistStateAfterSync(dependDiff, null);
            return;
        }
        String userId = OneSignal.getUserId();
        OneSignalStateSynchronizer.toSyncUserState.persistState();
        if (onSessionDone || fromSyncService) {
            OneSignalRestClient.putSync("players/" + userId, jsonBody, new OneSignalRestClient.ResponseHandler(){

                @Override
                void onFailure(int statusCode, String response, Throwable throwable) {
                    OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "Failed last request. statusCode: " + statusCode + "\nresponse: " + response);
                    if (OneSignalStateSynchronizer.response400WithErrorsContaining(statusCode, response, "No user with this id found")) {
                        OneSignalStateSynchronizer.resetCurrentState();
                        OneSignalStateSynchronizer.postNewSyncUserState();
                    } else {
                        OneSignalStateSynchronizer.getNetworkHandlerThread(0).doRetry();
                    }
                }

                @Override
                void onSuccess(String response) {
                    currentUserState.persistStateAfterSync(dependDiff, jsonBody);
                }
            });
        } else if (postSessionCalled) {
            String urlStr = userId == null ? "players" : "players/" + userId + "/on_session";
            waitingForSessionResponse = true;
            OneSignalRestClient.postSync(urlStr, jsonBody, new OneSignalRestClient.ResponseHandler(){

                @Override
                void onFailure(int statusCode, String response, Throwable throwable) {
                    waitingForSessionResponse = false;
                    OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "Failed last request. statusCode: " + statusCode + "\nresponse: " + response);
                    if (OneSignalStateSynchronizer.response400WithErrorsContaining(statusCode, response, "not a valid device_type")) {
                        OneSignalStateSynchronizer.resetCurrentState();
                        OneSignalStateSynchronizer.postNewSyncUserState();
                    } else {
                        OneSignalStateSynchronizer.getNetworkHandlerThread(0).doRetry();
                    }
                }

                @Override
                void onSuccess(String response) {
                    onSessionDone = true;
                    waitingForSessionResponse = false;
                    currentUserState.persistStateAfterSync(dependDiff, jsonBody);
                    try {
                        JSONObject jsonResponse = new JSONObject(response);
                        if (jsonResponse.has("id")) {
                            String userId = jsonResponse.getString("id");
                            OneSignal.saveUserId(userId);
                            OneSignal.fireIdsAvailableCallback();
                            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "Device registered, UserId = " + userId);
                        } else {
                            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "session sent, UserId = " + OneSignal.getUserId());
                        }
                    }
                    catch (Throwable t) {
                        OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "ERROR parsing on_session or create JSON Response.", t);
                    }
                }
            });
        }
    }

    private static boolean response400WithErrorsContaining(int statusCode, String response, String contains) {
        if (statusCode == 400 && response != null) {
            try {
                JSONObject responseJson = new JSONObject(response);
                return responseJson.has("errors") && responseJson.optString("errors").contains(contains);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return false;
    }

    private static NetworkHandlerThread getNetworkHandlerThread(Integer type) {
        if (!networkHandlerThreads.containsKey(type)) {
            networkHandlerThreads.put(type, new NetworkHandlerThread(type));
        }
        return networkHandlerThreads.get(type);
    }

    private static UserState getUserStateForModification() {
        if (toSyncUserState == null) {
            toSyncUserState = OneSignalStateSynchronizer.currentUserState.deepClone("TOSYNC_STATE");
        }
        OneSignalStateSynchronizer.postNewSyncUserState();
        return toSyncUserState;
    }

    private static void postNewSyncUserState() {
        OneSignalStateSynchronizer.getNetworkHandlerThread(0).runNewJob();
    }

    static void postSession(UserState postSession) {
        JSONObject toSync = OneSignalStateSynchronizer.getUserStateForModification().syncValues;
        OneSignalStateSynchronizer.generateJsonDiff(toSync, postSession.syncValues, toSync, null);
        JSONObject dependValues = OneSignalStateSynchronizer.getUserStateForModification().dependValues;
        OneSignalStateSynchronizer.generateJsonDiff(dependValues, postSession.dependValues, dependValues, null);
        postSessionCalled = true;
    }

    static void sendTags(JSONObject newTags) {
        JSONObject userStateTags = OneSignalStateSynchronizer.getUserStateForModification().syncValues;
        try {
            OneSignalStateSynchronizer.generateJsonDiff(userStateTags, new JSONObject().put("tags", (Object)newTags), userStateTags, null);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    static void setSubscription(boolean enable) {
        try {
            OneSignalStateSynchronizer.getUserStateForModification().dependValues.put("userSubscribePref", enable);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    static void updateIdentifier(String identifier) {
        UserState userState = OneSignalStateSynchronizer.getUserStateForModification();
        try {
            userState.syncValues.put("identifier", (Object)identifier);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    static void updateLocation(Double lat, Double log, Float accuracy, Integer type) {
        UserState userState = OneSignalStateSynchronizer.getUserStateForModification();
        try {
            userState.syncValues.put("lat", (Object)lat);
            userState.syncValues.put("long", (Object)log);
            userState.syncValues.put("loc_acc", (Object)accuracy);
            userState.syncValues.put("loc_type", (Object)type);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    static boolean getSubscribed() {
        return OneSignalStateSynchronizer.toSyncUserState.getNotificationTypes() > 0;
    }

    static String getRegistrationId() {
        return OneSignalStateSynchronizer.toSyncUserState.syncValues.optString("identifier", null);
    }

    static JSONObject getTags() {
        return OneSignalStateSynchronizer.getTagsWithoutDeletedKeys(OneSignalStateSynchronizer.toSyncUserState.syncValues);
    }

    static void resetCurrentState() {
        onSessionDone = false;
        OneSignal.saveUserId(null);
        OneSignalStateSynchronizer.currentUserState.syncValues = new JSONObject();
        OneSignalStateSynchronizer.currentUserState.persistState();
    }

    static {
        networkHandlerThreads = new HashMap();
        LOCATION_FIELDS = new String[]{"lat", "long", "loc_acc", "loc_type"};
        LOCATION_FIELDS_SET = new HashSet<String>(Arrays.asList(LOCATION_FIELDS));
    }

    static class NetworkHandlerThread
    extends HandlerThread {
        private static final int NETWORK_HANDLER_USERSTATE = 0;
        int mType;
        Handler mHandler = null;
        static final int MAX_RETRIES = 3;
        int currentRetry;

        NetworkHandlerThread(int type) {
            super("NetworkHandlerThread");
            this.mType = type;
            this.start();
            this.mHandler = new Handler(this.getLooper());
        }

        public void runNewJob() {
            this.currentRetry = 0;
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler.postDelayed(this.getNewRunnable(), 5000L);
        }

        private Runnable getNewRunnable() {
            switch (this.mType) {
                case 0: {
                    return new Runnable(){

                        @Override
                        public void run() {
                            OneSignalStateSynchronizer.syncUserState(false);
                        }
                    };
                }
            }
            return null;
        }

        void stopScheduledRunnable() {
            this.mHandler.removeCallbacksAndMessages(null);
        }

        void doRetry() {
            if (this.currentRetry < 3 && !this.mHandler.hasMessages(0)) {
                ++this.currentRetry;
                this.mHandler.postDelayed(this.getNewRunnable(), (long)(this.currentRetry * 10000));
            }
        }
    }

    class UserState {
        private final int UNSUBSCRIBE_VALUE = -2;
        private String persistKey;
        JSONObject dependValues;
        JSONObject syncValues;

        private UserState(String inPersistKey, boolean load) {
            this.persistKey = inPersistKey;
            if (load) {
                this.loadState();
            } else {
                this.dependValues = new JSONObject();
                this.syncValues = new JSONObject();
            }
        }

        private UserState deepClone(String persistKey) {
            UserState clonedUserState = new UserState(persistKey, false);
            try {
                clonedUserState.dependValues = new JSONObject(this.dependValues.toString());
                clonedUserState.syncValues = new JSONObject(this.syncValues.toString());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return clonedUserState;
        }

        private void addDependFields() {
            try {
                this.syncValues.put("notification_types", this.getNotificationTypes());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }

        private int getNotificationTypes() {
            try {
                int subscribableStatus = this.dependValues.getInt("subscribableStatus");
                boolean userSubscribePref = this.dependValues.getBoolean("userSubscribePref");
                return subscribableStatus < -2 ? subscribableStatus : (userSubscribePref ? 1 : -2);
            }
            catch (JSONException e) {
                e.printStackTrace();
                return 1;
            }
        }

        private Set<String> getGroupChangeField(JSONObject cur, JSONObject changedTo) {
            try {
                if (cur.getDouble("lat") != changedTo.getDouble("lat") || cur.getDouble("long") != changedTo.getDouble("long") || cur.getDouble("loc_acc") != changedTo.getDouble("loc_acc") || cur.getDouble("loc_type") != changedTo.getDouble("loc_type")) {
                    return LOCATION_FIELDS_SET;
                }
            }
            catch (Throwable t) {
                return LOCATION_FIELDS_SET;
            }
            return null;
        }

        private JSONObject generateJsonDiff(UserState newState, boolean isSessionCall) {
            this.addDependFields();
            newState.addDependFields();
            Set<String> includeFields = this.getGroupChangeField(this.syncValues, newState.syncValues);
            JSONObject sendJson = OneSignalStateSynchronizer.generateJsonDiff(this.syncValues, newState.syncValues, null, includeFields);
            if (!isSessionCall && sendJson.toString().equals("{}")) {
                return null;
            }
            try {
                if (!sendJson.has("app_id")) {
                    sendJson.put("app_id", (Object)((String)this.syncValues.opt("app_id")));
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return sendJson;
        }

        void set(String key, Object value) {
            try {
                this.syncValues.put(key, value);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }

        void setState(String key, Object value) {
            try {
                this.dependValues.put(key, value);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }

        private void loadState() {
            SharedPreferences prefs = OneSignal.getGcmPreferences(appContext);
            String dependValuesStr = prefs.getString("ONESIGNAL_USERSTATE_DEPENDVALYES_" + this.persistKey, null);
            if (dependValuesStr == null) {
                this.dependValues = new JSONObject();
                try {
                    boolean userSubscribePref = true;
                    int subscribableStatus = this.persistKey.equals("CURRENT_STATE") ? prefs.getInt("ONESIGNAL_SUBSCRIPTION", 1) : prefs.getInt("ONESIGNAL_SYNCED_SUBSCRIPTION", 1);
                    if (subscribableStatus == -2) {
                        subscribableStatus = 1;
                        userSubscribePref = false;
                    }
                    this.dependValues.put("subscribableStatus", subscribableStatus);
                    this.dependValues.put("userSubscribePref", userSubscribePref);
                }
                catch (JSONException e) {}
            } else {
                try {
                    this.dependValues = new JSONObject(dependValuesStr);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            String syncValuesStr = prefs.getString("ONESIGNAL_USERSTATE_SYNCVALYES_" + this.persistKey, null);
            try {
                if (syncValuesStr == null) {
                    this.syncValues = new JSONObject();
                    this.syncValues.put("identifier", (Object)prefs.getString("GT_REGISTRATION_ID", null));
                } else {
                    this.syncValues = new JSONObject(syncValuesStr);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }

        private void persistState() {
            SharedPreferences prefs = OneSignal.getGcmPreferences(appContext);
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString("ONESIGNAL_USERSTATE_SYNCVALYES_" + this.persistKey, this.syncValues.toString());
            editor.putString("ONESIGNAL_USERSTATE_DEPENDVALYES_" + this.persistKey, this.dependValues.toString());
            editor.commit();
        }

        private void persistStateAfterSync(JSONObject inDependValues, JSONObject inSyncValues) {
            if (inDependValues != null) {
                OneSignalStateSynchronizer.generateJsonDiff(this.dependValues, inDependValues, this.dependValues, null);
            }
            if (inSyncValues != null) {
                OneSignalStateSynchronizer.generateJsonDiff(this.syncValues, inSyncValues, this.syncValues, null);
                if (inSyncValues.has("tags")) {
                    JSONObject newTags = new JSONObject();
                    JSONObject curTags = inSyncValues.optJSONObject("tags");
                    Iterator keys = curTags.keys();
                    try {
                        while (keys.hasNext()) {
                            String key = (String)keys.next();
                            if ("".equals(curTags.optString(key))) continue;
                            newTags.put(key, (Object)curTags.optString(key));
                        }
                        if (newTags.toString().equals("{}")) {
                            this.syncValues.remove("tags");
                        } else {
                            this.syncValues.put("tags", (Object)newTags);
                        }
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
            if (inDependValues != null || inSyncValues != null) {
                this.persistState();
            }
        }
    }
}

