/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import com.onesignal.OneSignal;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Scanner;
import org.json.JSONObject;

class OneSignalRestClient {
    private static final String BASE_URL = "https://onesignal.com/api/v1/";
    private static final int TIMEOUT = 120000;

    OneSignalRestClient() {
    }

    static void put(final String url, final JSONObject jsonBody, final ResponseHandler responseHandler) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                OneSignalRestClient.makeRequest(url, "PUT", jsonBody, responseHandler);
            }
        }).start();
    }

    static void post(final String url, final JSONObject jsonBody, final ResponseHandler responseHandler) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                OneSignalRestClient.makeRequest(url, "POST", jsonBody, responseHandler);
            }
        }).start();
    }

    static void get(final String url, final ResponseHandler responseHandler) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                OneSignalRestClient.makeRequest(url, null, null, responseHandler);
            }
        }).start();
    }

    static void putSync(String url, JSONObject jsonBody, ResponseHandler responseHandler) {
        OneSignalRestClient.makeRequest(url, "PUT", jsonBody, responseHandler);
    }

    static void postSync(String url, JSONObject jsonBody, ResponseHandler responseHandler) {
        OneSignalRestClient.makeRequest(url, "POST", jsonBody, responseHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void makeRequest(String url, String method, JSONObject jsonBody, ResponseHandler responseHandler) {
        HttpURLConnection con = null;
        int httpResponse = -1;
        try {
            Scanner scanner;
            con = (HttpURLConnection)new URL(BASE_URL + url).openConnection();
            con.setUseCaches(false);
            con.setDoOutput(true);
            con.setConnectTimeout(120000);
            con.setReadTimeout(120000);
            if (jsonBody != null) {
                con.setDoInput(true);
            }
            con.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            con.setRequestMethod(method);
            if (jsonBody != null) {
                String strJsonBody = jsonBody.toString();
                OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, method + " SEND JSON: " + strJsonBody);
                byte[] sendBytes = strJsonBody.getBytes("UTF-8");
                con.setFixedLengthStreamingMode(sendBytes.length);
                OutputStream outputStream = con.getOutputStream();
                outputStream.write(sendBytes);
            }
            if ((httpResponse = con.getResponseCode()) == 200) {
                scanner = new Scanner(con.getInputStream(), "UTF-8");
                String json = scanner.useDelimiter("\\A").hasNext() ? scanner.next() : "";
                scanner.close();
                OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, method + " RECEIVED JSON: " + json);
                if (responseHandler != null) {
                    responseHandler.onSuccess(json);
                }
            } else {
                scanner = new Scanner(con.getErrorStream(), "UTF-8");
                String json = scanner.useDelimiter("\\A").hasNext() ? scanner.next() : "";
                scanner.close();
                OneSignal.Log(OneSignal.LOG_LEVEL.WARN, method + " RECEIVED JSON: " + json);
                if (responseHandler != null) {
                    responseHandler.onFailure(httpResponse, json, null);
                }
            }
        }
        catch (Throwable t) {
            if (t instanceof ConnectException || t instanceof UnknownHostException) {
                OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "Could not send last request, device is offline. Throwable: " + t.getClass().getName());
            } else {
                OneSignal.Log(OneSignal.LOG_LEVEL.WARN, method + " Error thrown from network stack. ", t);
            }
            if (responseHandler != null) {
                responseHandler.onFailure(httpResponse, null, t);
            }
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    static class ResponseHandler {
        ResponseHandler() {
        }

        void onSuccess(String response) {
        }

        void onFailure(int statusCode, String response, Throwable throwable) {
        }
    }
}

