/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.onesignal.OneSignal;
import com.onesignal.PushRegistrator;

class PushRegistratorGPS
implements PushRegistrator {
    private Context appContext;
    private PushRegistrator.RegisteredHandler registeredHandler;

    PushRegistratorGPS() {
    }

    @Override
    public void registerForPush(Context context, String googleProjectNumber, PushRegistrator.RegisteredHandler callback) {
        this.appContext = context;
        this.registeredHandler = callback;
        try {
            if (this.checkPlayServices()) {
                this.registerInBackground(googleProjectNumber);
            } else {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "No valid Google Play services APK found.");
                this.registeredHandler.complete(null);
            }
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Could not register with GCM due to an error with the AndroidManifest.xml file or with 'Google Play services'.", t);
            this.registeredHandler.complete(null);
        }
    }

    private boolean isGooglePlayStoreInstalled() {
        try {
            PackageManager pm = this.appContext.getPackageManager();
            PackageInfo info = pm.getPackageInfo("com.android.vending", 1);
            String label = (String)info.applicationInfo.loadLabel(pm);
            return label != null && !label.equals("Market");
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private boolean checkPlayServices() {
        int resultCode = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.appContext);
        if (resultCode != 0) {
            if (GooglePlayServicesUtil.isUserRecoverableError((int)resultCode) && this.isGooglePlayStoreInstalled()) {
                OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "Google Play services Recoverable Error: " + resultCode);
                SharedPreferences prefs = OneSignal.getGcmPreferences(this.appContext);
                if (prefs.getBoolean("GT_DO_NOT_SHOW_MISSING_GPS", false)) {
                    return false;
                }
                try {
                    this.ShowUpdateGPSDialog(resultCode);
                }
                catch (Throwable throwable) {}
            } else {
                OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "Google Play services error: This device is not supported. Code:" + resultCode);
            }
            return false;
        }
        return true;
    }

    private void ShowUpdateGPSDialog(final int resultCode) {
        ((Activity)this.appContext).runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AlertDialog.Builder builder = new AlertDialog.Builder(PushRegistratorGPS.this.appContext);
                builder.setMessage((CharSequence)"To receive push notifications please press 'Update' to enable 'Google Play services'.").setPositiveButton((CharSequence)"Update", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        try {
                            GooglePlayServicesUtil.getErrorPendingIntent((int)resultCode, (Context)PushRegistratorGPS.this.appContext, (int)0).send();
                        }
                        catch (PendingIntent.CanceledException e) {
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }).setNegativeButton((CharSequence)"Skip", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        SharedPreferences prefs = OneSignal.getGcmPreferences(PushRegistratorGPS.this.appContext);
                        SharedPreferences.Editor editor = prefs.edit();
                        editor.putBoolean("GT_DO_NOT_SHOW_MISSING_GPS", true);
                        editor.commit();
                    }
                }).setNeutralButton((CharSequence)"Close", null).create().show();
            }
        });
    }

    private void registerInBackground(final String googleProjectNumber) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String registrationId = null;
                try {
                    GoogleCloudMessaging gcm = GoogleCloudMessaging.getInstance((Context)PushRegistratorGPS.this.appContext);
                    registrationId = gcm.register(new String[]{googleProjectNumber});
                    OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "Device registered, Google Registration ID=" + registrationId);
                }
                catch (Throwable t) {
                    OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error Getting Google Registration ID", t);
                }
                PushRegistratorGPS.this.registeredHandler.complete(registrationId);
            }
        }).start();
    }
}

