/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.saml2.logout;

import com.onelogin.saml2.exception.XMLEntityException;
import com.onelogin.saml2.http.HttpRequest;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.util.Constants;
import com.onelogin.saml2.util.SchemaFactory;
import com.onelogin.saml2.util.Util;
import java.io.IOException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.HashMap;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LogoutResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogoutResponse.class);
    private String logoutResponseString;
    private Document logoutResponseDocument;
    private String id;
    private final Saml2Settings settings;
    private final HttpRequest request;
    private String currentUrl;
    private String inResponseTo;
    private Calendar issueInstant;
    private String error;

    public LogoutResponse(Saml2Settings settings, HttpRequest request) throws XMLEntityException {
        this.settings = settings;
        this.request = request;
        String samlLogoutResponse = null;
        if (request != null) {
            this.currentUrl = request.getRequestURL();
            samlLogoutResponse = request.getParameter("SAMLResponse");
        }
        if (samlLogoutResponse != null && !samlLogoutResponse.isEmpty()) {
            this.logoutResponseString = Util.base64decodedInflated(samlLogoutResponse);
            this.logoutResponseDocument = Util.loadXML(this.logoutResponseString);
        }
    }

    public String getEncodedLogoutResponse(Boolean deflated) throws IOException {
        if (deflated == null) {
            deflated = this.settings.isCompressResponseEnabled();
        }
        String encodedLogoutResponse = deflated != false ? Util.deflatedBase64encoded(this.getLogoutResponseXml()) : Util.base64encoder(this.getLogoutResponseXml());
        return encodedLogoutResponse;
    }

    public String getEncodedLogoutResponse() throws IOException {
        return this.getEncodedLogoutResponse(null);
    }

    protected String getLogoutResponseXml() {
        return this.logoutResponseString;
    }

    public Boolean isValid(String requestId) {
        this.error = null;
        try {
            if (this.logoutResponseDocument == null) {
                throw new Exception("SAML Logout Response is not loaded");
            }
            if (this.currentUrl == null || this.currentUrl.isEmpty()) {
                throw new Exception("The URL of the current host was not established");
            }
            String signature = this.request.getParameter("Signature");
            if (this.settings.isStrict()) {
                String destinationUrl;
                String responseInResponseTo;
                Element rootElement = this.logoutResponseDocument.getDocumentElement();
                rootElement.normalize();
                if (this.settings.getWantXMLValidation().booleanValue() && !Util.validateXML(this.logoutResponseDocument, SchemaFactory.SAML_SCHEMA_PROTOCOL_2_0)) {
                    throw new Exception("Invalid SAML Logout Response. Not match the saml-schema-protocol-2.0.xsd");
                }
                if (requestId != null && rootElement.hasAttribute("InResponseTo") && !(responseInResponseTo = rootElement.getAttribute("InResponseTo")).equals(requestId)) {
                    throw new Exception("The InResponseTo of the Logout Response: " + responseInResponseTo + ", does not match the ID of the Logout request sent by the SP:: " + requestId);
                }
                String issuer = this.getIssuer();
                if (issuer != null && !issuer.isEmpty() && !issuer.equals(this.settings.getIdpEntityId())) {
                    throw new Exception("Invalid issuer in the Logout Response");
                }
                if (rootElement.hasAttribute("Destination") && (destinationUrl = rootElement.getAttribute("Destination")) != null && !destinationUrl.isEmpty() && !destinationUrl.equals(this.currentUrl)) {
                    throw new Exception("The LogoutResponse was received at " + this.currentUrl + " instead of " + destinationUrl);
                }
                if (this.settings.getWantMessagesSigned().booleanValue() && (signature == null || signature.isEmpty())) {
                    throw new Exception("The Message of the Logout Response is not signed and the SP requires it");
                }
            }
            if (signature != null && !signature.isEmpty()) {
                X509Certificate cert = this.settings.getIdpx509cert();
                if (cert == null) {
                    throw new Exception("In order to validate the sign on the Logout Response, the x509cert of the IdP is required");
                }
                String signAlg = this.request.getParameter("SigAlg");
                if (signAlg == null || signAlg.isEmpty()) {
                    signAlg = Constants.RSA_SHA1;
                }
                String signedQuery = "SAMLResponse=" + Util.urlEncoder(this.request.getParameter("SAMLResponse"));
                String relayState = this.request.getParameter("RelayState");
                if (relayState != null && !relayState.isEmpty()) {
                    signedQuery = signedQuery + "&RelayState=" + Util.urlEncoder(relayState);
                }
                if (!Util.validateBinarySignature(signedQuery = signedQuery + "&SigAlg=" + Util.urlEncoder(signAlg), Util.base64decoder(signature), cert, signAlg).booleanValue()) {
                    throw new Exception("Signature validation failed. Logout Response rejected");
                }
            }
            LOGGER.debug("LogoutRequest validated --> " + this.logoutResponseString);
            return true;
        }
        catch (Exception e) {
            this.error = e.getMessage();
            LOGGER.debug("LogoutResponse invalid --> " + this.logoutResponseString);
            LOGGER.error(this.error);
            return false;
        }
    }

    public Boolean isValid() {
        return this.isValid(null);
    }

    public String getIssuer() throws XPathExpressionException {
        String issuer = null;
        NodeList issuers = this.query("/samlp:LogoutResponse/saml:Issuer");
        if (issuers.getLength() == 1) {
            issuer = issuers.item(0).getTextContent();
        }
        return issuer;
    }

    public String getStatus() throws XPathExpressionException {
        String statusCode = null;
        NodeList entries = this.query("/samlp:LogoutResponse/samlp:Status/samlp:StatusCode");
        if (entries.getLength() == 1) {
            statusCode = entries.item(0).getAttributes().getNamedItem("Value").getNodeValue();
        }
        return statusCode;
    }

    private NodeList query(String query) throws XPathExpressionException {
        return Util.query(this.logoutResponseDocument, query, null);
    }

    public void build(String inResponseTo) {
        this.id = Util.generateUniqueID();
        this.issueInstant = Calendar.getInstance();
        this.inResponseTo = inResponseTo;
        StrSubstitutor substitutor = this.generateSubstitutor(this.settings);
        this.logoutResponseString = substitutor.replace((CharSequence)LogoutResponse.getLogoutResponseTemplate());
    }

    public void build() {
        this.build(null);
    }

    private StrSubstitutor generateSubstitutor(Saml2Settings settings) {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("id", this.id);
        String issueInstantString = Util.formatDateTime(this.issueInstant.getTimeInMillis());
        valueMap.put("issueInstant", issueInstantString);
        String destinationStr = "";
        URL slo = settings.getIdpSingleLogoutServiceResponseUrl();
        if (slo != null) {
            destinationStr = " Destination=\"" + slo.toString() + "\"";
        }
        valueMap.put("destinationStr", destinationStr);
        String inResponseStr = "";
        if (this.inResponseTo != null) {
            inResponseStr = " InResponseTo=\"" + this.inResponseTo + "\"";
        }
        valueMap.put("inResponseStr", inResponseStr);
        valueMap.put("issuer", settings.getSpEntityId());
        return new StrSubstitutor(valueMap);
    }

    private static StringBuilder getLogoutResponseTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<samlp:LogoutResponse xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" ");
        template.append("ID=\"${id}\" ");
        template.append("Version=\"2.0\" ");
        template.append("IssueInstant=\"${issueInstant}\"${destinationStr}${inResponseStr} >");
        template.append("<saml:Issuer>${issuer}</saml:Issuer>");
        template.append("<samlp:Status>");
        template.append("<samlp:StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:Success\" />");
        template.append("</samlp:Status>");
        template.append("</samlp:LogoutResponse>");
        return template;
    }

    public String getError() {
        return this.error;
    }
}

