/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.cache;

import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.cache.CacheConfiguration;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class DefaultCacheConfiguration
implements CacheConfiguration {
    private final String name;
    private final Duration timeToLive;
    private final Duration timeToIdle;

    public DefaultCacheConfiguration(String name, Duration timeToLive, Duration timeToIdle) {
        Assert.hasText((String)name, (String)"Cache Region name cannot be null or empty.");
        this.name = name;
        this.timeToLive = timeToLive;
        this.timeToIdle = timeToIdle;
    }

    static Duration toDuration(long value, TimeUnit tu) {
        long timeInMillis = TimeUnit.MILLISECONDS.convert(value, tu);
        if (timeInMillis > 0L) {
            return Duration.ofMillis(timeInMillis);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Duration getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public Duration getTimeToIdle() {
        return this.timeToIdle;
    }

    public String toString() {
        return "DefaultCacheConfiguration{name='" + this.name + '\'' + ", timeToLive=" + this.timeToLive + ", timeToIdle=" + this.timeToIdle + '}';
    }
}

