/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.group;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.application.ApplicationList;
import com.okta.sdk.resource.group.Group;
import com.okta.sdk.resource.group.GroupProfile;
import com.okta.sdk.resource.group.GroupType;
import com.okta.sdk.resource.role.AssignRoleRequest;
import com.okta.sdk.resource.user.Role;
import com.okta.sdk.resource.user.UserList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultGroup
extends AbstractInstanceResource<Group>
implements Group {
    private static final MapProperty embeddedProperty = new MapProperty("_embedded");
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final DateProperty createdProperty = new DateProperty("created");
    private static final StringProperty idProperty = new StringProperty("id");
    private static final DateProperty lastMembershipUpdatedProperty = new DateProperty("lastMembershipUpdated");
    private static final DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private static final ListProperty objectClassProperty = new ListProperty("objectClass");
    private static final ResourceReference<GroupProfile> profileProperty = new ResourceReference<GroupProfile>("profile", GroupProfile.class, true);
    private static final EnumProperty<GroupType> typeProperty = new EnumProperty<GroupType>("type", GroupType.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultGroup.createPropertyDescriptorMap(embeddedProperty, linksProperty, createdProperty, idProperty, lastMembershipUpdatedProperty, lastUpdatedProperty, objectClassProperty, profileProperty, typeProperty);

    public DefaultGroup(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultGroup(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return Group.class;
    }

    public Map<String, Object> getEmbedded() {
        return this.getMap(embeddedProperty);
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public Date getCreated() {
        return this.getDateProperty(createdProperty);
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public Date getLastMembershipUpdated() {
        return this.getDateProperty(lastMembershipUpdatedProperty);
    }

    public Date getLastUpdated() {
        return this.getDateProperty(lastUpdatedProperty);
    }

    public List<String> getObjectClass() {
        return this.getListProperty(objectClassProperty);
    }

    public GroupProfile getProfile() {
        return this.getResourceProperty(profileProperty);
    }

    public Group setProfile(GroupProfile profile) {
        this.setProperty(profileProperty, (Object)profile);
        return this;
    }

    public GroupType getType() {
        return this.getEnumProperty(typeProperty);
    }

    public Role assignRole(AssignRoleRequest assignRoleRequest, String disableNotifications) {
        String groupId = this.getId();
        Assert.notNull((Object)assignRoleRequest, (String)"'assignRoleRequest' is required and cannot be null.");
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (disableNotifications != null) {
            queryArgs.put("disableNotifications", disableNotifications);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/groups/" + groupId + "/roles", assignRoleRequest, this, Role.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public Role assignRole(AssignRoleRequest assignRoleRequest) {
        String groupId = this.getId();
        Assert.notNull((Object)assignRoleRequest, (String)"'assignRoleRequest' is required and cannot be null.");
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/groups/" + groupId + "/roles", assignRoleRequest, this, Role.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public UserList listUsers() {
        String groupId = this.getId();
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/" + groupId + "/users", UserList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Group update() {
        String groupId = this.getId();
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/groups/" + groupId + "";
        this.getDataStore().save(href, this, null, queryArgs, (Map<String, List<String>>)headers);
        return this;
    }

    public void removeUser(String userId) {
        String groupId = this.getId();
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/groups/" + groupId + "/users/" + userId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public ApplicationList listApplications() {
        String groupId = this.getId();
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/" + groupId + "/apps", ApplicationList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    @Override
    public void delete() {
        String groupId = this.getId();
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/groups/" + groupId + "", this, queryArgs, (Map<String, List<String>>)headers);
    }
}

