/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.identity.provider;

import com.okta.sdk.resource.Deletable;
import com.okta.sdk.resource.ExtensibleResource;
import com.okta.sdk.resource.application.Csr;
import com.okta.sdk.resource.application.CsrList;
import com.okta.sdk.resource.application.CsrMetadata;
import com.okta.sdk.resource.application.JsonWebKey;
import com.okta.sdk.resource.application.JsonWebKeyList;
import com.okta.sdk.resource.identity.provider.IdentityProviderApplicationUser;
import com.okta.sdk.resource.identity.provider.IdentityProviderApplicationUserList;
import com.okta.sdk.resource.identity.provider.Protocol;
import com.okta.sdk.resource.identity.provider.SocialAuthTokenList;
import com.okta.sdk.resource.policy.IdentityProviderPolicy;
import com.okta.sdk.resource.policy.UserIdentityProviderLinkRequest;
import java.util.Date;
import java.util.Map;

public interface IdentityProvider
extends ExtensibleResource,
Deletable {
    public Map<String, Object> getLinks();

    public Date getCreated();

    public String getId();

    public IssuerModeEnum getIssuerMode();

    public IdentityProvider setIssuerMode(IssuerModeEnum var1);

    public Date getLastUpdated();

    public String getName();

    public IdentityProvider setName(String var1);

    public IdentityProviderPolicy getPolicy();

    public IdentityProvider setPolicy(IdentityProviderPolicy var1);

    public Protocol getProtocol();

    public IdentityProvider setProtocol(Protocol var1);

    public StatusEnum getStatus();

    public IdentityProvider setStatus(StatusEnum var1);

    public TypeEnum getType();

    public IdentityProvider setType(TypeEnum var1);

    public IdentityProviderApplicationUser getUser(String var1);

    public Csr getSigningCsr(String var1);

    @Override
    public void delete();

    public Csr generateCsr(CsrMetadata var1);

    public IdentityProvider activate();

    public IdentityProviderApplicationUser linkUser(String var1, UserIdentityProviderLinkRequest var2);

    public SocialAuthTokenList listSocialAuthTokens(String var1);

    public JsonWebKeyList listSigningKeys();

    public void deleteSigningCsr(String var1);

    public JsonWebKey getSigningKey(String var1);

    public IdentityProvider update(IdentityProvider var1);

    public JsonWebKey generateSigningKey(Integer var1);

    public IdentityProviderApplicationUserList listUsers();

    public void unlinkUser(String var1);

    public CsrList listSigningCsrs();

    public IdentityProvider deactivate();

    public JsonWebKey cloneKey(String var1, String var2);

    public static enum TypeEnum {
        SAML2("SAML2"),
        GOOGLE("GOOGLE"),
        FACEBOOK("FACEBOOK"),
        LINKEDIN("LINKEDIN"),
        MICROSOFT("MICROSOFT"),
        OIDC("OIDC"),
        OKTA("OKTA"),
        IWA("IWA"),
        AGENTLESSDSSO("AgentlessDSSO"),
        X509("X509");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        INACTIVE("INACTIVE");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum IssuerModeEnum {
        ORG_URL("ORG_URL"),
        CUSTOM_URL_DOMAIN("CUSTOM_URL_DOMAIN");

        private String value;

        private IssuerModeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

