/*
 * Decompiled with CFR 0.152.
 */
package com.okta.maven.snippet;

import com.github.javaparser.JavaParser;
import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="snip", defaultPhase=LifecyclePhase.PROCESS_SOURCES, aggregator=true)
public class CodeSnippetMojo
extends AbstractMojo {
    @Parameter(property="markdownFile", defaultValue="${project.basedir}/README.md")
    private File markdownFile = null;
    @Parameter(property="sourceFile", defaultValue="${sourceDirectory}/Examples.java")
    private File sourceFile = null;

    public void execute() throws MojoExecutionException {
        try {
            if (!this.markdownFile.exists()) {
                throw new MojoExecutionException("The 'markdownFile' is required and must exist.");
            }
            if (!this.sourceFile.exists()) {
                throw new MojoExecutionException("The 'sourceFile' is required and must exist.");
            }
            Map<String, String> methodBodyMap = CodeSnippetMojo.listMethodBodies(this.sourceFile);
            Path markdownFilePath = this.markdownFile.toPath();
            String langTag = FileUtils.extension((String)this.sourceFile.getName());
            String contents = IOUtil.toString((byte[])Files.readAllBytes(markdownFilePath), (String)StandardCharsets.UTF_8.name());
            String result = this.replaceSnippets(contents, langTag, methodBodyMap);
            FileUtils.fileWrite((File)this.markdownFile, (String)result);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed generate report", (Exception)e);
        }
    }

    private static Map<String, String> listMethodBodies(File sourceFile) throws FileNotFoundException {
        final HashMap<String, String> methodBodyMap = new HashMap<String, String>();
        new VoidVisitorAdapter<Object>(){

            public void visit(MethodDeclaration method, Object arg) {
                super.visit(method, arg);
                String body = ((BlockStmt)method.getBody().get()).getStatements().stream().map(statement -> {
                    TokenRange tokenRange = (TokenRange)statement.getTokenRange().get();
                    Optional comment = statement.getComment();
                    StringBuilder blockAsString = new StringBuilder();
                    if (comment.isPresent()) {
                        blockAsString.append("\n").append(comment.get());
                    }
                    blockAsString.append(tokenRange.toString().replaceAll(" {8}", ""));
                    return blockAsString;
                }).collect(Collectors.joining("\n"));
                body = StringUtils.strip((String)body, (String)"\n");
                methodBodyMap.put(method.getNameAsString(), body);
            }
        }.visit(JavaParser.parse((File)sourceFile), null);
        return methodBodyMap;
    }

    private String replaceSnippets(String fileContents, String langTag, Map<String, String> methodBodyMap) {
        for (Map.Entry<String, String> entry : methodBodyMap.entrySet()) {
            String startText = "[//]: # (method: " + entry.getKey() + ")";
            String endText = "[//]: # (end: " + entry.getKey() + ")";
            Pattern startPattern = Pattern.compile(Pattern.quote(startText) + "(.*)" + Pattern.quote(endText), 40);
            Matcher matcher = startPattern.matcher(fileContents);
            StringBuffer stringBuffer = new StringBuffer();
            if (matcher.find()) {
                String text = startText + "\n```" + langTag + "\n" + entry.getValue() + "\n```\n" + endText;
                matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(text));
            }
            matcher.appendTail(stringBuffer);
            fileContents = stringBuffer.toString();
        }
        return fileContents;
    }

    CodeSnippetMojo setMarkdownFile(File markdownFile) {
        this.markdownFile = markdownFile;
        return this;
    }

    CodeSnippetMojo setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
        return this;
    }
}

