/*
 * Decompiled with CFR 0.152.
 */
package com.okta.idx.sdk.api.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.okta.commons.lang.Assert;
import com.okta.idx.sdk.api.client.IDXClient;
import com.okta.idx.sdk.api.exception.ProcessingException;
import com.okta.idx.sdk.api.model.FormValue;
import com.okta.idx.sdk.api.model.IDXClientContext;
import com.okta.idx.sdk.api.response.TokenResponse;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class SuccessResponse
implements Serializable {
    private static final long serialVersionUID = -618863469033853075L;
    private String[] rel;
    private String name;
    private String method;
    private String href;
    private List<FormValue> value;
    private String accepts;

    public String[] getRel() {
        return Arrays.copyOf(this.rel, this.rel.length);
    }

    public String getName() {
        return this.name;
    }

    public String getMethod() {
        return this.method;
    }

    public String getHref() {
        return this.href;
    }

    public List<FormValue> getValue() {
        return this.value;
    }

    public List<FormValue> formValues() {
        return this.getValue();
    }

    public String getAccepts() {
        return this.accepts;
    }

    public List<FormValue> form() {
        return this.getValue();
    }

    private String parseGrantType() {
        Optional<FormValue> grantTypeForm = this.value.stream().filter(x -> "grant_type".equals(x.getName())).findAny();
        Assert.isTrue((boolean)grantTypeForm.isPresent());
        return String.valueOf(grantTypeForm.get().getValue());
    }

    private String parseInteractionCode() {
        String interactionCodeLookupKey = this.parseGrantType();
        Optional<FormValue> interactionCodeForm = this.value.stream().filter(x -> interactionCodeLookupKey.equals(x.getName())).findAny();
        Assert.isTrue((boolean)interactionCodeForm.isPresent());
        return String.valueOf(interactionCodeForm.get().getValue());
    }

    public TokenResponse exchangeCode(IDXClient client, IDXClientContext idxClientContext) throws ProcessingException {
        String grantType = this.parseGrantType();
        String interactionCode = this.parseInteractionCode();
        String tokenUrl = this.getHref();
        return client.token(tokenUrl, grantType, interactionCode, idxClientContext);
    }
}

