/*
 * Decompiled with CFR 0.152.
 */
package com.okta.idx.sdk.api.config;

import com.okta.commons.lang.Collections;
import com.okta.idx.sdk.api.config.DefaultEnvVarNameConverter;
import com.okta.idx.sdk.api.config.EnvVarNameConverter;
import com.okta.idx.sdk.api.config.FilteredPropertiesSource;
import com.okta.idx.sdk.api.config.PropertiesSource;
import java.util.LinkedHashMap;
import java.util.Map;

public class EnvironmentVariablesPropertiesSource
implements PropertiesSource {
    @Override
    public Map<String, String> getProperties() {
        Map<String, String> envVars = System.getenv();
        if (!Collections.isEmpty(envVars)) {
            return new LinkedHashMap<String, String>(envVars);
        }
        return java.util.Collections.emptyMap();
    }

    public static PropertiesSource oktaFilteredPropertiesSource() {
        return new OktaFilteredEnvironmentPropertiesSource();
    }

    private static class OktaFilteredEnvironmentPropertiesSource
    extends FilteredPropertiesSource {
        private static final EnvVarNameConverter envVarNameConverter = new DefaultEnvVarNameConverter();

        private OktaFilteredEnvironmentPropertiesSource() {
            super(new EnvironmentVariablesPropertiesSource(), (key, value) -> {
                if (key.startsWith("OKTA_")) {
                    key = envVarNameConverter.toDottedPropertyName(key);
                    return new String[]{key, value};
                }
                return null;
            });
        }
    }
}

