/*
 * Decompiled with CFR 0.152.
 */
package com.okta.idx.sdk.api.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.commons.http.DefaultRequest;
import com.okta.commons.http.HttpException;
import com.okta.commons.http.HttpHeaders;
import com.okta.commons.http.HttpMethod;
import com.okta.commons.http.Request;
import com.okta.commons.http.RequestExecutor;
import com.okta.commons.http.RequestExecutorFactory;
import com.okta.commons.http.Response;
import com.okta.commons.http.authc.DisabledAuthenticator;
import com.okta.commons.http.authc.RequestAuthenticator;
import com.okta.commons.http.config.HttpClientConfiguration;
import com.okta.commons.lang.ApplicationInfo;
import com.okta.commons.lang.Assert;
import com.okta.commons.lang.Classes;
import com.okta.commons.lang.Strings;
import com.okta.idx.sdk.api.client.IDXClient;
import com.okta.idx.sdk.api.config.ClientConfiguration;
import com.okta.idx.sdk.api.exception.ProcessingException;
import com.okta.idx.sdk.api.model.EmailTokenType;
import com.okta.idx.sdk.api.model.FormValue;
import com.okta.idx.sdk.api.model.IDXClientContext;
import com.okta.idx.sdk.api.model.RemediationOption;
import com.okta.idx.sdk.api.model.RequestContext;
import com.okta.idx.sdk.api.request.AnswerChallengeRequest;
import com.okta.idx.sdk.api.request.CancelRequest;
import com.okta.idx.sdk.api.request.CancelRequestBuilder;
import com.okta.idx.sdk.api.request.ChallengeRequest;
import com.okta.idx.sdk.api.request.EnrollRequest;
import com.okta.idx.sdk.api.request.EnrollUserProfileUpdateRequest;
import com.okta.idx.sdk.api.request.IdentifyRequest;
import com.okta.idx.sdk.api.request.IntrospectRequest;
import com.okta.idx.sdk.api.request.PollRequest;
import com.okta.idx.sdk.api.request.RecoverRequest;
import com.okta.idx.sdk.api.request.SkipAuthenticatorEnrollmentRequest;
import com.okta.idx.sdk.api.response.ErrorResponse;
import com.okta.idx.sdk.api.response.IDXResponse;
import com.okta.idx.sdk.api.response.InteractResponse;
import com.okta.idx.sdk.api.response.TokenResponse;
import com.okta.idx.sdk.api.util.ClientUtil;
import com.okta.idx.sdk.api.util.PkceUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import java.util.stream.Collectors;

final class BaseIDXClient
implements IDXClient {
    private final ClientConfiguration clientConfiguration;
    private final ObjectMapper objectMapper;
    private final RequestExecutor requestExecutor;

    public BaseIDXClient(ClientConfiguration clientConfiguration, RequestExecutor requestExecutor) {
        this.clientConfiguration = clientConfiguration;
        this.objectMapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new JavaTimeModule()).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        HttpClientConfiguration httpClientConfiguration = new HttpClientConfiguration();
        httpClientConfiguration.setBaseUrl(clientConfiguration.getBaseUrl());
        httpClientConfiguration.setRequestAuthenticator((RequestAuthenticator)new DisabledAuthenticator());
        if (requestExecutor != null) {
            this.requestExecutor = requestExecutor;
        } else {
            String msg = "Unable to find a '" + RequestExecutorFactory.class.getName() + "' implementation on the classpath.";
            this.requestExecutor = ((RequestExecutorFactory)Classes.loadFromService(RequestExecutorFactory.class, (String)msg)).create(httpClientConfiguration);
        }
    }

    @Override
    public IDXClientContext interact() throws ProcessingException {
        return this.interact(null, null, null);
    }

    @Override
    public IDXClientContext interact(String token, EmailTokenType tokenType, RequestContext requestContext) throws ProcessingException {
        InteractResponse interactResponse;
        String state;
        String codeChallenge;
        String codeVerifier;
        try {
            DefaultRequest request;
            Response response;
            codeVerifier = PkceUtil.generateCodeVerifier();
            codeChallenge = PkceUtil.generateCodeChallenge(codeVerifier);
            state = UUID.randomUUID().toString();
            StringBuilder urlParameters = new StringBuilder().append("client_id=").append(this.clientConfiguration.getClientId()).append("&client_secret=").append(this.clientConfiguration.getClientSecret()).append("&scope=").append(this.clientConfiguration.getScopes().stream().map(Object::toString).collect(Collectors.joining(" "))).append("&code_challenge=").append(codeChallenge).append("&code_challenge_method=").append("S256").append("&redirect_uri=").append(this.clientConfiguration.getRedirectUri()).append("&state=").append(state);
            if (Strings.hasText((String)token) && !Strings.isEmpty((Object)((Object)tokenType))) {
                if (tokenType == EmailTokenType.ACTIVATION_TOKEN) {
                    urlParameters.append("&activation_token=").append(token);
                } else if (tokenType == EmailTokenType.RECOVERY_TOKEN) {
                    urlParameters.append("&recovery_token=").append(token);
                }
            }
            HttpHeaders httpHeaders = this.getHttpHeaders(true);
            if (requestContext != null) {
                if (Strings.hasText((String)requestContext.getUserAgent())) {
                    httpHeaders.set("X-Okta-User-Agent-Extended", requestContext.getUserAgent());
                }
                if (Strings.hasText((String)this.clientConfiguration.getClientSecret())) {
                    if (Strings.hasText((String)requestContext.getDeviceToken())) {
                        httpHeaders.set("X-Device-Token", requestContext.getDeviceToken());
                    }
                    if (Strings.hasText((String)requestContext.getIpAddress())) {
                        httpHeaders.set("X-Forwarded-For", requestContext.getIpAddress());
                    }
                }
            }
            if ((response = this.requestExecutor.executeRequest((Request)(request = new DefaultRequest(HttpMethod.POST, ClientUtil.normalizedIssuerUri(this.clientConfiguration.getIssuer(), "/v1/interact"), null, httpHeaders, (InputStream)new ByteArrayInputStream(urlParameters.toString().getBytes(StandardCharsets.UTF_8)), -1L)))).getHttpStatus() != 200) {
                this.handleErrorResponse((Request)request, response);
            }
            JsonNode responseJsonNode = this.objectMapper.readTree(response.getBody());
            interactResponse = (InteractResponse)this.objectMapper.convertValue((Object)responseJsonNode, InteractResponse.class);
            Assert.notNull((Object)interactResponse, (String)"interact response cannot be null");
            Assert.notNull((Object)interactResponse.getInteractionHandle(), (String)"interactionHandle cannot be null");
        }
        catch (HttpException | IOException | IllegalArgumentException | NoSuchAlgorithmException e) {
            throw new ProcessingException(e);
        }
        return new IDXClientContext(codeVerifier, codeChallenge, interactResponse.getInteractionHandle(), state);
    }

    @Override
    public IDXResponse introspect(IDXClientContext idxClientContext) throws ProcessingException {
        IDXResponse idxResponse;
        IntrospectRequest introspectRequest = new IntrospectRequest(idxClientContext.getInteractionHandle());
        try {
            DefaultRequest request = new DefaultRequest(HttpMethod.POST, this.clientConfiguration.getBaseUrl() + "/idp/idx/introspect", null, this.getHttpHeaders(false), (InputStream)new ByteArrayInputStream(this.objectMapper.writeValueAsBytes((Object)introspectRequest)), -1L);
            Response response = this.requestExecutor.executeRequest((Request)request);
            if (response.getHttpStatus() != 200) {
                this.handleErrorResponse((Request)request, response);
            }
            JsonNode responseJsonNode = this.objectMapper.readTree(response.getBody());
            idxResponse = (IDXResponse)this.objectMapper.convertValue((Object)responseJsonNode, IDXResponse.class);
        }
        catch (HttpException | IOException e) {
            throw new ProcessingException(e);
        }
        return idxResponse;
    }

    @Override
    public IDXResponse identify(IdentifyRequest identifyRequest, String href) throws ProcessingException {
        IDXResponse idxResponse;
        try {
            DefaultRequest request = new DefaultRequest(HttpMethod.POST, href, null, this.getHttpHeaders(false), (InputStream)new ByteArrayInputStream(this.objectMapper.writeValueAsBytes((Object)identifyRequest)), -1L);
            Response response = this.requestExecutor.executeRequest((Request)request);
            if (response.getHttpStatus() != 200) {
                this.handleErrorResponse((Request)request, response);
            }
            JsonNode responseJsonNode = this.objectMapper.readTree(response.getBody());
            idxResponse = (IDXResponse)this.objectMapper.convertValue((Object)responseJsonNode, IDXResponse.class);
        }
        catch (HttpException | IOException e) {
            throw new ProcessingException(e);
        }
        return idxResponse;
    }

    @Override
    public IDXResponse enroll(EnrollRequest enrollRequest, String href) throws ProcessingException {
        IDXResponse idxResponse;
        Assert.notNull((Object)href, (String)"href cannot be null");
        try {
            DefaultRequest request = new DefaultRequest(HttpMethod.POST, href, null, this.getHttpHeaders(false), (InputStream)new ByteArrayInputStream(this.objectMapper.writeValueAsBytes((Object)enrollRequest)), -1L);
            Response response = this.requestExecutor.executeRequest((Request)request);
            if (response.getHttpStatus() != 200) {
                this.handleErrorResponse((Request)request, response);
            }
            JsonNode responseJsonNode = this.objectMapper.readTree(response.getBody());
            idxResponse = (IDXResponse)this.objectMapper.convertValue((Object)responseJsonNode, IDXResponse.class);
        }
        catch (HttpException | IOException e) {
            throw new ProcessingException(e);
        }
        return idxResponse;
    }

    @Override
    public IDXResponse challenge(ChallengeRequest challengeRequest, String href) throws ProcessingException {
        IDXResponse idxResponse;
        try {
            DefaultRequest request = new DefaultRequest(HttpMethod.POST, href, null, this.getHttpHeaders(false), (InputStream)new ByteArrayInputStream(this.objectMapper.writeValueAsBytes((Object)challengeRequest)), -1L);
            Response response = this.requestExecutor.executeRequest((Request)request);
            if (response.getHttpStatus() != 200) {
                this.handleErrorResponse((Request)request, response);
            }
            JsonNode responseJsonNode = this.objectMapper.readTree(response.getBody());
            idxResponse = (IDXResponse)this.objectMapper.convertValue((Object)responseJsonNode, IDXResponse.class);
        }
        catch (HttpException | IOException e) {
            throw new ProcessingException(e);
        }
        return idxResponse;
    }

    @Override
    public IDXResponse answerChallenge(AnswerChallengeRequest answerChallengeRequest, String href) throws ProcessingException {
        IDXResponse idxResponse;
        try {
            DefaultRequest request = new DefaultRequest(HttpMethod.POST, href, null, this.getHttpHeaders(false), (InputStream)new ByteArrayInputStream(this.objectMapper.writeValueAsBytes((Object)answerChallengeRequest)), -1L);
            Response response = this.requestExecutor.executeRequest((Request)request);
            if (response.getHttpStatus() != 200) {
                this.handleErrorResponse((Request)request, response);
            }
            JsonNode responseJsonNode = this.objectMapper.readTree(response.getBody());
            idxResponse = (IDXResponse)this.objectMapper.convertValue((Object)responseJsonNode, IDXResponse.class);
        }
        catch (HttpException | IOException e) {
            throw new ProcessingException(e);
        }
        return idxResponse;
    }

    @Override
    public IDXResponse cancel(String stateHandle) throws ProcessingException {
        IDXResponse idxResponse;
        CancelRequest cancelRequest = CancelRequestBuilder.builder().withStateHandle(stateHandle).build();
        try {
            DefaultRequest request = new DefaultRequest(HttpMethod.POST, this.clientConfiguration.getBaseUrl() + "/idp/idx/cancel", null, this.getHttpHeaders(false), (InputStream)new ByteArrayInputStream(this.objectMapper.writeValueAsBytes((Object)cancelRequest)), -1L);
            Response response = this.requestExecutor.executeRequest((Request)request);
            if (response.getHttpStatus() != 200) {
                this.handleErrorResponse((Request)request, response);
            }
            JsonNode responseJsonNode = this.objectMapper.readTree(response.getBody());
            idxResponse = (IDXResponse)this.objectMapper.convertValue((Object)responseJsonNode, IDXResponse.class);
        }
        catch (HttpException | IOException e) {
            throw new ProcessingException(e);
        }
        return idxResponse;
    }

    @Override
    public IDXResponse enrollUpdateUserProfile(EnrollUserProfileUpdateRequest enrollUserProfileUpdateRequest, String href) throws ProcessingException {
        IDXResponse idxResponse;
        try {
            DefaultRequest request = new DefaultRequest(HttpMethod.POST, href, null, this.getHttpHeaders(false), (InputStream)new ByteArrayInputStream(this.objectMapper.writeValueAsBytes((Object)enrollUserProfileUpdateRequest)), -1L);
            Response response = this.requestExecutor.executeRequest((Request)request);
            if (response.getHttpStatus() != 200) {
                this.handleErrorResponse((Request)request, response);
            }
            JsonNode responseJsonNode = this.objectMapper.readTree(response.getBody());
            idxResponse = (IDXResponse)this.objectMapper.convertValue((Object)responseJsonNode, IDXResponse.class);
        }
        catch (HttpException | IOException e) {
            throw new ProcessingException(e);
        }
        return idxResponse;
    }

    @Override
    public IDXResponse skip(SkipAuthenticatorEnrollmentRequest skipAuthenticatorEnrollmentRequest, String href) throws ProcessingException {
        IDXResponse idxResponse;
        try {
            DefaultRequest request = new DefaultRequest(HttpMethod.POST, href, null, this.getHttpHeaders(false), (InputStream)new ByteArrayInputStream(this.objectMapper.writeValueAsBytes((Object)skipAuthenticatorEnrollmentRequest)), -1L);
            Response response = this.requestExecutor.executeRequest((Request)request);
            if (response.getHttpStatus() != 200) {
                this.handleErrorResponse((Request)request, response);
            }
            JsonNode responseJsonNode = this.objectMapper.readTree(response.getBody());
            idxResponse = (IDXResponse)this.objectMapper.convertValue((Object)responseJsonNode, IDXResponse.class);
        }
        catch (HttpException | IOException e) {
            throw new ProcessingException(e);
        }
        return idxResponse;
    }

    @Override
    public IDXResponse recover(RecoverRequest recoverRequest, String href) throws ProcessingException {
        IDXResponse idxResponse;
        try {
            DefaultRequest request = new DefaultRequest(HttpMethod.POST, Strings.hasText((String)href) ? href : this.clientConfiguration.getBaseUrl() + "/idp/idx/recover", null, this.getHttpHeaders(false), (InputStream)new ByteArrayInputStream(this.objectMapper.writeValueAsBytes((Object)recoverRequest)), -1L);
            Response response = this.requestExecutor.executeRequest((Request)request);
            if (response.getHttpStatus() != 200) {
                this.handleErrorResponse((Request)request, response);
            }
            JsonNode responseJsonNode = this.objectMapper.readTree(response.getBody());
            idxResponse = (IDXResponse)this.objectMapper.convertValue((Object)responseJsonNode, IDXResponse.class);
        }
        catch (HttpException | IOException e) {
            throw new ProcessingException(e);
        }
        return idxResponse;
    }

    @Override
    public IDXResponse poll(PollRequest pollRequest, String href) throws ProcessingException {
        IDXResponse idxResponse;
        try {
            DefaultRequest request = new DefaultRequest(HttpMethod.POST, Strings.hasText((String)href) ? href : this.clientConfiguration.getBaseUrl() + "/idp/idx/challenge/poll", null, this.getHttpHeaders(false), (InputStream)new ByteArrayInputStream(this.objectMapper.writeValueAsBytes((Object)pollRequest)), -1L);
            Response response = this.requestExecutor.executeRequest((Request)request);
            if (response.getHttpStatus() != 200) {
                this.handleErrorResponse((Request)request, response);
            }
            JsonNode responseJsonNode = this.objectMapper.readTree(response.getBody());
            idxResponse = (IDXResponse)this.objectMapper.convertValue((Object)responseJsonNode, IDXResponse.class);
        }
        catch (HttpException | IOException e) {
            throw new ProcessingException(e);
        }
        return idxResponse;
    }

    @Override
    public TokenResponse token(String grantType, String interactionCode, IDXClientContext idxClientContext) throws ProcessingException {
        String tokenUrl = ClientUtil.normalizedIssuerUri(this.clientConfiguration.getIssuer(), "/v1/token");
        return this.token(tokenUrl, grantType, interactionCode, idxClientContext);
    }

    @Override
    public TokenResponse token(String url, String grantType, String interactionCode, IDXClientContext idxClientContext) throws ProcessingException {
        TokenResponse tokenResponse;
        StringBuilder urlParameters = new StringBuilder();
        urlParameters.append("grant_type=").append(grantType);
        urlParameters.append("&client_id=").append(this.clientConfiguration.getClientId());
        if (Strings.hasText((String)this.clientConfiguration.getClientSecret())) {
            urlParameters.append("&client_secret=").append(this.clientConfiguration.getClientSecret());
        }
        urlParameters.append("&interaction_code=").append(interactionCode);
        urlParameters.append("&code_verifier=").append(idxClientContext.getCodeVerifier());
        try {
            DefaultRequest request = new DefaultRequest(HttpMethod.POST, url, null, this.getHttpHeaders(true), (InputStream)new ByteArrayInputStream(urlParameters.toString().getBytes(StandardCharsets.UTF_8)), -1L);
            Response response = this.requestExecutor.executeRequest((Request)request);
            if (response.getHttpStatus() != 200) {
                this.handleErrorResponse((Request)request, response);
            }
            JsonNode responseJsonNode = this.objectMapper.readTree(response.getBody());
            tokenResponse = (TokenResponse)this.objectMapper.convertValue((Object)responseJsonNode, TokenResponse.class);
        }
        catch (HttpException | IOException e) {
            throw new ProcessingException(e);
        }
        return tokenResponse;
    }

    @Override
    public void revokeToken(String tokenType, String token) throws ProcessingException {
        StringBuilder urlParameters = new StringBuilder();
        urlParameters.append("client_id=").append(this.clientConfiguration.getClientId());
        if (Strings.hasText((String)this.clientConfiguration.getClientSecret())) {
            urlParameters.append("&client_secret=").append(this.clientConfiguration.getClientSecret());
        }
        urlParameters.append("&token_type_hint=").append(tokenType);
        urlParameters.append("&token=").append(token);
        try {
            DefaultRequest request = new DefaultRequest(HttpMethod.POST, ClientUtil.normalizedIssuerUri(this.clientConfiguration.getIssuer(), "/v1/revoke"), null, this.getHttpHeaders(true), (InputStream)new ByteArrayInputStream(urlParameters.toString().getBytes(StandardCharsets.UTF_8)), -1L);
            this.requestExecutor.executeRequest((Request)request);
        }
        catch (HttpException e) {
            throw new ProcessingException(e);
        }
    }

    @Override
    public Response verifyEmailToken(String token) throws ProcessingException {
        StringBuilder urlParameter = new StringBuilder();
        urlParameter.append("token=").append(token);
        try {
            DefaultRequest request = new DefaultRequest(HttpMethod.GET, this.clientConfiguration.getBaseUrl() + "/email/verify", null, this.getHttpHeaders(false), (InputStream)new ByteArrayInputStream(urlParameter.toString().getBytes(StandardCharsets.UTF_8)), -1L);
            return this.requestExecutor.executeRequest((Request)request);
        }
        catch (HttpException e) {
            throw new ProcessingException(e);
        }
    }

    private void handleErrorResponse(Request request, Response response) throws IOException, ProcessingException {
        int httpStatus = response.getHttpStatus();
        String errorMsg = "Request to " + request.getResourceUrl() + " failed.";
        if (response.getHeaders().getContentType() != null && (response.getHeaders().getContentType().toString().contains("application/json") || response.getHeaders().getContentType().toString().contains("application/ion+json"))) {
            JsonNode errorResponseJson = this.objectMapper.readTree(response.getBody());
            ErrorResponse errorResponseDetails = (ErrorResponse)this.objectMapper.convertValue((Object)errorResponseJson, ErrorResponse.class);
            if (errorResponseDetails.getError() == null && errorResponseDetails.getMessages() == null) {
                this.getErrorsFromRemediationOptions(errorResponseDetails, errorResponseJson);
            }
            throw new ProcessingException(httpStatus, errorMsg, errorResponseDetails);
        }
        throw new ProcessingException(httpStatus, errorMsg);
    }

    private void getErrorsFromRemediationOptions(ErrorResponse errorResponseDetails, JsonNode errorResponseJson) {
        IDXResponse idxResponse = (IDXResponse)this.objectMapper.convertValue((Object)errorResponseJson, IDXResponse.class);
        if (idxResponse != null && idxResponse.remediation() != null) {
            for (RemediationOption remediationOption : idxResponse.remediation().remediationOptions()) {
                if (remediationOption == null) continue;
                for (FormValue formValue : remediationOption.form()) {
                    if (formValue == null || formValue.form() == null) continue;
                    for (FormValue messageFormValue : formValue.form().getValue()) {
                        if (messageFormValue.messages == null) continue;
                        errorResponseDetails.setMessages(messageFormValue.messages);
                        return;
                    }
                }
            }
        }
    }

    private HttpHeaders getHttpHeaders(boolean isOAuth2Endpoint) {
        HttpHeaders httpHeaders = new HttpHeaders();
        if (isOAuth2Endpoint) {
            httpHeaders.add("Content-Type", "application/x-www-form-urlencoded");
            httpHeaders.add("Accept", "application/json");
        } else {
            httpHeaders.add("Content-Type", "application/ion+json; okta-version=1.0.0");
            httpHeaders.add("Accept", "application/ion+json; okta-version=1.0.0");
        }
        String userAgentValue = ApplicationInfo.get().entrySet().stream().map(entry -> (String)entry.getKey() + "/" + (String)entry.getValue()).collect(Collectors.joining(" "));
        httpHeaders.add("User-Agent", userAgentValue);
        httpHeaders.add("Connection", "close");
        return httpHeaders;
    }
}

