/*
 * Decompiled with CFR 0.152.
 */
package com.ogaclejapan.smarttablayout.utils;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.collection.SparseArrayCompat;
import androidx.viewpager.widget.PagerAdapter;
import com.ogaclejapan.smarttablayout.utils.ViewPagerItem;
import com.ogaclejapan.smarttablayout.utils.ViewPagerItems;
import java.lang.ref.WeakReference;

public class ViewPagerItemAdapter
extends PagerAdapter {
    private final ViewPagerItems pages;
    private final SparseArrayCompat<WeakReference<View>> holder;
    private final LayoutInflater inflater;

    public ViewPagerItemAdapter(ViewPagerItems pages) {
        this.pages = pages;
        this.holder = new SparseArrayCompat(pages.size());
        this.inflater = LayoutInflater.from((Context)pages.getContext());
    }

    public int getCount() {
        return this.pages.size();
    }

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        View view = this.getPagerItem(position).initiate(this.inflater, container);
        container.addView(view);
        this.holder.put(position, new WeakReference<View>(view));
        return view;
    }

    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        this.holder.remove(position);
        container.removeView((View)object);
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return object == view;
    }

    public CharSequence getPageTitle(int position) {
        return this.getPagerItem(position).getTitle();
    }

    public float getPageWidth(int position) {
        return this.getPagerItem(position).getWidth();
    }

    public View getPage(int position) {
        WeakReference weakRefItem = (WeakReference)this.holder.get(position);
        return weakRefItem != null ? (View)weakRefItem.get() : null;
    }

    protected ViewPagerItem getPagerItem(int position) {
        return (ViewPagerItem)this.pages.get(position);
    }
}

