/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.persistence.springandroid.xml;

import android.app.Application;
import com.octo.android.robospice.persistence.exception.CacheCreationException;
import com.octo.android.robospice.persistence.exception.CacheLoadingException;
import com.octo.android.robospice.persistence.exception.CacheSavingException;
import com.octo.android.robospice.persistence.springandroid.SpringAndroidObjectPersister;
import java.io.File;
import java.io.IOException;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.core.Persister;

public final class SimpleSerializerObjectPersister<T>
extends SpringAndroidObjectPersister<T> {
    private Serializer serializer = new Persister();

    public SimpleSerializerObjectPersister(Application application, Class<T> clazz, File cacheFolder) throws CacheCreationException {
        super(application, clazz, cacheFolder);
    }

    public SimpleSerializerObjectPersister(Application application, Class<T> clazz) throws CacheCreationException {
        this(application, clazz, null);
    }

    @Override
    protected T deserializeData(String xml) throws CacheLoadingException {
        try {
            return (T)this.serializer.read(this.getHandledClass(), xml);
        }
        catch (Exception e) {
            throw new CacheLoadingException((Throwable)e);
        }
    }

    @Override
    protected void saveData(T data, Object cacheKey) throws IOException, CacheSavingException {
        try {
            this.serializer.write(data, this.getCacheFile(cacheKey));
        }
        catch (Exception e) {
            throw new CacheSavingException("Data was null and could not be serialized in xml");
        }
    }
}

