/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.persistence.springandroid.json.jackson2;

import android.app.Application;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.octo.android.robospice.persistence.exception.CacheCreationException;
import com.octo.android.robospice.persistence.exception.CacheLoadingException;
import com.octo.android.robospice.persistence.exception.CacheSavingException;
import com.octo.android.robospice.persistence.springandroid.SpringAndroidObjectPersister;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public final class Jackson2ObjectPersister<T>
extends SpringAndroidObjectPersister<T> {
    private final ObjectMapper mJsonMapper = new ObjectMapper();

    public Jackson2ObjectPersister(Application application, Class<T> clazz, File cacheFolder) throws CacheCreationException {
        super(application, clazz, cacheFolder);
    }

    public Jackson2ObjectPersister(Application application, Class<T> clazz) throws CacheCreationException {
        this(application, clazz, null);
    }

    @Override
    protected T deserializeData(String json) throws CacheLoadingException {
        try {
            return (T)this.mJsonMapper.readValue(json, this.getHandledClass());
        }
        catch (Exception e) {
            throw new CacheLoadingException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveData(T data, Object cacheKey) throws IOException, CacheSavingException {
        String resultJson = this.mJsonMapper.writeValueAsString(data);
        String string = this.getCacheFile(cacheKey).getAbsolutePath().intern();
        synchronized (string) {
            if (StringUtils.isEmpty((CharSequence)resultJson)) {
                throw new CacheSavingException("Data was null and could not be serialized in json");
            }
            FileUtils.writeStringToFile((File)this.getCacheFile(cacheKey), (String)resultJson, (String)"UTF-8");
        }
    }
}

