/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.persistence.springandroid.json.gson;

import android.app.Application;
import com.google.gson.Gson;
import com.octo.android.robospice.persistence.exception.CacheCreationException;
import com.octo.android.robospice.persistence.exception.CacheSavingException;
import com.octo.android.robospice.persistence.springandroid.SpringAndroidObjectPersister;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public final class GsonObjectPersister<T>
extends SpringAndroidObjectPersister<T> {
    private final Gson gson = new Gson();

    public GsonObjectPersister(Application application, Class<T> clazz, File cacheFolder) throws CacheCreationException {
        super(application, clazz, cacheFolder);
    }

    public GsonObjectPersister(Application application, Class<T> clazz) throws CacheCreationException {
        this(application, clazz, null);
    }

    @Override
    protected T deserializeData(String json) {
        return (T)this.gson.fromJson(json, this.getHandledClass());
    }

    @Override
    protected void saveData(T data, Object cacheKey) throws IOException, CacheSavingException {
        String resultJson = this.gson.toJson(data);
        if (StringUtils.isEmpty((CharSequence)resultJson)) {
            throw new CacheSavingException("Data was null and could not be serialized in json");
        }
        FileUtils.writeStringToFile((File)this.getCacheFile(cacheKey), (String)resultJson, (String)"UTF-8");
    }
}

