/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.el;

import com.ocpsoft.pretty.faces.spi.ELBeanNameResolver;
import com.ocpsoft.pretty.faces.util.ServiceLoader;
import com.ocpsoft.shade.org.apache.commons.logging.Log;
import com.ocpsoft.shade.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyBeanNameFinder {
    private static final Log log = LogFactory.getLog(LazyBeanNameFinder.class);
    private final List<ELBeanNameResolver> resolvers = new ArrayList<ELBeanNameResolver>();

    public LazyBeanNameFinder(ServletContext servletContext) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        for (ELBeanNameResolver resolver : ServiceLoader.load(ELBeanNameResolver.class)) {
            if (log.isTraceEnabled()) {
                log.trace("Initializing BeanNameResolver: " + resolver.getClass().getName());
            }
            try {
                boolean initialized = resolver.init(servletContext, classLoader);
                if (!initialized) continue;
                this.resolvers.add(resolver);
            }
            catch (ClassFormatError e) {
                log.warn("Failed to initialize " + resolver.getClass().getSimpleName() + ": " + e.getMessage());
            }
        }
    }

    public String findBeanName(Class<?> clazz) throws IllegalStateException {
        for (ELBeanNameResolver resolver : this.resolvers) {
            String name = resolver.getBeanName(clazz);
            if (name == null) continue;
            return name;
        }
        throw new IllegalStateException("Cannot find name of bean '" + clazz.getName() + "'! You should place a @URLBeanName annotation on this class to let PrettyFaces know its name.");
    }
}

