/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.util;

import com.ocpsoft.pretty.faces.config.mapping.QueryParameter;
import com.ocpsoft.pretty.faces.config.mapping.RequestParameter;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.url.QueryString;
import com.ocpsoft.pretty.faces.url.URL;
import com.ocpsoft.pretty.faces.url.URLPatternParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyURLBuilder {
    public List<UIParameter> extractParameters(UIComponent component) {
        ArrayList<UIParameter> results = new ArrayList<UIParameter>();
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            results.add((UIParameter)child);
        }
        return results;
    }

    @Deprecated
    public String build(UrlMapping mapping, Map<String, String[]> parameters) {
        return this.build(mapping, false, parameters);
    }

    public String build(UrlMapping mapping, boolean encodeUrl, Map<String, String[]> parameters) {
        ArrayList<UIParameter> list = new ArrayList<UIParameter>();
        if (parameters != null) {
            for (Map.Entry<String, String[]> e : parameters.entrySet()) {
                UIParameter p = new UIParameter();
                p.setName(e.getKey());
                p.setValue((Object)e.getValue());
                list.add(p);
            }
        }
        return this.build(mapping, false, list);
    }

    @Deprecated
    public String build(UrlMapping mapping, Object ... parameters) {
        return this.build(mapping, false, parameters);
    }

    public String build(UrlMapping mapping, boolean encodeUrl, Object ... parameters) {
        ArrayList<UIParameter> list = new ArrayList<UIParameter>();
        if (parameters != null) {
            for (Object e : parameters) {
                UIParameter p = new UIParameter();
                if (e != null) {
                    p.setValue((Object)e.toString());
                }
                list.add(p);
            }
        }
        return this.build(mapping, encodeUrl, list);
    }

    @Deprecated
    public String build(UrlMapping mapping, RequestParameter ... parameters) {
        return this.build(mapping, false, parameters);
    }

    public String build(UrlMapping mapping, boolean encodeUrl, RequestParameter ... parameters) {
        ArrayList<UIParameter> list = new ArrayList<UIParameter>();
        if (parameters != null) {
            for (RequestParameter param : parameters) {
                UIParameter p = new UIParameter();
                if (param != null) {
                    p.setValue((Object)param.getName());
                    p.setValue((Object)param.getValue());
                }
                list.add(p);
            }
        }
        return this.build(mapping, false, list);
    }

    @Deprecated
    public String build(UrlMapping urlMapping, List<UIParameter> parameters) {
        return this.build(urlMapping, false, parameters);
    }

    public String build(UrlMapping urlMapping, boolean encodeUrl, List<UIParameter> parameters) {
        String result = "";
        if (urlMapping != null) {
            URLPatternParser parser = new URLPatternParser(urlMapping.getPattern());
            ArrayList<String> pathParams = new ArrayList<String>();
            ArrayList<QueryParameter> queryParams = new ArrayList<QueryParameter>();
            if (parameters != null) {
                UIParameter firstParam;
                if (parameters.size() == 1 && (firstParam = parameters.get(0)).getValue() != null && firstParam.getName() == null) {
                    if (firstParam.getValue() instanceof List) {
                        URL url = parser.getMappedURL(firstParam.getValue());
                        return url.toURL();
                    }
                    if (firstParam.getValue().getClass().isArray()) {
                        List<Object> list = Arrays.asList((Object[])firstParam.getValue());
                        URL url = parser.getMappedURL(list);
                        return url.toURL();
                    }
                }
                for (UIParameter parameter : parameters) {
                    String name = parameter.getName();
                    Object value = parameter.getValue();
                    if (name == null && value != null) {
                        pathParams.add(value.toString());
                        continue;
                    }
                    List<Object> values = null;
                    if (value != null && value.getClass().isArray()) {
                        values = Arrays.asList((Object[])value);
                    } else if (value instanceof List) {
                        values = (List<Object>)value;
                    } else if (value != null) {
                        values = Arrays.asList(value);
                    }
                    if (values != null) {
                        for (Object object : values) {
                            String tempValue = null;
                            if (object != null) {
                                tempValue = object.toString();
                            }
                            queryParams.add(new QueryParameter(name, tempValue));
                        }
                        continue;
                    }
                    queryParams.add(new QueryParameter(name, null));
                }
            }
            URL mappedURL = parser.getMappedURL(pathParams.toArray());
            String url = encodeUrl ? mappedURL.encode().toURL() : mappedURL.toURL();
            result = url + QueryString.build(queryParams).toQueryString();
        }
        return result;
    }
}

