/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.config.annotation;

import com.ocpsoft.pretty.faces.config.annotation.AbstractClassFinder;
import com.ocpsoft.pretty.faces.config.annotation.PackageFilter;
import com.ocpsoft.pretty.faces.config.annotation.PrettyAnnotationHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;

public class WebClassesFinder
extends AbstractClassFinder {
    private static final String CLASSES_FOLDER = "/WEB-INF/classes/";
    private final Set<String> processedClasses = new HashSet<String>();

    public WebClassesFinder(ServletContext servletContext, ClassLoader classLoader, PackageFilter packageFilter) {
        super(servletContext, classLoader, packageFilter);
    }

    public void findClasses(PrettyAnnotationHandler handler) {
        try {
            URL classesFolderUrl = this.servletContext.getResource(CLASSES_FOLDER);
            if (classesFolderUrl == null) {
                this.log.warn("Cannot find classes folder: /WEB-INF/classes/");
                return;
            }
            this.processDirectory(classesFolderUrl, classesFolderUrl, handler);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid URL: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDirectory(URL classesFolderUrl, URL directoryUrl, PrettyAnnotationHandler handler) throws MalformedURLException {
        String classesFolderPath = classesFolderUrl.getPath();
        if (this.log.isTraceEnabled()) {
            this.log.trace("Processing directory: " + directoryUrl.toString());
        }
        String relativeDirectoryName = this.getPathRelativeToClassesFolder(directoryUrl.getPath(), classesFolderPath);
        Set paths = this.servletContext.getResourcePaths(CLASSES_FOLDER + relativeDirectoryName);
        for (Object relativePath : paths) {
            String entryRelativeName;
            String className;
            URL entryUrl = this.servletContext.getResource(relativePath.toString());
            if (entryUrl.getPath().endsWith(".class") && this.mustProcessClass(className = WebClassesFinder.getClassName(entryRelativeName = this.getPathRelativeToClassesFolder(entryUrl.getPath(), classesFolderPath))) && !this.processedClasses.contains(className)) {
                this.processedClasses.add(className);
                InputStream classFileStream = null;
                try {
                    block13: {
                        try {
                            classFileStream = entryUrl.openStream();
                        }
                        catch (IOException e) {
                            if (!this.log.isDebugEnabled()) break block13;
                            this.log.debug("Cound not obtain InputStream for class file: " + entryUrl.toString(), e);
                        }
                    }
                    this.processClass(className, classFileStream, handler);
                }
                finally {
                    block15: {
                        try {
                            if (classFileStream != null) {
                                classFileStream.close();
                            }
                        }
                        catch (IOException e) {
                            if (!this.log.isDebugEnabled()) break block15;
                            this.log.debug("Failed to close input stream: " + e.getMessage());
                        }
                    }
                }
            }
            if (!entryUrl.getPath().endsWith("/")) continue;
            this.processDirectory(classesFolderUrl, entryUrl, handler);
        }
    }

    private String getPathRelativeToClassesFolder(String path, String classesFolderPath) {
        String result = this.stripKnownPrefix(path, CLASSES_FOLDER);
        if (result == null) {
            result = this.stripKnownPrefix(path, classesFolderPath);
        }
        if (result == null) {
            throw new IllegalArgumentException("Unable to build path relative to '/WEB-INF/classes/' from: " + path);
        }
        return result;
    }
}

