/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.clogproxy.client.connection;

import com.oceanbase.clogproxy.client.config.ConnectionConfig;
import com.oceanbase.clogproxy.common.packet.LogType;
import com.oceanbase.clogproxy.common.packet.ProtocolVersion;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ConnectionParams {
    private final LogType logType;
    private final String clientId;
    private final String host;
    private final int port;
    private final ConnectionConfig connectionConfig;
    private String configurationString;
    private ProtocolVersion protocolVersion;
    private boolean enableMonitor;

    public ConnectionParams(LogType logType, String clientId, String host, int port, ConnectionConfig connectionConfig) {
        this.logType = logType;
        this.clientId = clientId;
        this.host = host;
        this.port = port;
        this.connectionConfig = connectionConfig;
        this.configurationString = connectionConfig.generateConfigurationString();
    }

    public void updateCheckpoint(String checkpoint) {
        this.connectionConfig.updateCheckpoint(checkpoint);
        this.configurationString = this.connectionConfig.generateConfigurationString();
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public String info() {
        return this.clientId + ": " + this.connectionConfig.toString();
    }

    public LogType getLogType() {
        return this.logType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getConfigurationString() {
        return this.configurationString;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public boolean isEnableMonitor() {
        return this.enableMonitor;
    }

    public void setEnableMonitor(boolean enableMonitor) {
        this.enableMonitor = enableMonitor;
    }
}

