/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store3.middleware;

import com.google.gson.Gson;
import com.nytimes.android.external.cache3.Preconditions;
import com.nytimes.android.external.store3.base.Parser;
import com.nytimes.android.external.store3.util.ParserException;
import io.reactivex.annotations.NonNull;
import java.lang.reflect.Type;
import javax.inject.Inject;

public class GsonStringParser<Parsed>
implements Parser<String, Parsed> {
    private final Gson gson;
    private final Type type;

    @Inject
    public GsonStringParser(Gson gson, Type parsedClass) {
        Preconditions.checkNotNull((Object)gson, (String)"Gson can't be null");
        Preconditions.checkNotNull((Object)parsedClass, (String)"Type can't be null");
        this.gson = gson;
        this.type = parsedClass;
    }

    public Parsed apply(@NonNull String s) throws ParserException {
        return (Parsed)this.gson.fromJson(s, this.type);
    }
}

