/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store3.middleware;

import com.google.gson.Gson;
import com.nytimes.android.external.store3.base.Parser;
import com.nytimes.android.external.store3.middleware.GsonReaderParser;
import com.nytimes.android.external.store3.middleware.GsonSourceParser;
import com.nytimes.android.external.store3.middleware.GsonStringParser;
import java.io.Reader;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import okio.BufferedSource;

public final class GsonParserFactory {
    private GsonParserFactory() {
    }

    @Nonnull
    public static <T> Parser<Reader, T> createReaderParser(@Nonnull Type type) {
        return GsonParserFactory.createReaderParser(new Gson(), type);
    }

    @Nonnull
    public static <T> Parser<Reader, T> createReaderParser(@Nonnull Gson gson, @Nonnull Type type) {
        return new GsonReaderParser(gson, type);
    }

    @Nonnull
    public static <T> Parser<BufferedSource, T> createSourceParser(@Nonnull Type type) {
        return GsonParserFactory.createSourceParser(new Gson(), type);
    }

    @Nonnull
    public static <T> Parser<BufferedSource, T> createSourceParser(@Nonnull Gson gson, @Nonnull Type type) {
        return new GsonSourceParser(gson, type);
    }

    @Nonnull
    public static <T> Parser<String, T> createStringParser(@Nonnull Class<T> type) {
        return GsonParserFactory.createStringParser(new Gson(), type);
    }

    @Nonnull
    public static <T> Parser<String, T> createStringParser(@Nonnull Gson gson, @Nonnull Type type) {
        return new GsonStringParser(gson, type);
    }
}

