/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.fs3;

import com.nytimes.android.external.fs3.SourceFileReader;
import com.nytimes.android.external.fs3.SourceFileWriter;
import com.nytimes.android.external.fs3.filesystem.FileSystem;
import com.nytimes.android.external.store3.base.Persister;
import com.nytimes.android.external.store3.base.impl.BarCode;
import io.reactivex.Maybe;
import io.reactivex.Single;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import okio.BufferedSource;

public class SourcePersister
implements Persister<BufferedSource, BarCode> {
    @Nonnull
    final SourceFileReader sourceFileReader;
    @Nonnull
    final SourceFileWriter sourceFileWriter;

    @Inject
    public SourcePersister(FileSystem fileSystem) {
        this.sourceFileReader = new SourceFileReader(fileSystem);
        this.sourceFileWriter = new SourceFileWriter(fileSystem);
    }

    public static SourcePersister create(FileSystem fileSystem) {
        return new SourcePersister(fileSystem);
    }

    @Nonnull
    static String pathForBarcode(@Nonnull BarCode barCode) {
        return barCode.getType() + barCode.getKey();
    }

    @Nonnull
    public Maybe<BufferedSource> read(@Nonnull BarCode barCode) {
        return this.sourceFileReader.read(barCode);
    }

    @Nonnull
    public Single<Boolean> write(@Nonnull BarCode barCode, @Nonnull BufferedSource data) {
        return this.sourceFileWriter.write(barCode, data);
    }
}

