/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.fs;

import com.nytimes.android.external.fs.FSReader$$Lambda$1;
import com.nytimes.android.external.fs.PathResolver;
import com.nytimes.android.external.fs.filesystem.FileSystem;
import com.nytimes.android.external.store.base.DiskRead;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.annotation.Nonnull;
import okio.BufferedSource;
import rx.Emitter;
import rx.Observable;
import rx.functions.Action1;

public class FSReader<T>
implements DiskRead<BufferedSource, T> {
    private static final String ERROR_MESSAGE = "resolvedKey does not resolve to a file";
    final FileSystem fileSystem;
    final PathResolver<T> pathResolver;

    public FSReader(FileSystem fileSystem, PathResolver<T> pathResolver) {
        this.fileSystem = fileSystem;
        this.pathResolver = pathResolver;
    }

    @Nonnull
    public Observable<BufferedSource> read(@Nonnull T key) {
        return Observable.create((Action1)FSReader$$Lambda$1.lambdaFactory$(this, key), (Emitter.BackpressureMode)Emitter.BackpressureMode.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void lambda$read$0(@Nonnull FSReader this_, Object key, Emitter emitter) {
        String resolvedKey = this_.pathResolver.resolve(key);
        boolean exists = this_.fileSystem.exists(resolvedKey);
        if (exists) {
            BufferedSource bufferedSource = null;
            try {
                bufferedSource = this_.fileSystem.read(resolvedKey);
                emitter.onNext((Object)bufferedSource);
                emitter.onCompleted();
            }
            catch (FileNotFoundException e) {
                emitter.onError((Throwable)e);
            }
            finally {
                if (bufferedSource != null) {
                    try {
                        bufferedSource.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace(System.err);
                    }
                }
            }
        } else {
            emitter.onError((Throwable)new FileNotFoundException(ERROR_MESSAGE + resolvedKey));
        }
    }
}

