/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.fs;

import com.nytimes.android.external.fs.filesystem.FileSystem;
import com.nytimes.android.external.store.base.DiskAllRead;
import java.io.FileNotFoundException;
import javax.annotation.Nonnull;
import okio.BufferedSource;
import rx.Observable;
import rx.exceptions.Exceptions;
import rx.functions.Func0;
import rx.functions.Func1;

public class FSAllReader
implements DiskAllRead {
    final FileSystem fileSystem;

    public FSAllReader(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Nonnull
    public Observable<BufferedSource> readAll(final @Nonnull String path) throws FileNotFoundException {
        return Observable.defer((Func0)new Func0<Observable<BufferedSource>>(){

            public Observable<BufferedSource> call() {
                Observable bufferedSourceObservable = null;
                try {
                    bufferedSourceObservable = Observable.from(FSAllReader.this.fileSystem.list(path)).map((Func1)new Func1<String, BufferedSource>(){

                        public BufferedSource call(String s) {
                            try {
                                return FSAllReader.this.fileSystem.read(s);
                            }
                            catch (FileNotFoundException e) {
                                throw Exceptions.propagate((Throwable)e);
                            }
                        }
                    });
                }
                catch (FileNotFoundException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
                return bufferedSourceObservable;
            }
        });
    }
}

