/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.fs.filesystem;

import java.io.File;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class BreadthFirstFileTreeIterator
implements Iterator {
    private int currentIndex = 0;
    private File[] currentList;
    @Nullable
    private File nextFile;
    @Nonnull
    private final Stack<File> directories;
    private boolean endOfTree = false;

    BreadthFirstFileTreeIterator(@Nonnull File root) {
        this.currentList = root.listFiles();
        this.directories = new Stack();
    }

    @Override
    public boolean hasNext() {
        return !this.endOfTree && this.getNextFile() != null;
    }

    @Nullable
    public Object next() {
        if (this.endOfTree) {
            throw new NoSuchElementException();
        }
        File file = this.getNextFile();
        if (file == null) {
            throw new NoSuchElementException();
        }
        this.nextFile = null;
        return file;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    protected File getNextFile() {
        if (this.nextFile == null) {
            this.nextFile = this.findNextFile();
        }
        return this.nextFile;
    }

    @Nullable
    protected File findNextFile() {
        while (this.currentIndex < this.currentList.length) {
            if (this.currentList[this.currentIndex].isDirectory()) {
                this.directories.push(this.currentList[this.currentIndex]);
                ++this.currentIndex;
                continue;
            }
            File file = this.currentList[this.currentIndex];
            ++this.currentIndex;
            return file;
        }
        while (!this.directories.empty()) {
            File directory = (File)this.directories.remove(0);
            this.currentList = directory.listFiles();
            this.currentIndex = 0;
            File file = this.findNextFile();
            if (file == null) continue;
            return file;
        }
        this.endOfTree = true;
        return null;
    }
}

