/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.fs;

import dagger.internal.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Util {
    @Nonnull
    public String simplifyPath(@Nonnull String path) {
        if (this.ifInvalidPATH(path)) {
            return "";
        }
        String delim = "[/]+";
        String[] arr = path.split(delim);
        Stack<String> stack = new Stack<String>();
        this.fillStack(arr, stack);
        if (this.emptyStack(stack)) {
            return "/";
        }
        StringBuilder sb = new StringBuilder();
        for (String str : stack) {
            sb.append("/").append(str);
        }
        return sb.toString();
    }

    private boolean emptyStack(@Nonnull Stack<String> stack) {
        return stack.isEmpty();
    }

    private void fillStack(@Nonnull String[] arr, @Nonnull Stack<String> stack) {
        for (String str : arr) {
            if ("/".equals(str)) continue;
            if ("..".equals(str)) {
                if (stack.isEmpty()) continue;
                stack.pop();
                continue;
            }
            if (".".equals(str) || str.isEmpty()) continue;
            stack.push(str);
        }
    }

    private boolean ifInvalidPATH(@Nullable String path) {
        return path == null || path.length() == 0;
    }

    public void createParentDirs(@Nonnull File file) throws IOException {
        Preconditions.checkNotNull((Object)file);
        File parent = file.getCanonicalFile().getParentFile();
        if (parent == null) {
            return;
        }
        parent.mkdirs();
        if (!parent.isDirectory()) {
            throw new IOException("Unable to create parent directories of " + file);
        }
    }
}

