/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.fs;

import com.nytimes.android.external.fs.SourceFileReader;
import com.nytimes.android.external.fs.SourceFileWriter;
import com.nytimes.android.external.fs.filesystem.FileSystem;
import com.nytimes.android.external.store.base.Persister;
import com.nytimes.android.external.store.base.impl.BarCode;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import okio.BufferedSource;
import rx.Observable;

public class SourcePersister
implements Persister<BufferedSource, BarCode> {
    @Nonnull
    final SourceFileReader sourceFileReader;
    @Nonnull
    final SourceFileWriter sourceFileWriter;

    @Inject
    public SourcePersister(FileSystem fileSystem) {
        this.sourceFileReader = new SourceFileReader(fileSystem);
        this.sourceFileWriter = new SourceFileWriter(fileSystem);
    }

    @Nonnull
    static String pathForBarcode(@Nonnull BarCode barCode) {
        return barCode.getType() + barCode.getKey();
    }

    @Nonnull
    public Observable<BufferedSource> read(@Nonnull BarCode barCode) {
        return this.sourceFileReader.read(barCode);
    }

    @Nonnull
    public Observable<Boolean> write(@Nonnull BarCode barCode, @Nonnull BufferedSource data) {
        return this.sourceFileWriter.write(barCode, data);
    }
}

