/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.fs.filesystem;

import com.nytimes.android.external.cache.CacheBuilder;
import com.nytimes.android.external.cache.CacheLoader;
import com.nytimes.android.external.cache.LoadingCache;
import com.nytimes.android.external.fs.Util;
import com.nytimes.android.external.fs.filesystem.BreadthFirstFileTreeIterator;
import com.nytimes.android.external.fs.filesystem.FSFile;
import com.nytimes.android.external.fs.filesystem.FileSystem;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileSystemImpl
implements FileSystem {
    private final Util util = new Util();
    @NotNull
    private final LoadingCache<String, FSFile> files;
    @NotNull
    private final File root;

    FileSystemImpl(final @NotNull File root) throws IOException {
        this.root = root;
        this.files = CacheBuilder.newBuilder().maximumSize(20L).build((CacheLoader)new CacheLoader<String, FSFile>(){

            @NotNull
            public FSFile load(@NotNull String path) throws IOException {
                return new FSFile(root, path);
            }
        });
        this.util.createParentDirs(root);
    }

    @Override
    @NotNull
    public BufferedSource read(@NotNull String path) throws FileNotFoundException {
        return this.getFile(path).source();
    }

    @Override
    public void write(@NotNull String path, BufferedSource source) throws IOException {
        this.getFile(path).write(source);
    }

    @Override
    public void delete(@NotNull String path) throws IOException {
        this.getFile(path).delete();
    }

    @Override
    @NotNull
    public Collection<String> list(@NotNull String directory) throws FileNotFoundException {
        Collection<FSFile> foundFiles = this.findFiles(directory);
        ArrayList<String> names = new ArrayList<String>(foundFiles.size());
        Iterator<FSFile> iterator = foundFiles.iterator();
        while (iterator.hasNext()) {
            names.add(iterator.next().path());
        }
        return names;
    }

    @Override
    public void deleteAll(@NotNull String directory) throws FileNotFoundException {
        Collection<FSFile> foundFiles = this.findFiles(directory);
        Iterator<FSFile> iterator = foundFiles.iterator();
        while (iterator.hasNext()) {
            iterator.next().delete();
        }
    }

    @Override
    public boolean exists(@NotNull String path) {
        return this.getFile(path).exists();
    }

    @Nullable
    private FSFile getFile(@NotNull String path) {
        return (FSFile)this.files.getUnchecked((Object)this.cleanPath(path));
    }

    @NotNull
    private String cleanPath(@NotNull String dirty) {
        return this.util.simplifyPath(dirty);
    }

    @NotNull
    private Collection<FSFile> findFiles(@NotNull String path) throws FileNotFoundException {
        File searchRoot = new File(this.root, this.util.simplifyPath(path));
        if (searchRoot.exists() && searchRoot.isFile()) {
            throw new FileNotFoundException(String.format("expecting a directory at %s, instead found a file", path));
        }
        ArrayList<FSFile> foundFiles = new ArrayList<FSFile>();
        BreadthFirstFileTreeIterator iterator = new BreadthFirstFileTreeIterator(searchRoot);
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            foundFiles.add((FSFile)this.files.getUnchecked((Object)this.util.simplifyPath(file.getPath().replaceFirst(this.root.getPath(), ""))));
        }
        return foundFiles;
    }
}

