/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.fs;

import com.nytimes.android.external.fs.SourcePersister;
import com.nytimes.android.external.fs.filesystem.FileSystem;
import com.nytimes.android.external.store.base.DiskRead;
import com.nytimes.android.external.store.base.impl.BarCode;
import java.io.FileNotFoundException;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import rx.Observable;

public class SourceFileReader
implements DiskRead<BufferedSource> {
    final FileSystem fileSystem;

    @Inject
    public SourceFileReader(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @NotNull
    public Observable<BufferedSource> read(final @NotNull BarCode barCode) {
        return Observable.fromCallable((Callable)new Callable<BufferedSource>(){

            @Override
            @NotNull
            public BufferedSource call() throws FileNotFoundException {
                return SourceFileReader.this.fileSystem.read(SourcePersister.pathForBarcode(barCode));
            }
        });
    }

    public boolean exists(@NotNull BarCode barCode) {
        return this.fileSystem.exists(SourcePersister.pathForBarcode(barCode));
    }
}

