/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.vmm.vmm.v4.images.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.vmm.common.v1.response.ApiLink;
import com.nutanix.dp1.vmm.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.vmm.deserializers.VmmObjectTypeTypedObject;
import com.nutanix.dp1.vmm.vmm.v4.images.config.EnforcementState;
import com.nutanix.dp1.vmm.vmm.v4.images.config.Filter;
import com.nutanix.dp1.vmm.vmm.v4.images.config.PlacementType;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlacementPolicy
extends ExternalizableAbstractModel
implements Serializable,
VmmObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(PlacementPolicy.class);
    private OffsetDateTime createTime = null;
    private OffsetDateTime lastUpdateTime = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String ownerExtId = null;
    @Size(min=1, max=256)
    @JsonProperty(value="name")
    public @Size(min=1, max=256) String name = null;
    @Size(max=1000)
    @JsonProperty(value="description")
    public @Size(max=1000) String description = null;
    @JsonProperty(value="placementType")
    public PlacementType placementType = null;
    @JsonProperty(value="imageEntityFilter")
    public Filter imageEntityFilter = null;
    @JsonProperty(value="clusterEntityFilter")
    public Filter clusterEntityFilter = null;
    @JsonProperty(value="enforcementState")
    public EnforcementState enforcementState = null;

    public PlacementPolicy() {
    }

    public PlacementPolicy(String tenantId, String extId, List<ApiLink> links, String name, String description, PlacementType placementType, Filter imageEntityFilter, Filter clusterEntityFilter, EnforcementState enforcementState, OffsetDateTime createTime, OffsetDateTime lastUpdateTime, String ownerExtId) {
        super(tenantId, extId, links);
        this.setName(name);
        this.setDescription(description);
        this.setPlacementType(placementType);
        this.setImageEntityFilter(imageEntityFilter);
        this.setClusterEntityFilter(clusterEntityFilter);
        this.setEnforcementState(enforcementState);
        this.setCreateTime(createTime);
        this.setLastUpdateTime(lastUpdateTime);
        this.setOwnerExtId(ownerExtId);
    }

    @Override
    protected String initialize$objectType() {
        return "vmm.v4.images.config.PlacementPolicy";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setCreateTime(OffsetDateTime createTime) {
        if (this.createTime == null) {
            this.createTime = createTime;
        } else {
            log.warn("Read-only property createTime already contains a non-null value and cannot be set again");
        }
    }

    public void setLastUpdateTime(OffsetDateTime lastUpdateTime) {
        if (this.lastUpdateTime == null) {
            this.lastUpdateTime = lastUpdateTime;
        } else {
            log.warn("Read-only property lastUpdateTime already contains a non-null value and cannot be set again");
        }
    }

    public void setOwnerExtId(String ownerExtId) {
        if (this.ownerExtId == null) {
            this.ownerExtId = ownerExtId;
        } else {
            log.warn("Read-only property ownerExtId already contains a non-null value and cannot be set again");
        }
    }

    public static PlacementPolicyBuilder PlacementPolicyBuilder() {
        return new PlacementPolicyBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlacementPolicy)) {
            return false;
        }
        PlacementPolicy other = (PlacementPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OffsetDateTime this$createTime = this.getCreateTime();
        OffsetDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        OffsetDateTime this$lastUpdateTime = this.getLastUpdateTime();
        OffsetDateTime other$lastUpdateTime = other.getLastUpdateTime();
        if (this$lastUpdateTime == null ? other$lastUpdateTime != null : !((Object)this$lastUpdateTime).equals(other$lastUpdateTime)) {
            return false;
        }
        String this$ownerExtId = this.getOwnerExtId();
        String other$ownerExtId = other.getOwnerExtId();
        if (this$ownerExtId == null ? other$ownerExtId != null : !this$ownerExtId.equals(other$ownerExtId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        PlacementType this$placementType = this.getPlacementType();
        PlacementType other$placementType = other.getPlacementType();
        if (this$placementType == null ? other$placementType != null : !((Object)((Object)this$placementType)).equals((Object)other$placementType)) {
            return false;
        }
        Filter this$imageEntityFilter = this.getImageEntityFilter();
        Filter other$imageEntityFilter = other.getImageEntityFilter();
        if (this$imageEntityFilter == null ? other$imageEntityFilter != null : !((Object)this$imageEntityFilter).equals(other$imageEntityFilter)) {
            return false;
        }
        Filter this$clusterEntityFilter = this.getClusterEntityFilter();
        Filter other$clusterEntityFilter = other.getClusterEntityFilter();
        if (this$clusterEntityFilter == null ? other$clusterEntityFilter != null : !((Object)this$clusterEntityFilter).equals(other$clusterEntityFilter)) {
            return false;
        }
        EnforcementState this$enforcementState = this.getEnforcementState();
        EnforcementState other$enforcementState = other.getEnforcementState();
        return !(this$enforcementState == null ? other$enforcementState != null : !((Object)((Object)this$enforcementState)).equals((Object)other$enforcementState));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PlacementPolicy;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OffsetDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        OffsetDateTime $lastUpdateTime = this.getLastUpdateTime();
        result = result * 59 + ($lastUpdateTime == null ? 43 : ((Object)$lastUpdateTime).hashCode());
        String $ownerExtId = this.getOwnerExtId();
        result = result * 59 + ($ownerExtId == null ? 43 : $ownerExtId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        PlacementType $placementType = this.getPlacementType();
        result = result * 59 + ($placementType == null ? 43 : ((Object)((Object)$placementType)).hashCode());
        Filter $imageEntityFilter = this.getImageEntityFilter();
        result = result * 59 + ($imageEntityFilter == null ? 43 : ((Object)$imageEntityFilter).hashCode());
        Filter $clusterEntityFilter = this.getClusterEntityFilter();
        result = result * 59 + ($clusterEntityFilter == null ? 43 : ((Object)$clusterEntityFilter).hashCode());
        EnforcementState $enforcementState = this.getEnforcementState();
        result = result * 59 + ($enforcementState == null ? 43 : ((Object)((Object)$enforcementState)).hashCode());
        return result;
    }

    public OffsetDateTime getCreateTime() {
        return this.createTime;
    }

    public OffsetDateTime getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public String getOwnerExtId() {
        return this.ownerExtId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public PlacementType getPlacementType() {
        return this.placementType;
    }

    public Filter getImageEntityFilter() {
        return this.imageEntityFilter;
    }

    public Filter getClusterEntityFilter() {
        return this.clusterEntityFilter;
    }

    public EnforcementState getEnforcementState() {
        return this.enforcementState;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="placementType")
    public void setPlacementType(PlacementType placementType) {
        this.placementType = placementType;
    }

    @JsonProperty(value="imageEntityFilter")
    public void setImageEntityFilter(Filter imageEntityFilter) {
        this.imageEntityFilter = imageEntityFilter;
    }

    @JsonProperty(value="clusterEntityFilter")
    public void setClusterEntityFilter(Filter clusterEntityFilter) {
        this.clusterEntityFilter = clusterEntityFilter;
    }

    @JsonProperty(value="enforcementState")
    public void setEnforcementState(EnforcementState enforcementState) {
        this.enforcementState = enforcementState;
    }

    @Override
    public String toString() {
        return "PlacementPolicy(createTime=" + this.getCreateTime() + ", lastUpdateTime=" + this.getLastUpdateTime() + ", ownerExtId=" + this.getOwnerExtId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", placementType=" + (Object)((Object)this.getPlacementType()) + ", imageEntityFilter=" + this.getImageEntityFilter() + ", clusterEntityFilter=" + this.getClusterEntityFilter() + ", enforcementState=" + (Object)((Object)this.getEnforcementState()) + ")";
    }

    public static class PlacementPolicyBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String name;
        private String description;
        private PlacementType placementType;
        private Filter imageEntityFilter;
        private Filter clusterEntityFilter;
        private EnforcementState enforcementState;
        private OffsetDateTime createTime;
        private OffsetDateTime lastUpdateTime;
        private String ownerExtId;

        PlacementPolicyBuilder() {
        }

        public PlacementPolicyBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public PlacementPolicyBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public PlacementPolicyBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public PlacementPolicyBuilder name(String name) {
            this.name = name;
            return this;
        }

        public PlacementPolicyBuilder description(String description) {
            this.description = description;
            return this;
        }

        public PlacementPolicyBuilder placementType(PlacementType placementType) {
            this.placementType = placementType;
            return this;
        }

        public PlacementPolicyBuilder imageEntityFilter(Filter imageEntityFilter) {
            this.imageEntityFilter = imageEntityFilter;
            return this;
        }

        public PlacementPolicyBuilder clusterEntityFilter(Filter clusterEntityFilter) {
            this.clusterEntityFilter = clusterEntityFilter;
            return this;
        }

        public PlacementPolicyBuilder enforcementState(EnforcementState enforcementState) {
            this.enforcementState = enforcementState;
            return this;
        }

        public PlacementPolicyBuilder createTime(OffsetDateTime createTime) {
            this.createTime = createTime;
            return this;
        }

        public PlacementPolicyBuilder lastUpdateTime(OffsetDateTime lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public PlacementPolicyBuilder ownerExtId(String ownerExtId) {
            this.ownerExtId = ownerExtId;
            return this;
        }

        public PlacementPolicy build() {
            return new PlacementPolicy(this.tenantId, this.extId, this.links, this.name, this.description, this.placementType, this.imageEntityFilter, this.clusterEntityFilter, this.enforcementState, this.createTime, this.lastUpdateTime, this.ownerExtId);
        }

        public String toString() {
            return "PlacementPolicy.PlacementPolicyBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", name=" + this.name + ", description=" + this.description + ", placementType=" + (Object)((Object)this.placementType) + ", imageEntityFilter=" + this.imageEntityFilter + ", clusterEntityFilter=" + this.clusterEntityFilter + ", enforcementState=" + (Object)((Object)this.enforcementState) + ", createTime=" + this.createTime + ", lastUpdateTime=" + this.lastUpdateTime + ", ownerExtId=" + this.ownerExtId + ")";
        }
    }
}

