/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.vmm.vmm.v4.esxi.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.vmm.deserializers.VmmObjectTypeTypedObject;
import com.nutanix.dp1.vmm.vmm.v4.esxi.config.VmDiskContainerReference;
import com.nutanix.dp1.vmm.vmm.v4.esxi.config.VmDiskStorageConfig;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.constraints.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmDisk
implements Serializable,
VmmObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(VmDisk.class);
    @Min(value=1L)
    private @Min(value=1L) Long diskSizeBytes = null;
    @JsonProperty(value="storageContainer")
    public VmDiskContainerReference storageContainer = null;
    @JsonProperty(value="storageConfig")
    public VmDiskStorageConfig storageConfig = null;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public VmDisk() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public VmDisk(Long diskSizeBytes, VmDiskContainerReference storageContainer, VmDiskStorageConfig storageConfig) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setDiskSizeBytes(diskSizeBytes);
        this.setStorageContainer(storageContainer);
        this.setStorageConfig(storageConfig);
    }

    protected String initialize$objectType() {
        return "vmm.v4.esxi.config.VmDisk";
    }

    protected String initialize$fv() {
        return "v4.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public void setDiskSizeBytes(Long diskSizeBytes) {
        if (this.diskSizeBytes == null) {
            this.diskSizeBytes = diskSizeBytes;
        } else {
            log.warn("Read-only property diskSizeBytes already contains a non-null value and cannot be set again");
        }
    }

    public static VmDiskBuilder VmDiskBuilder() {
        return new VmDiskBuilder();
    }

    public Long getDiskSizeBytes() {
        return this.diskSizeBytes;
    }

    public VmDiskContainerReference getStorageContainer() {
        return this.storageContainer;
    }

    public VmDiskStorageConfig getStorageConfig() {
        return this.storageConfig;
    }

    @JsonProperty(value="storageContainer")
    public void setStorageContainer(VmDiskContainerReference storageContainer) {
        this.storageContainer = storageContainer;
    }

    @JsonProperty(value="storageConfig")
    public void setStorageConfig(VmDiskStorageConfig storageConfig) {
        this.storageConfig = storageConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VmDisk)) {
            return false;
        }
        VmDisk other = (VmDisk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$diskSizeBytes = this.getDiskSizeBytes();
        Long other$diskSizeBytes = other.getDiskSizeBytes();
        if (this$diskSizeBytes == null ? other$diskSizeBytes != null : !((Object)this$diskSizeBytes).equals(other$diskSizeBytes)) {
            return false;
        }
        VmDiskContainerReference this$storageContainer = this.getStorageContainer();
        VmDiskContainerReference other$storageContainer = other.getStorageContainer();
        if (this$storageContainer == null ? other$storageContainer != null : !((Object)this$storageContainer).equals(other$storageContainer)) {
            return false;
        }
        VmDiskStorageConfig this$storageConfig = this.getStorageConfig();
        VmDiskStorageConfig other$storageConfig = other.getStorageConfig();
        return !(this$storageConfig == null ? other$storageConfig != null : !((Object)this$storageConfig).equals(other$storageConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VmDisk;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $diskSizeBytes = this.getDiskSizeBytes();
        result = result * 59 + ($diskSizeBytes == null ? 43 : ((Object)$diskSizeBytes).hashCode());
        VmDiskContainerReference $storageContainer = this.getStorageContainer();
        result = result * 59 + ($storageContainer == null ? 43 : ((Object)$storageContainer).hashCode());
        VmDiskStorageConfig $storageConfig = this.getStorageConfig();
        result = result * 59 + ($storageConfig == null ? 43 : ((Object)$storageConfig).hashCode());
        return result;
    }

    public String toString() {
        return "VmDisk(diskSizeBytes=" + this.getDiskSizeBytes() + ", storageContainer=" + this.getStorageContainer() + ", storageConfig=" + this.getStorageConfig() + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class VmDiskBuilder {
        private Long diskSizeBytes;
        private VmDiskContainerReference storageContainer;
        private VmDiskStorageConfig storageConfig;

        VmDiskBuilder() {
        }

        public VmDiskBuilder diskSizeBytes(Long diskSizeBytes) {
            this.diskSizeBytes = diskSizeBytes;
            return this;
        }

        public VmDiskBuilder storageContainer(VmDiskContainerReference storageContainer) {
            this.storageContainer = storageContainer;
            return this;
        }

        public VmDiskBuilder storageConfig(VmDiskStorageConfig storageConfig) {
            this.storageConfig = storageConfig;
            return this;
        }

        public VmDisk build() {
            return new VmDisk(this.diskSizeBytes, this.storageContainer, this.storageConfig);
        }

        public String toString() {
            return "VmDisk.VmDiskBuilder(diskSizeBytes=" + this.diskSizeBytes + ", storageContainer=" + this.storageContainer + ", storageConfig=" + this.storageConfig + ")";
        }
    }
}

