/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.vmm.vmm.v4.ahv.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.vmm.deserializers.VmmObjectTypeTypedObject;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.DataSource;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.VmDiskContainerReference;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.VmDiskStorageConfig;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmDisk
implements Serializable,
VmmObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(VmDisk.class);
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String diskExtId = null;
    private Boolean isMigrationInProgress = null;
    @Min(value=1L)
    @JsonProperty(value="diskSizeBytes")
    public @Min(value=1L) Long diskSizeBytes = null;
    @JsonProperty(value="storageContainer")
    public VmDiskContainerReference storageContainer = null;
    @JsonProperty(value="storageConfig")
    public VmDiskStorageConfig storageConfig = null;
    @JsonProperty(value="dataSource")
    public DataSource dataSource = null;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public VmDisk() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public VmDisk(String diskExtId, Long diskSizeBytes, VmDiskContainerReference storageContainer, VmDiskStorageConfig storageConfig, DataSource dataSource, Boolean isMigrationInProgress) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setDiskExtId(diskExtId);
        this.setDiskSizeBytes(diskSizeBytes);
        this.setStorageContainer(storageContainer);
        this.setStorageConfig(storageConfig);
        this.setDataSource(dataSource);
        this.setIsMigrationInProgress(isMigrationInProgress);
    }

    protected String initialize$objectType() {
        return "vmm.v4.ahv.config.VmDisk";
    }

    protected String initialize$fv() {
        return "v4.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public void setDiskExtId(String diskExtId) {
        if (this.diskExtId == null) {
            this.diskExtId = diskExtId;
        } else {
            log.warn("Read-only property diskExtId already contains a non-null value and cannot be set again");
        }
    }

    public void setIsMigrationInProgress(Boolean isMigrationInProgress) {
        if (this.isMigrationInProgress == null) {
            this.isMigrationInProgress = isMigrationInProgress;
        } else {
            log.warn("Read-only property isMigrationInProgress already contains a non-null value and cannot be set again");
        }
    }

    public static VmDiskBuilder VmDiskBuilder() {
        return new VmDiskBuilder();
    }

    public String getDiskExtId() {
        return this.diskExtId;
    }

    public Boolean getIsMigrationInProgress() {
        return this.isMigrationInProgress;
    }

    public Long getDiskSizeBytes() {
        return this.diskSizeBytes;
    }

    public VmDiskContainerReference getStorageContainer() {
        return this.storageContainer;
    }

    public VmDiskStorageConfig getStorageConfig() {
        return this.storageConfig;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @JsonProperty(value="diskSizeBytes")
    public void setDiskSizeBytes(Long diskSizeBytes) {
        this.diskSizeBytes = diskSizeBytes;
    }

    @JsonProperty(value="storageContainer")
    public void setStorageContainer(VmDiskContainerReference storageContainer) {
        this.storageContainer = storageContainer;
    }

    @JsonProperty(value="storageConfig")
    public void setStorageConfig(VmDiskStorageConfig storageConfig) {
        this.storageConfig = storageConfig;
    }

    @JsonProperty(value="dataSource")
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VmDisk)) {
            return false;
        }
        VmDisk other = (VmDisk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$diskExtId = this.getDiskExtId();
        String other$diskExtId = other.getDiskExtId();
        if (this$diskExtId == null ? other$diskExtId != null : !this$diskExtId.equals(other$diskExtId)) {
            return false;
        }
        Boolean this$isMigrationInProgress = this.getIsMigrationInProgress();
        Boolean other$isMigrationInProgress = other.getIsMigrationInProgress();
        if (this$isMigrationInProgress == null ? other$isMigrationInProgress != null : !((Object)this$isMigrationInProgress).equals(other$isMigrationInProgress)) {
            return false;
        }
        Long this$diskSizeBytes = this.getDiskSizeBytes();
        Long other$diskSizeBytes = other.getDiskSizeBytes();
        if (this$diskSizeBytes == null ? other$diskSizeBytes != null : !((Object)this$diskSizeBytes).equals(other$diskSizeBytes)) {
            return false;
        }
        VmDiskContainerReference this$storageContainer = this.getStorageContainer();
        VmDiskContainerReference other$storageContainer = other.getStorageContainer();
        if (this$storageContainer == null ? other$storageContainer != null : !((Object)this$storageContainer).equals(other$storageContainer)) {
            return false;
        }
        VmDiskStorageConfig this$storageConfig = this.getStorageConfig();
        VmDiskStorageConfig other$storageConfig = other.getStorageConfig();
        if (this$storageConfig == null ? other$storageConfig != null : !((Object)this$storageConfig).equals(other$storageConfig)) {
            return false;
        }
        DataSource this$dataSource = this.getDataSource();
        DataSource other$dataSource = other.getDataSource();
        return !(this$dataSource == null ? other$dataSource != null : !((Object)this$dataSource).equals(other$dataSource));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VmDisk;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $diskExtId = this.getDiskExtId();
        result = result * 59 + ($diskExtId == null ? 43 : $diskExtId.hashCode());
        Boolean $isMigrationInProgress = this.getIsMigrationInProgress();
        result = result * 59 + ($isMigrationInProgress == null ? 43 : ((Object)$isMigrationInProgress).hashCode());
        Long $diskSizeBytes = this.getDiskSizeBytes();
        result = result * 59 + ($diskSizeBytes == null ? 43 : ((Object)$diskSizeBytes).hashCode());
        VmDiskContainerReference $storageContainer = this.getStorageContainer();
        result = result * 59 + ($storageContainer == null ? 43 : ((Object)$storageContainer).hashCode());
        VmDiskStorageConfig $storageConfig = this.getStorageConfig();
        result = result * 59 + ($storageConfig == null ? 43 : ((Object)$storageConfig).hashCode());
        DataSource $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : ((Object)$dataSource).hashCode());
        return result;
    }

    public String toString() {
        return "VmDisk(diskExtId=" + this.getDiskExtId() + ", isMigrationInProgress=" + this.getIsMigrationInProgress() + ", diskSizeBytes=" + this.getDiskSizeBytes() + ", storageContainer=" + this.getStorageContainer() + ", storageConfig=" + this.getStorageConfig() + ", dataSource=" + this.getDataSource() + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class VmDiskBuilder {
        private String diskExtId;
        private Long diskSizeBytes;
        private VmDiskContainerReference storageContainer;
        private VmDiskStorageConfig storageConfig;
        private DataSource dataSource;
        private Boolean isMigrationInProgress;

        VmDiskBuilder() {
        }

        public VmDiskBuilder diskExtId(String diskExtId) {
            this.diskExtId = diskExtId;
            return this;
        }

        public VmDiskBuilder diskSizeBytes(Long diskSizeBytes) {
            this.diskSizeBytes = diskSizeBytes;
            return this;
        }

        public VmDiskBuilder storageContainer(VmDiskContainerReference storageContainer) {
            this.storageContainer = storageContainer;
            return this;
        }

        public VmDiskBuilder storageConfig(VmDiskStorageConfig storageConfig) {
            this.storageConfig = storageConfig;
            return this;
        }

        public VmDiskBuilder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public VmDiskBuilder isMigrationInProgress(Boolean isMigrationInProgress) {
            this.isMigrationInProgress = isMigrationInProgress;
            return this;
        }

        public VmDisk build() {
            return new VmDisk(this.diskExtId, this.diskSizeBytes, this.storageContainer, this.storageConfig, this.dataSource, this.isMigrationInProgress);
        }

        public String toString() {
            return "VmDisk.VmDiskBuilder(diskExtId=" + this.diskExtId + ", diskSizeBytes=" + this.diskSizeBytes + ", storageContainer=" + this.storageContainer + ", storageConfig=" + this.storageConfig + ", dataSource=" + this.dataSource + ", isMigrationInProgress=" + this.isMigrationInProgress + ")";
        }
    }
}

