/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.vmm.vmm.v4.ahv.config;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.nutanix.dp1.vmm.annotations.VmmJsonDeserializer;
import com.nutanix.dp1.vmm.common.v1.response.ApiLink;
import com.nutanix.dp1.vmm.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.vmm.deserializers.VmmObjectTypeTypedObject;
import com.nutanix.dp1.vmm.deserializers.VmmOneOfDeserializer;
import com.nutanix.dp1.vmm.serializers.VmmOneOfSerializer;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.ADSFVolumeGroupReference;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.DiskAddress;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.VmDisk;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Disk
extends ExternalizableAbstractModel
implements Serializable,
VmmObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Disk.class);
    @JsonProperty(value="diskAddress")
    public DiskAddress diskAddress = null;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String $backingInfoItemDiscriminator = null;
    private OneOfBackingInfoWrapper backingInfo = null;

    public Disk() {
    }

    public Disk(String tenantId, String extId, List<ApiLink> links, DiskAddress diskAddress, Object backingInfo) {
        super(tenantId, extId, links);
        this.setDiskAddress(diskAddress);
        this.setBackingInfoInWrapper(backingInfo);
    }

    @Override
    protected String initialize$objectType() {
        return "vmm.v4.ahv.config.Disk";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public String get$backingInfoItemDiscriminator() {
        if (this.backingInfo != null && this.$backingInfoItemDiscriminator == null) {
            this.$backingInfoItemDiscriminator = this.backingInfo.getDiscriminator();
        }
        return this.$backingInfoItemDiscriminator;
    }

    @JsonIgnore
    public void setBackingInfoInWrapper(Object value) {
        if (value == null) {
            return;
        }
        if (this.backingInfo == null) {
            this.backingInfo = new OneOfBackingInfoWrapper();
        }
        this.backingInfo.setValue(value);
        this.$backingInfoItemDiscriminator = this.backingInfo.getDiscriminator();
    }

    @JsonSerialize(using=VmmOneOfSerializer.class)
    public Object getBackingInfo() {
        if (this.backingInfo == null) {
            log.debug("OneOf property backingInfo was never set. Returning null...");
            return null;
        }
        return this.backingInfo.getValue();
    }

    public static DiskBuilder DiskBuilder() {
        return new DiskBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Disk)) {
            return false;
        }
        Disk other = (Disk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DiskAddress this$diskAddress = this.getDiskAddress();
        DiskAddress other$diskAddress = other.getDiskAddress();
        if (this$diskAddress == null ? other$diskAddress != null : !((Object)this$diskAddress).equals(other$diskAddress)) {
            return false;
        }
        Object this$backingInfo = this.getBackingInfo();
        Object other$backingInfo = other.getBackingInfo();
        return !(this$backingInfo == null ? other$backingInfo != null : !this$backingInfo.equals(other$backingInfo));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Disk;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DiskAddress $diskAddress = this.getDiskAddress();
        result = result * 59 + ($diskAddress == null ? 43 : ((Object)$diskAddress).hashCode());
        Object $backingInfo = this.getBackingInfo();
        result = result * 59 + ($backingInfo == null ? 43 : $backingInfo.hashCode());
        return result;
    }

    public DiskAddress getDiskAddress() {
        return this.diskAddress;
    }

    @JsonProperty(value="diskAddress")
    public void setDiskAddress(DiskAddress diskAddress) {
        this.diskAddress = diskAddress;
    }

    public void setBackingInfo(OneOfBackingInfoWrapper backingInfo) {
        this.backingInfo = backingInfo;
    }

    @Override
    public String toString() {
        return "Disk(diskAddress=" + this.getDiskAddress() + ", backingInfo=" + this.getBackingInfo() + ")";
    }

    public static class DiskBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private DiskAddress diskAddress;
        private Object backingInfo;

        DiskBuilder() {
        }

        public DiskBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public DiskBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public DiskBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public DiskBuilder diskAddress(DiskAddress diskAddress) {
            this.diskAddress = diskAddress;
            return this;
        }

        public DiskBuilder backingInfo(Object backingInfo) {
            this.backingInfo = backingInfo;
            return this;
        }

        public Disk build() {
            return new Disk(this.tenantId, this.extId, this.links, this.diskAddress, this.backingInfo);
        }

        public String toString() {
            return "Disk.DiskBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", diskAddress=" + this.diskAddress + ", backingInfo=" + this.backingInfo + ")";
        }
    }

    @JsonDeserialize(using=OneOfBackingInfoWrapperJsonDeserializer.class)
    public static class OneOfBackingInfoWrapper {
        @JsonIgnore
        private VmDisk oneOfType2001;
        @JsonIgnore
        private ADSFVolumeGroupReference oneOfType2002;
        private String discriminator;
        @JsonIgnore
        private String $objectType;

        public OneOfBackingInfoWrapper() {
        }

        public OneOfBackingInfoWrapper(VmDisk data) {
            this.oneOfType2001 = data;
            this.discriminator = data.get$objectType();
            this.$objectType = data.get$objectType();
        }

        public OneOfBackingInfoWrapper(ADSFVolumeGroupReference data) {
            this.oneOfType2002 = data;
            this.discriminator = data.get$objectType();
            this.$objectType = data.get$objectType();
        }

        @JsonGetter
        public Object getValue() {
            if (this.oneOfType2001 != null && this.oneOfType2001.get$objectType().equals(this.discriminator)) {
                return this.oneOfType2001;
            }
            if (this.oneOfType2002 != null && this.oneOfType2002.get$objectType().equals(this.discriminator)) {
                return this.oneOfType2002;
            }
            throw new IllegalArgumentException("Unrecognized discriminator:" + this.discriminator);
        }

        public void setValue(Object value) {
            if (value == null) {
                log.warn("null passed to setValue function. OneOf's value will not be set.");
                return;
            }
            if (value instanceof VmDisk) {
                this.oneOfType2001 = (VmDisk)value;
                this.discriminator = this.oneOfType2001.get$objectType();
                this.$objectType = this.oneOfType2001.get$objectType();
                return;
            }
            if (value instanceof ADSFVolumeGroupReference) {
                this.oneOfType2002 = (ADSFVolumeGroupReference)value;
                this.discriminator = this.oneOfType2002.get$objectType();
                this.$objectType = this.oneOfType2002.get$objectType();
                return;
            }
            throw new IllegalArgumentException("Attempting to set unsupported object type in OneOfBackingInfoWrapper:" + value.getClass().getName());
        }

        public String getDiscriminator() {
            return this.discriminator;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OneOfBackingInfoWrapper)) {
                return false;
            }
            OneOfBackingInfoWrapper other = (OneOfBackingInfoWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            VmDisk this$oneOfType2001 = this.oneOfType2001;
            VmDisk other$oneOfType2001 = other.oneOfType2001;
            if (this$oneOfType2001 == null ? other$oneOfType2001 != null : !((Object)this$oneOfType2001).equals(other$oneOfType2001)) {
                return false;
            }
            ADSFVolumeGroupReference this$oneOfType2002 = this.oneOfType2002;
            ADSFVolumeGroupReference other$oneOfType2002 = other.oneOfType2002;
            if (this$oneOfType2002 == null ? other$oneOfType2002 != null : !((Object)this$oneOfType2002).equals(other$oneOfType2002)) {
                return false;
            }
            String this$discriminator = this.getDiscriminator();
            String other$discriminator = other.getDiscriminator();
            return !(this$discriminator == null ? other$discriminator != null : !this$discriminator.equals(other$discriminator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OneOfBackingInfoWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            VmDisk $oneOfType2001 = this.oneOfType2001;
            result = result * 59 + ($oneOfType2001 == null ? 43 : ((Object)$oneOfType2001).hashCode());
            ADSFVolumeGroupReference $oneOfType2002 = this.oneOfType2002;
            result = result * 59 + ($oneOfType2002 == null ? 43 : ((Object)$oneOfType2002).hashCode());
            String $discriminator = this.getDiscriminator();
            result = result * 59 + ($discriminator == null ? 43 : $discriminator.hashCode());
            return result;
        }

        public String toString() {
            return "Disk.OneOfBackingInfoWrapper(oneOfType2001=" + this.oneOfType2001 + ", oneOfType2002=" + this.oneOfType2002 + ", discriminator=" + this.getDiscriminator() + ")";
        }

        @VmmJsonDeserializer
        private static class OneOfBackingInfoWrapperJsonDeserializer
        extends VmmOneOfDeserializer<OneOfBackingInfoWrapper> {
            private static final TypeFactory TYPE_FACTORY = TypeFactory.defaultInstance();
            private static final JavaType ONE_OF_TYPE2001 = TYPE_FACTORY.constructType(VmDisk.class);
            private static final JavaType ONE_OF_TYPE2002 = TYPE_FACTORY.constructType(ADSFVolumeGroupReference.class);

            public OneOfBackingInfoWrapperJsonDeserializer() {
                super(TYPE_FACTORY.constructType(OneOfBackingInfoWrapper.class));
            }

            @Override
            protected void setDataObject(OneOfBackingInfoWrapper oneOfObject, Object nestedObject) {
                if (oneOfObject == null) {
                    throw new IllegalArgumentException("Instance of OneOfBackingInfoWrapper provided is null");
                }
                if (ONE_OF_TYPE2001.getRawClass().isAssignableFrom(nestedObject.getClass())) {
                    oneOfObject.setValue(nestedObject);
                    if (oneOfObject.getValue() != null) {
                        return;
                    }
                }
                if (ONE_OF_TYPE2002.getRawClass().isAssignableFrom(nestedObject.getClass())) {
                    oneOfObject.setValue(nestedObject);
                    if (oneOfObject.getValue() != null) {
                        return;
                    }
                }
                throw new IllegalArgumentException("Attempting to set unsupported object type in OneOfBackingInfoWrapper:" + nestedObject.getClass().getName());
            }

            @Override
            public String getPackagePrefix() {
                return "com.nutanix.dp1.vmm";
            }
        }
    }
}

