/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.vmm.iam.v4.authn;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.vmm.common.v1.config.KVPair;
import com.nutanix.dp1.vmm.common.v1.response.ApiLink;
import com.nutanix.dp1.vmm.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.vmm.deserializers.VmmObjectTypeTypedObject;
import com.nutanix.dp1.vmm.iam.v4.authn.BucketsAccessKey;
import com.nutanix.dp1.vmm.iam.v4.authn.CreationType;
import com.nutanix.dp1.vmm.iam.v4.authn.UserStatusType;
import com.nutanix.dp1.vmm.iam.v4.authn.UserType;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class User
extends ExternalizableAbstractModel
implements Serializable,
VmmObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(User.class);
    @Size(min=0, max=5)
    private @Size(min=0, max=5) List<BucketsAccessKey> bucketsAccessKeys = null;
    private OffsetDateTime lastLoginTime = null;
    private OffsetDateTime createdTime = null;
    private OffsetDateTime lastUpdatedTime = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String createdBy = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String lastUpdatedBy = null;
    @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$")
    @Size(min=1, max=255)
    @JsonProperty(value="username")
    public @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$") @Size(min=1, max=255) String username = null;
    @JsonProperty(value="userType")
    public UserType userType = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="idpId")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String idpId = null;
    @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$")
    @Size(min=1, max=255)
    @JsonProperty(value="displayName")
    public @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$") @Size(min=1, max=255) String displayName = null;
    @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$")
    @Size(min=1, max=255)
    @JsonProperty(value="firstName")
    public @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$") @Size(min=1, max=255) String firstName = null;
    @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$")
    @Size(min=1, max=255)
    @JsonProperty(value="middleInitial")
    public @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$") @Size(min=1, max=255) String middleInitial = null;
    @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$")
    @Size(min=1, max=255)
    @JsonProperty(value="lastName")
    public @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$") @Size(min=1, max=255) String lastName = null;
    @Pattern(regexp="^([a-zA-Z0-9_\\-\\.]+)@([a-zA-Z0-9_\\-\\.]+)\\.([a-zA-Z]{2,5})$")
    @Size(max=255)
    @JsonProperty(value="emailId")
    public @Pattern(regexp="^([a-zA-Z0-9_\\-\\.]+)@([a-zA-Z0-9_\\-\\.]+)\\.([a-zA-Z]{2,5})$") @Size(max=255) String emailId = null;
    @JsonProperty(value="locale")
    public String locale = null;
    @JsonProperty(value="region")
    public String region = null;
    @JsonProperty(value="password")
    public String password = null;
    @JsonProperty(value="isForceResetPasswordEnabled")
    public Boolean isForceResetPasswordEnabled = null;
    @Size(min=0, max=10)
    @JsonProperty(value="additionalAttributes")
    public @Size(min=0, max=10) List<KVPair> additionalAttributes = null;
    @JsonProperty(value="status")
    public UserStatusType status = null;
    @JsonProperty(value="description")
    public String description = null;
    @JsonProperty(value="creationType")
    public CreationType creationType = null;

    public User() {
    }

    public User(String tenantId, String extId, List<ApiLink> links, String username, UserType userType, String idpId, String displayName, String firstName, String middleInitial, String lastName, String emailId, String locale, String region, String password, Boolean isForceResetPasswordEnabled, List<KVPair> additionalAttributes, UserStatusType status, List<BucketsAccessKey> bucketsAccessKeys, OffsetDateTime lastLoginTime, OffsetDateTime createdTime, OffsetDateTime lastUpdatedTime, String createdBy, String lastUpdatedBy, String description, CreationType creationType) {
        super(tenantId, extId, links);
        this.setUsername(username);
        this.setUserType(userType);
        this.setIdpId(idpId);
        this.setDisplayName(displayName);
        this.setFirstName(firstName);
        this.setMiddleInitial(middleInitial);
        this.setLastName(lastName);
        this.setEmailId(emailId);
        this.setLocale(locale);
        this.setRegion(region);
        this.setPassword(password);
        this.setIsForceResetPasswordEnabled(isForceResetPasswordEnabled);
        this.setAdditionalAttributes(additionalAttributes);
        this.setStatus(status);
        this.setBucketsAccessKeys(bucketsAccessKeys);
        this.setLastLoginTime(lastLoginTime);
        this.setCreatedTime(createdTime);
        this.setLastUpdatedTime(lastUpdatedTime);
        this.setCreatedBy(createdBy);
        this.setLastUpdatedBy(lastUpdatedBy);
        this.setDescription(description);
        this.setCreationType(creationType);
    }

    @Override
    protected String initialize$objectType() {
        return "iam.v4.authn.User";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setBucketsAccessKeys(List<BucketsAccessKey> bucketsAccessKeys) {
        if (this.bucketsAccessKeys == null) {
            this.bucketsAccessKeys = bucketsAccessKeys;
        } else {
            log.warn("Read-only property bucketsAccessKeys already contains a non-null value and cannot be set again");
        }
    }

    public void setLastLoginTime(OffsetDateTime lastLoginTime) {
        if (this.lastLoginTime == null) {
            this.lastLoginTime = lastLoginTime;
        } else {
            log.warn("Read-only property lastLoginTime already contains a non-null value and cannot be set again");
        }
    }

    public void setCreatedTime(OffsetDateTime createdTime) {
        if (this.createdTime == null) {
            this.createdTime = createdTime;
        } else {
            log.warn("Read-only property createdTime already contains a non-null value and cannot be set again");
        }
    }

    public void setLastUpdatedTime(OffsetDateTime lastUpdatedTime) {
        if (this.lastUpdatedTime == null) {
            this.lastUpdatedTime = lastUpdatedTime;
        } else {
            log.warn("Read-only property lastUpdatedTime already contains a non-null value and cannot be set again");
        }
    }

    public void setCreatedBy(String createdBy) {
        if (this.createdBy == null) {
            this.createdBy = createdBy;
        } else {
            log.warn("Read-only property createdBy already contains a non-null value and cannot be set again");
        }
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        if (this.lastUpdatedBy == null) {
            this.lastUpdatedBy = lastUpdatedBy;
        } else {
            log.warn("Read-only property lastUpdatedBy already contains a non-null value and cannot be set again");
        }
    }

    public static UserBuilder UserBuilder() {
        return new UserBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<BucketsAccessKey> this$bucketsAccessKeys = this.getBucketsAccessKeys();
        List<BucketsAccessKey> other$bucketsAccessKeys = other.getBucketsAccessKeys();
        if (this$bucketsAccessKeys == null ? other$bucketsAccessKeys != null : !((Object)this$bucketsAccessKeys).equals(other$bucketsAccessKeys)) {
            return false;
        }
        OffsetDateTime this$lastLoginTime = this.getLastLoginTime();
        OffsetDateTime other$lastLoginTime = other.getLastLoginTime();
        if (this$lastLoginTime == null ? other$lastLoginTime != null : !((Object)this$lastLoginTime).equals(other$lastLoginTime)) {
            return false;
        }
        OffsetDateTime this$createdTime = this.getCreatedTime();
        OffsetDateTime other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        OffsetDateTime this$lastUpdatedTime = this.getLastUpdatedTime();
        OffsetDateTime other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        String this$lastUpdatedBy = this.getLastUpdatedBy();
        String other$lastUpdatedBy = other.getLastUpdatedBy();
        if (this$lastUpdatedBy == null ? other$lastUpdatedBy != null : !this$lastUpdatedBy.equals(other$lastUpdatedBy)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        UserType this$userType = this.getUserType();
        UserType other$userType = other.getUserType();
        if (this$userType == null ? other$userType != null : !((Object)((Object)this$userType)).equals((Object)other$userType)) {
            return false;
        }
        String this$idpId = this.getIdpId();
        String other$idpId = other.getIdpId();
        if (this$idpId == null ? other$idpId != null : !this$idpId.equals(other$idpId)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$middleInitial = this.getMiddleInitial();
        String other$middleInitial = other.getMiddleInitial();
        if (this$middleInitial == null ? other$middleInitial != null : !this$middleInitial.equals(other$middleInitial)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        String this$emailId = this.getEmailId();
        String other$emailId = other.getEmailId();
        if (this$emailId == null ? other$emailId != null : !this$emailId.equals(other$emailId)) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Boolean this$isForceResetPasswordEnabled = this.getIsForceResetPasswordEnabled();
        Boolean other$isForceResetPasswordEnabled = other.getIsForceResetPasswordEnabled();
        if (this$isForceResetPasswordEnabled == null ? other$isForceResetPasswordEnabled != null : !((Object)this$isForceResetPasswordEnabled).equals(other$isForceResetPasswordEnabled)) {
            return false;
        }
        List<KVPair> this$additionalAttributes = this.getAdditionalAttributes();
        List<KVPair> other$additionalAttributes = other.getAdditionalAttributes();
        if (this$additionalAttributes == null ? other$additionalAttributes != null : !((Object)this$additionalAttributes).equals(other$additionalAttributes)) {
            return false;
        }
        UserStatusType this$status = this.getStatus();
        UserStatusType other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        CreationType this$creationType = this.getCreationType();
        CreationType other$creationType = other.getCreationType();
        return !(this$creationType == null ? other$creationType != null : !((Object)((Object)this$creationType)).equals((Object)other$creationType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof User;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<BucketsAccessKey> $bucketsAccessKeys = this.getBucketsAccessKeys();
        result = result * 59 + ($bucketsAccessKeys == null ? 43 : ((Object)$bucketsAccessKeys).hashCode());
        OffsetDateTime $lastLoginTime = this.getLastLoginTime();
        result = result * 59 + ($lastLoginTime == null ? 43 : ((Object)$lastLoginTime).hashCode());
        OffsetDateTime $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        OffsetDateTime $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        String $lastUpdatedBy = this.getLastUpdatedBy();
        result = result * 59 + ($lastUpdatedBy == null ? 43 : $lastUpdatedBy.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        UserType $userType = this.getUserType();
        result = result * 59 + ($userType == null ? 43 : ((Object)((Object)$userType)).hashCode());
        String $idpId = this.getIdpId();
        result = result * 59 + ($idpId == null ? 43 : $idpId.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $middleInitial = this.getMiddleInitial();
        result = result * 59 + ($middleInitial == null ? 43 : $middleInitial.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        String $emailId = this.getEmailId();
        result = result * 59 + ($emailId == null ? 43 : $emailId.hashCode());
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Boolean $isForceResetPasswordEnabled = this.getIsForceResetPasswordEnabled();
        result = result * 59 + ($isForceResetPasswordEnabled == null ? 43 : ((Object)$isForceResetPasswordEnabled).hashCode());
        List<KVPair> $additionalAttributes = this.getAdditionalAttributes();
        result = result * 59 + ($additionalAttributes == null ? 43 : ((Object)$additionalAttributes).hashCode());
        UserStatusType $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        CreationType $creationType = this.getCreationType();
        result = result * 59 + ($creationType == null ? 43 : ((Object)((Object)$creationType)).hashCode());
        return result;
    }

    public List<BucketsAccessKey> getBucketsAccessKeys() {
        return this.bucketsAccessKeys;
    }

    public OffsetDateTime getLastLoginTime() {
        return this.lastLoginTime;
    }

    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public OffsetDateTime getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public String getUsername() {
        return this.username;
    }

    public UserType getUserType() {
        return this.userType;
    }

    public String getIdpId() {
        return this.idpId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getMiddleInitial() {
        return this.middleInitial;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmailId() {
        return this.emailId;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getRegion() {
        return this.region;
    }

    public String getPassword() {
        return this.password;
    }

    public Boolean getIsForceResetPasswordEnabled() {
        return this.isForceResetPasswordEnabled;
    }

    public List<KVPair> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public UserStatusType getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    public CreationType getCreationType() {
        return this.creationType;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    @JsonProperty(value="userType")
    public void setUserType(UserType userType) {
        this.userType = userType;
    }

    @JsonProperty(value="idpId")
    public void setIdpId(String idpId) {
        this.idpId = idpId;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @JsonProperty(value="firstName")
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @JsonProperty(value="middleInitial")
    public void setMiddleInitial(String middleInitial) {
        this.middleInitial = middleInitial;
    }

    @JsonProperty(value="lastName")
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @JsonProperty(value="emailId")
    public void setEmailId(String emailId) {
        this.emailId = emailId;
    }

    @JsonProperty(value="locale")
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @JsonProperty(value="region")
    public void setRegion(String region) {
        this.region = region;
    }

    @JsonProperty(value="password")
    public void setPassword(String password) {
        this.password = password;
    }

    @JsonProperty(value="isForceResetPasswordEnabled")
    public void setIsForceResetPasswordEnabled(Boolean isForceResetPasswordEnabled) {
        this.isForceResetPasswordEnabled = isForceResetPasswordEnabled;
    }

    @JsonProperty(value="additionalAttributes")
    public void setAdditionalAttributes(List<KVPair> additionalAttributes) {
        this.additionalAttributes = additionalAttributes;
    }

    @JsonProperty(value="status")
    public void setStatus(UserStatusType status) {
        this.status = status;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="creationType")
    public void setCreationType(CreationType creationType) {
        this.creationType = creationType;
    }

    @Override
    public String toString() {
        return "User(bucketsAccessKeys=" + this.getBucketsAccessKeys() + ", lastLoginTime=" + this.getLastLoginTime() + ", createdTime=" + this.getCreatedTime() + ", lastUpdatedTime=" + this.getLastUpdatedTime() + ", createdBy=" + this.getCreatedBy() + ", lastUpdatedBy=" + this.getLastUpdatedBy() + ", username=" + this.getUsername() + ", userType=" + (Object)((Object)this.getUserType()) + ", idpId=" + this.getIdpId() + ", displayName=" + this.getDisplayName() + ", firstName=" + this.getFirstName() + ", middleInitial=" + this.getMiddleInitial() + ", lastName=" + this.getLastName() + ", emailId=" + this.getEmailId() + ", locale=" + this.getLocale() + ", region=" + this.getRegion() + ", password=" + this.getPassword() + ", isForceResetPasswordEnabled=" + this.getIsForceResetPasswordEnabled() + ", additionalAttributes=" + this.getAdditionalAttributes() + ", status=" + (Object)((Object)this.getStatus()) + ", description=" + this.getDescription() + ", creationType=" + (Object)((Object)this.getCreationType()) + ")";
    }

    public static class UserBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String username;
        private UserType userType;
        private String idpId;
        private String displayName;
        private String firstName;
        private String middleInitial;
        private String lastName;
        private String emailId;
        private String locale;
        private String region;
        private String password;
        private Boolean isForceResetPasswordEnabled;
        private List<KVPair> additionalAttributes;
        private UserStatusType status;
        private List<BucketsAccessKey> bucketsAccessKeys;
        private OffsetDateTime lastLoginTime;
        private OffsetDateTime createdTime;
        private OffsetDateTime lastUpdatedTime;
        private String createdBy;
        private String lastUpdatedBy;
        private String description;
        private CreationType creationType;

        UserBuilder() {
        }

        public UserBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public UserBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public UserBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public UserBuilder username(String username) {
            this.username = username;
            return this;
        }

        public UserBuilder userType(UserType userType) {
            this.userType = userType;
            return this;
        }

        public UserBuilder idpId(String idpId) {
            this.idpId = idpId;
            return this;
        }

        public UserBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public UserBuilder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public UserBuilder middleInitial(String middleInitial) {
            this.middleInitial = middleInitial;
            return this;
        }

        public UserBuilder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public UserBuilder emailId(String emailId) {
            this.emailId = emailId;
            return this;
        }

        public UserBuilder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public UserBuilder region(String region) {
            this.region = region;
            return this;
        }

        public UserBuilder password(String password) {
            this.password = password;
            return this;
        }

        public UserBuilder isForceResetPasswordEnabled(Boolean isForceResetPasswordEnabled) {
            this.isForceResetPasswordEnabled = isForceResetPasswordEnabled;
            return this;
        }

        public UserBuilder additionalAttributes(List<KVPair> additionalAttributes) {
            this.additionalAttributes = additionalAttributes;
            return this;
        }

        public UserBuilder status(UserStatusType status) {
            this.status = status;
            return this;
        }

        public UserBuilder bucketsAccessKeys(List<BucketsAccessKey> bucketsAccessKeys) {
            this.bucketsAccessKeys = bucketsAccessKeys;
            return this;
        }

        public UserBuilder lastLoginTime(OffsetDateTime lastLoginTime) {
            this.lastLoginTime = lastLoginTime;
            return this;
        }

        public UserBuilder createdTime(OffsetDateTime createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public UserBuilder lastUpdatedTime(OffsetDateTime lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public UserBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public UserBuilder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public UserBuilder description(String description) {
            this.description = description;
            return this;
        }

        public UserBuilder creationType(CreationType creationType) {
            this.creationType = creationType;
            return this;
        }

        public User build() {
            return new User(this.tenantId, this.extId, this.links, this.username, this.userType, this.idpId, this.displayName, this.firstName, this.middleInitial, this.lastName, this.emailId, this.locale, this.region, this.password, this.isForceResetPasswordEnabled, this.additionalAttributes, this.status, this.bucketsAccessKeys, this.lastLoginTime, this.createdTime, this.lastUpdatedTime, this.createdBy, this.lastUpdatedBy, this.description, this.creationType);
        }

        public String toString() {
            return "User.UserBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", username=" + this.username + ", userType=" + (Object)((Object)this.userType) + ", idpId=" + this.idpId + ", displayName=" + this.displayName + ", firstName=" + this.firstName + ", middleInitial=" + this.middleInitial + ", lastName=" + this.lastName + ", emailId=" + this.emailId + ", locale=" + this.locale + ", region=" + this.region + ", password=" + this.password + ", isForceResetPasswordEnabled=" + this.isForceResetPasswordEnabled + ", additionalAttributes=" + this.additionalAttributes + ", status=" + (Object)((Object)this.status) + ", bucketsAccessKeys=" + this.bucketsAccessKeys + ", lastLoginTime=" + this.lastLoginTime + ", createdTime=" + this.createdTime + ", lastUpdatedTime=" + this.lastUpdatedTime + ", createdBy=" + this.createdBy + ", lastUpdatedBy=" + this.lastUpdatedBy + ", description=" + this.description + ", creationType=" + (Object)((Object)this.creationType) + ")";
        }
    }
}

