/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.vmm.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.nutanix.dp1.vmm.deserializers.VmmObjectTypeTypedObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmmDeserializerUtils {
    private static final Logger log = LoggerFactory.getLogger(VmmDeserializerUtils.class);
    public static final String OBJECT_TYPE = "$objectType";
    public static final String OBJECT_VERSION = "$fv";
    public static final String LEGACY_FQ_OBJECT_TYPE = "$fqObjectType";
    public static final String RESERVED = "$reserved";
    public static final String UNKNOWN_FIELDS = "$unknownFields";
    public static final String API_MINOR_VERSION = "minorVersion";
    private static final String DOT = ".";
    private static final String VERSION_REGEX = String.format("(.*\\.)?(v\\d+\\.r\\d+\\.?(?<%s>[a|b]\\d+)?)(\\.(.*))?", "minorVersion");
    private static final Pattern VERSION_PATTERN = Pattern.compile(VERSION_REGEX);

    public static Class<?> getObjectTypedType(JsonNode node, String packagePrefix) throws ClassNotFoundException {
        JsonNodeType nodeType = node.getNodeType();
        if (!JsonNodeType.OBJECT.equals((Object)node.getNodeType())) {
            log.error("Cannot get object-typed type from node of type {}", (Object)nodeType);
            throw new IllegalArgumentException(String.format("Cannot get object-typed type from node of type %s", nodeType));
        }
        JsonNode objectTypeNode = node.get(OBJECT_TYPE);
        if (objectTypeNode == null) {
            log.error("No $objectType present in object for deserialization");
            throw new IllegalArgumentException("No $objectType present in object for deserialization");
        }
        String objectTypeFromNode = objectTypeNode.textValue();
        String objectType = StringUtils.isEmpty((CharSequence)packagePrefix) ? objectTypeFromNode : packagePrefix.concat(DOT).concat(objectTypeFromNode);
        return Class.forName(objectType);
    }

    private static Class<?> getType(JsonNode node, String packagePrefix) throws ClassNotFoundException {
        log.debug("Inferring java type of json node {}", (Object)node);
        JsonNodeType nodeType = node.getNodeType();
        if (JsonNodeType.STRING.equals((Object)nodeType)) {
            return String.class;
        }
        if (JsonNodeType.NUMBER.equals((Object)nodeType)) {
            return Number.class;
        }
        if (JsonNodeType.BOOLEAN.equals((Object)nodeType)) {
            return Boolean.class;
        }
        if (JsonNodeType.ARRAY.equals((Object)nodeType)) {
            return List.class;
        }
        if (!JsonNodeType.OBJECT.equals((Object)nodeType)) {
            log.error("Cannot deserialize node of type {}", (Object)nodeType);
            throw new IllegalArgumentException(String.format("Cannot deserialize node of type %s", nodeType));
        }
        if (node.get(OBJECT_TYPE) == null) {
            return Map.class;
        }
        return VmmDeserializerUtils.getObjectTypedType(node, packagePrefix);
    }

    public static List readArrayNode(ObjectCodec codec, JsonNode node, String packagePrefix, Class<?> parameterizedClass) throws IOException, ClassNotFoundException {
        ArrayList<Object> value = new ArrayList<Object>();
        int count = node.size();
        log.debug("Processing {} children of array type node", (Object)count);
        Class<?> type = null;
        for (int i = 0; i < count; ++i) {
            if (i == 0) {
                type = parameterizedClass != null ? parameterizedClass : VmmDeserializerUtils.getType(node.get(0), packagePrefix);
            }
            value.add(VmmDeserializerUtils.readValue(codec, node.get(i), packagePrefix, type));
        }
        return value;
    }

    public static Map readMapNode(ObjectCodec codec, JsonNode node, String packagePrefix) throws IOException, ClassNotFoundException {
        LinkedHashMap value = new LinkedHashMap();
        Iterator mapIterator = node.fields();
        while (mapIterator.hasNext()) {
            Map.Entry mapEntry = (Map.Entry)mapIterator.next();
            log.debug("Processing key {} of map type node", mapEntry.getKey());
            value.put(mapEntry.getKey(), VmmDeserializerUtils.readValue(codec, (JsonNode)mapEntry.getValue(), packagePrefix, null));
        }
        return value;
    }

    public static Object readValue(ObjectCodec codec, JsonNode node, String packagePrefix, Class<?> parameterizedClass) throws IOException, ClassNotFoundException {
        Class<?> type = null;
        type = parameterizedClass != null ? parameterizedClass : VmmDeserializerUtils.getType(node, packagePrefix);
        if (List.class.equals(type)) {
            return VmmDeserializerUtils.readArrayNode(codec, node, packagePrefix, null);
        }
        if (Map.class.equals(type)) {
            return VmmDeserializerUtils.readMapNode(codec, node, packagePrefix);
        }
        return VmmDeserializerUtils.readValue(codec, node, type);
    }

    public static Object readValue(ObjectCodec codec, JsonNode node, Class<?> type) throws IOException {
        String VALUE = "value";
        JsonParser parser = Enum.class.isAssignableFrom(type) && node.has("value") ? node.get("value").traverse() : node.traverse();
        parser.setCodec(codec);
        return parser.readValueAs(type);
    }

    public static Object handleEtag(Object value, Map<String, Object> reservedMap) {
        if (reservedMap.containsKey("ETag")) {
            Object etagRef = reservedMap.get("ETag");
            if (value instanceof List && ((List)value).size() > 0) {
                for (Object item : (List)value) {
                    if (!(item instanceof VmmObjectTypeTypedObject)) continue;
                    ((VmmObjectTypeTypedObject)item).get$reserved().put("ETag", etagRef);
                }
            } else if (value instanceof VmmObjectTypeTypedObject) {
                ((VmmObjectTypeTypedObject)value).get$reserved().put("ETag", etagRef);
            }
        }
        return value;
    }

    public static String getMinorVersion(String name) {
        Matcher matcher = VERSION_PATTERN.matcher(name);
        if (!matcher.matches()) {
            return null;
        }
        String minorVersion = matcher.group(API_MINOR_VERSION);
        if (StringUtils.isBlank((CharSequence)minorVersion)) {
            return null;
        }
        return minorVersion;
    }

    public static boolean classNameEquals(String name, String targetClassName) {
        return name.substring(name.lastIndexOf(DOT) + 1).equals(targetClassName);
    }
}

