/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.iam.iam.v4.tenant;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.iam.common.v1.response.ApiLink;
import com.nutanix.dp1.iam.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.iam.deserializers.IamObjectTypeTypedObject;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tenant
extends ExternalizableAbstractModel
implements Serializable,
IamObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Tenant.class);
    @Size(min=1, max=255)
    @JsonProperty(value="tenantName")
    public @Size(min=1, max=255) String tenantName = null;
    @JsonProperty(value="tenantDescription")
    public String tenantDescription = null;

    public Tenant() {
    }

    public Tenant(String tenantId, String extId, List<ApiLink> links, String tenantName, String tenantDescription) {
        super(tenantId, extId, links);
        this.setTenantName(tenantName);
        this.setTenantDescription(tenantDescription);
    }

    @Override
    protected String initialize$objectType() {
        return "iam.v4.tenant.Tenant";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static TenantBuilder TenantBuilder() {
        return new TenantBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tenant)) {
            return false;
        }
        Tenant other = (Tenant)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$tenantName = this.getTenantName();
        String other$tenantName = other.getTenantName();
        if (this$tenantName == null ? other$tenantName != null : !this$tenantName.equals(other$tenantName)) {
            return false;
        }
        String this$tenantDescription = this.getTenantDescription();
        String other$tenantDescription = other.getTenantDescription();
        return !(this$tenantDescription == null ? other$tenantDescription != null : !this$tenantDescription.equals(other$tenantDescription));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Tenant;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $tenantName = this.getTenantName();
        result = result * 59 + ($tenantName == null ? 43 : $tenantName.hashCode());
        String $tenantDescription = this.getTenantDescription();
        result = result * 59 + ($tenantDescription == null ? 43 : $tenantDescription.hashCode());
        return result;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public String getTenantDescription() {
        return this.tenantDescription;
    }

    @JsonProperty(value="tenantName")
    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    @JsonProperty(value="tenantDescription")
    public void setTenantDescription(String tenantDescription) {
        this.tenantDescription = tenantDescription;
    }

    @Override
    public String toString() {
        return "Tenant(tenantName=" + this.getTenantName() + ", tenantDescription=" + this.getTenantDescription() + ")";
    }

    public static class TenantBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String tenantName;
        private String tenantDescription;

        TenantBuilder() {
        }

        public TenantBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public TenantBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public TenantBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public TenantBuilder tenantName(String tenantName) {
            this.tenantName = tenantName;
            return this;
        }

        public TenantBuilder tenantDescription(String tenantDescription) {
            this.tenantDescription = tenantDescription;
            return this;
        }

        public Tenant build() {
            return new Tenant(this.tenantId, this.extId, this.links, this.tenantName, this.tenantDescription);
        }

        public String toString() {
            return "Tenant.TenantBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", tenantName=" + this.tenantName + ", tenantDescription=" + this.tenantDescription + ")";
        }
    }
}

