/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.iam.iam.v4.authz;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.iam.common.v1.response.ApiLink;
import com.nutanix.dp1.iam.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.iam.deserializers.IamObjectTypeTypedObject;
import com.nutanix.dp1.iam.iam.v4.authz.AssociatedEndpoint;
import com.nutanix.dp1.iam.iam.v4.authz.OperationType;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Operation
extends ExternalizableAbstractModel
implements Serializable,
IamObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Operation.class);
    private OffsetDateTime createdTime = null;
    private OffsetDateTime lastUpdatedTime = null;
    @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$")
    @Size(min=1, max=255)
    @JsonProperty(value="displayName")
    public @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$") @Size(min=1, max=255) String displayName = null;
    @Pattern(regexp="^[^<>;()&+%/\\\\\"`]*$")
    @Size(max=1000)
    @JsonProperty(value="description")
    public @Pattern(regexp="^[^<>;()&+%/\\\\\"`]*$") @Size(max=1000) String description = null;
    @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$")
    @JsonProperty(value="entityType")
    public @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$") String entityType = null;
    @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$")
    @Size(max=255)
    @JsonProperty(value="clientName")
    public @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$") @Size(max=255) String clientName = null;
    @JsonProperty(value="operationType")
    public OperationType operationType = null;
    @Size(min=0, max=1000)
    @JsonProperty(value="relatedOperationList")
    public @Size(min=0, max=1000) List<String> relatedOperationList = null;
    @Size(min=0, max=4)
    @JsonProperty(value="associatedEndpointList")
    public @Size(min=0, max=4) List<AssociatedEndpoint> associatedEndpointList = null;

    public Operation() {
    }

    public Operation(String tenantId, String extId, List<ApiLink> links, String displayName, String description, String entityType, String clientName, OffsetDateTime createdTime, OffsetDateTime lastUpdatedTime, OperationType operationType, List<String> relatedOperationList, List<AssociatedEndpoint> associatedEndpointList) {
        super(tenantId, extId, links);
        this.setDisplayName(displayName);
        this.setDescription(description);
        this.setEntityType(entityType);
        this.setClientName(clientName);
        this.setCreatedTime(createdTime);
        this.setLastUpdatedTime(lastUpdatedTime);
        this.setOperationType(operationType);
        this.setRelatedOperationList(relatedOperationList);
        this.setAssociatedEndpointList(associatedEndpointList);
    }

    @Override
    protected String initialize$objectType() {
        return "iam.v4.authz.Operation";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setCreatedTime(OffsetDateTime createdTime) {
        if (this.createdTime == null) {
            this.createdTime = createdTime;
        } else {
            log.warn("Read-only property createdTime already contains a non-null value and cannot be set again");
        }
    }

    public void setLastUpdatedTime(OffsetDateTime lastUpdatedTime) {
        if (this.lastUpdatedTime == null) {
            this.lastUpdatedTime = lastUpdatedTime;
        } else {
            log.warn("Read-only property lastUpdatedTime already contains a non-null value and cannot be set again");
        }
    }

    public static OperationBuilder OperationBuilder() {
        return new OperationBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Operation)) {
            return false;
        }
        Operation other = (Operation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OffsetDateTime this$createdTime = this.getCreatedTime();
        OffsetDateTime other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        OffsetDateTime this$lastUpdatedTime = this.getLastUpdatedTime();
        OffsetDateTime other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$entityType = this.getEntityType();
        String other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        if (this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName)) {
            return false;
        }
        OperationType this$operationType = this.getOperationType();
        OperationType other$operationType = other.getOperationType();
        if (this$operationType == null ? other$operationType != null : !((Object)((Object)this$operationType)).equals((Object)other$operationType)) {
            return false;
        }
        List<String> this$relatedOperationList = this.getRelatedOperationList();
        List<String> other$relatedOperationList = other.getRelatedOperationList();
        if (this$relatedOperationList == null ? other$relatedOperationList != null : !((Object)this$relatedOperationList).equals(other$relatedOperationList)) {
            return false;
        }
        List<AssociatedEndpoint> this$associatedEndpointList = this.getAssociatedEndpointList();
        List<AssociatedEndpoint> other$associatedEndpointList = other.getAssociatedEndpointList();
        return !(this$associatedEndpointList == null ? other$associatedEndpointList != null : !((Object)this$associatedEndpointList).equals(other$associatedEndpointList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Operation;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OffsetDateTime $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        OffsetDateTime $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : $entityType.hashCode());
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        OperationType $operationType = this.getOperationType();
        result = result * 59 + ($operationType == null ? 43 : ((Object)((Object)$operationType)).hashCode());
        List<String> $relatedOperationList = this.getRelatedOperationList();
        result = result * 59 + ($relatedOperationList == null ? 43 : ((Object)$relatedOperationList).hashCode());
        List<AssociatedEndpoint> $associatedEndpointList = this.getAssociatedEndpointList();
        result = result * 59 + ($associatedEndpointList == null ? 43 : ((Object)$associatedEndpointList).hashCode());
        return result;
    }

    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public OffsetDateTime getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getClientName() {
        return this.clientName;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public List<String> getRelatedOperationList() {
        return this.relatedOperationList;
    }

    public List<AssociatedEndpoint> getAssociatedEndpointList() {
        return this.associatedEndpointList;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="entityType")
    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    @JsonProperty(value="clientName")
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @JsonProperty(value="operationType")
    public void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }

    @JsonProperty(value="relatedOperationList")
    public void setRelatedOperationList(List<String> relatedOperationList) {
        this.relatedOperationList = relatedOperationList;
    }

    @JsonProperty(value="associatedEndpointList")
    public void setAssociatedEndpointList(List<AssociatedEndpoint> associatedEndpointList) {
        this.associatedEndpointList = associatedEndpointList;
    }

    @Override
    public String toString() {
        return "Operation(createdTime=" + this.getCreatedTime() + ", lastUpdatedTime=" + this.getLastUpdatedTime() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", entityType=" + this.getEntityType() + ", clientName=" + this.getClientName() + ", operationType=" + (Object)((Object)this.getOperationType()) + ", relatedOperationList=" + this.getRelatedOperationList() + ", associatedEndpointList=" + this.getAssociatedEndpointList() + ")";
    }

    public static class OperationBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String displayName;
        private String description;
        private String entityType;
        private String clientName;
        private OffsetDateTime createdTime;
        private OffsetDateTime lastUpdatedTime;
        private OperationType operationType;
        private List<String> relatedOperationList;
        private List<AssociatedEndpoint> associatedEndpointList;

        OperationBuilder() {
        }

        public OperationBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public OperationBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public OperationBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public OperationBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public OperationBuilder description(String description) {
            this.description = description;
            return this;
        }

        public OperationBuilder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public OperationBuilder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public OperationBuilder createdTime(OffsetDateTime createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public OperationBuilder lastUpdatedTime(OffsetDateTime lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public OperationBuilder operationType(OperationType operationType) {
            this.operationType = operationType;
            return this;
        }

        public OperationBuilder relatedOperationList(List<String> relatedOperationList) {
            this.relatedOperationList = relatedOperationList;
            return this;
        }

        public OperationBuilder associatedEndpointList(List<AssociatedEndpoint> associatedEndpointList) {
            this.associatedEndpointList = associatedEndpointList;
            return this;
        }

        public Operation build() {
            return new Operation(this.tenantId, this.extId, this.links, this.displayName, this.description, this.entityType, this.clientName, this.createdTime, this.lastUpdatedTime, this.operationType, this.relatedOperationList, this.associatedEndpointList);
        }

        public String toString() {
            return "Operation.OperationBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", displayName=" + this.displayName + ", description=" + this.description + ", entityType=" + this.entityType + ", clientName=" + this.clientName + ", createdTime=" + this.createdTime + ", lastUpdatedTime=" + this.lastUpdatedTime + ", operationType=" + (Object)((Object)this.operationType) + ", relatedOperationList=" + this.relatedOperationList + ", associatedEndpointList=" + this.associatedEndpointList + ")";
        }
    }
}

