/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.iam.iam.v4.authz;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.iam.common.v1.response.ApiLink;
import com.nutanix.dp1.iam.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.iam.deserializers.IamObjectTypeTypedObject;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseRole
extends ExternalizableAbstractModel
implements Serializable,
IamObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(BaseRole.class);
    @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$")
    @Size(min=1, max=255)
    @JsonProperty(value="displayName")
    public @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$") @Size(min=1, max=255) String displayName = null;
    @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$")
    @Size(max=255)
    @JsonProperty(value="clientName")
    public @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$") @Size(max=255) String clientName = null;

    public BaseRole() {
    }

    public BaseRole(String tenantId, String extId, List<ApiLink> links, String displayName, String clientName) {
        super(tenantId, extId, links);
        this.setDisplayName(displayName);
        this.setClientName(clientName);
    }

    @Override
    protected String initialize$objectType() {
        return "iam.v4.authz.BaseRole";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static BaseRoleBuilder BaseRoleBuilder() {
        return new BaseRoleBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseRole)) {
            return false;
        }
        BaseRole other = (BaseRole)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        return !(this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseRole;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        return result;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getClientName() {
        return this.clientName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @JsonProperty(value="clientName")
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Override
    public String toString() {
        return "BaseRole(displayName=" + this.getDisplayName() + ", clientName=" + this.getClientName() + ")";
    }

    public static class BaseRoleBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String displayName;
        private String clientName;

        BaseRoleBuilder() {
        }

        public BaseRoleBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public BaseRoleBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public BaseRoleBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public BaseRoleBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public BaseRoleBuilder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public BaseRole build() {
            return new BaseRole(this.tenantId, this.extId, this.links, this.displayName, this.clientName);
        }

        public String toString() {
            return "BaseRole.BaseRoleBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", displayName=" + this.displayName + ", clientName=" + this.clientName + ")";
        }
    }
}

