/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.iam.iam.v4.authz;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.iam.common.v1.response.ApiLink;
import com.nutanix.dp1.iam.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.iam.deserializers.IamObjectTypeTypedObject;
import com.nutanix.dp1.iam.iam.v4.authz.EntityOperators;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeEntity
extends ExternalizableAbstractModel
implements Serializable,
IamObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(AttributeEntity.class);
    @Pattern(regexp="^[^\\\"]*$")
    @Size(min=1, max=255)
    @JsonProperty(value="displayName")
    public @Pattern(regexp="^[^\\\"]*$") @Size(min=1, max=255) String displayName = null;
    @Size(min=0, max=5)
    @JsonProperty(value="supportedOperators")
    public @Size(min=0, max=5) List<EntityOperators> supportedOperators = null;
    @Size(min=0, max=25)
    @JsonProperty(value="attributeValues")
    public @Size(min=0, max=25) List<String> attributeValues = null;

    public AttributeEntity() {
    }

    public AttributeEntity(String tenantId, String extId, List<ApiLink> links, String displayName, List<EntityOperators> supportedOperators, List<String> attributeValues) {
        super(tenantId, extId, links);
        this.setDisplayName(displayName);
        this.setSupportedOperators(supportedOperators);
        this.setAttributeValues(attributeValues);
    }

    @Override
    protected String initialize$objectType() {
        return "iam.v4.authz.AttributeEntity";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static AttributeEntityBuilder AttributeEntityBuilder() {
        return new AttributeEntityBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeEntity)) {
            return false;
        }
        AttributeEntity other = (AttributeEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        List<EntityOperators> this$supportedOperators = this.getSupportedOperators();
        List<EntityOperators> other$supportedOperators = other.getSupportedOperators();
        if (this$supportedOperators == null ? other$supportedOperators != null : !((Object)this$supportedOperators).equals(other$supportedOperators)) {
            return false;
        }
        List<String> this$attributeValues = this.getAttributeValues();
        List<String> other$attributeValues = other.getAttributeValues();
        return !(this$attributeValues == null ? other$attributeValues != null : !((Object)this$attributeValues).equals(other$attributeValues));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AttributeEntity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        List<EntityOperators> $supportedOperators = this.getSupportedOperators();
        result = result * 59 + ($supportedOperators == null ? 43 : ((Object)$supportedOperators).hashCode());
        List<String> $attributeValues = this.getAttributeValues();
        result = result * 59 + ($attributeValues == null ? 43 : ((Object)$attributeValues).hashCode());
        return result;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<EntityOperators> getSupportedOperators() {
        return this.supportedOperators;
    }

    public List<String> getAttributeValues() {
        return this.attributeValues;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @JsonProperty(value="supportedOperators")
    public void setSupportedOperators(List<EntityOperators> supportedOperators) {
        this.supportedOperators = supportedOperators;
    }

    @JsonProperty(value="attributeValues")
    public void setAttributeValues(List<String> attributeValues) {
        this.attributeValues = attributeValues;
    }

    @Override
    public String toString() {
        return "AttributeEntity(displayName=" + this.getDisplayName() + ", supportedOperators=" + this.getSupportedOperators() + ", attributeValues=" + this.getAttributeValues() + ")";
    }

    public static class AttributeEntityBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String displayName;
        private List<EntityOperators> supportedOperators;
        private List<String> attributeValues;

        AttributeEntityBuilder() {
        }

        public AttributeEntityBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public AttributeEntityBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public AttributeEntityBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public AttributeEntityBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public AttributeEntityBuilder supportedOperators(List<EntityOperators> supportedOperators) {
            this.supportedOperators = supportedOperators;
            return this;
        }

        public AttributeEntityBuilder attributeValues(List<String> attributeValues) {
            this.attributeValues = attributeValues;
            return this;
        }

        public AttributeEntity build() {
            return new AttributeEntity(this.tenantId, this.extId, this.links, this.displayName, this.supportedOperators, this.attributeValues);
        }

        public String toString() {
            return "AttributeEntity.AttributeEntityBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", displayName=" + this.displayName + ", supportedOperators=" + this.supportedOperators + ", attributeValues=" + this.attributeValues + ")";
        }
    }
}

