/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem.simple;

import com.codahale.metrics.MetricRegistry;
import com.google.gson.Gson;
import com.northernwall.hadrian.Const;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.parameters.Parameters;
import com.northernwall.hadrian.workItem.WorkItemSender;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleWorkItemSender
extends WorkItemSender {
    private static final Logger logger = LoggerFactory.getLogger(SimpleWorkItemSender.class);
    private final String url;
    private final Gson gson;
    private final OkHttpClient client;

    public SimpleWorkItemSender(Parameters parameters, OkHttpClient client, MetricRegistry metricRegistry) {
        super(parameters);
        this.client = client;
        this.gson = new Gson();
        this.url = parameters.getString("simpleWorkItem.url", "http://127.0.0.1:9090/webhook/simple");
    }

    @Override
    public boolean sendWorkItem(WorkItem workItem) throws IOException {
        RequestBody body = RequestBody.create((MediaType)Const.JSON_MEDIA_TYPE, (String)this.gson.toJson((Object)workItem));
        Request request = new Request.Builder().url(this.url).addHeader("X-Request-Id", workItem.getId()).post(body).build();
        Response response = this.client.newCall(request).execute();
        logger.info("Sent workitem {} and got response {}", (Object)workItem.getId(), (Object)response.code());
        return false;
    }
}

