/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.gson.Gson;
import com.northernwall.hadrian.Util;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Audit;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.VipRef;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.workItem.WorkItemSender;
import com.northernwall.hadrian.workItem.dao.CallbackData;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkItemProcessor {
    private static final Logger logger = LoggerFactory.getLogger(WorkItemProcessor.class);
    private final DataAccess dataAccess;
    private final WorkItemSender webHookSender;
    private final Timer timerProcess;
    private final Timer timerCalback;
    private final Meter meterSuccess;
    private final Meter meterFail;
    private final Gson gson;

    public WorkItemProcessor(DataAccess dataAccess, WorkItemSender webHookSender, MetricRegistry metricRegistry) {
        this.dataAccess = dataAccess;
        this.webHookSender = webHookSender;
        this.timerProcess = metricRegistry.timer("workItem.sendWorkItem");
        this.timerCalback = metricRegistry.timer("workItem.callback.process");
        this.meterSuccess = metricRegistry.meter("workItem.callback.success");
        this.meterFail = metricRegistry.meter("workItem.callback.fail");
        this.gson = new Gson();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendWorkItem(WorkItem workItem) throws IOException {
        boolean done = false;
        Timer.Context context = this.timerProcess.time();
        try {
            done = this.webHookSender.sendWorkItem(workItem);
        }
        finally {
            context.stop();
        }
        if (done) {
            logger.info("Work item sender says work item  {} has been process, no callback expected.", (Object)workItem.getId());
            CallbackData callbackData = new CallbackData();
            callbackData.requestId = workItem.getId();
            callbackData.errorCode = 0;
            callbackData.errorDescription = " ";
            callbackData.status = "success";
            callbackData.output = "no output";
            this.processCallback(callbackData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processCallback(CallbackData callbackData) throws IOException {
        Timer.Context context = this.timerCalback.time();
        try {
            WorkItem workItem = this.dataAccess.getWorkItem(callbackData.requestId);
            if (workItem == null) {
                throw new RuntimeException("Could not find work item " + callbackData.requestId);
            }
            this.dataAccess.deleteWorkItem(callbackData.requestId);
            boolean status = callbackData.status.equalsIgnoreCase("success");
            if (status) {
                this.meterSuccess.mark();
            } else {
                this.meterFail.mark();
            }
            HashMap<String, String> notes = new HashMap<String, String>();
            if (workItem.getType().equalsIgnoreCase("service")) {
                if (!workItem.getOperation().equalsIgnoreCase("create")) throw new RuntimeException("Unknown callback " + workItem.getType() + " " + workItem.getOperation());
                this.createService(workItem, status);
            } else if (workItem.getType().equalsIgnoreCase("module")) {
                if (workItem.getOperation().equalsIgnoreCase("create")) {
                    notes.put("template", workItem.getMainModule().template);
                    notes.put("type", workItem.getMainModule().moduleType);
                } else if (!workItem.getOperation().equalsIgnoreCase("update") && !workItem.getOperation().equalsIgnoreCase("delete")) {
                    throw new RuntimeException("Unknown callback " + workItem.getType() + " " + workItem.getOperation());
                }
            } else if (workItem.getType().equalsIgnoreCase("host")) {
                if (workItem.getOperation().equalsIgnoreCase("create")) {
                    this.createHost(workItem, status);
                    notes.put("env", workItem.getHost().env);
                    notes.put("size", workItem.getHost().size);
                    notes.put("reason", workItem.getHost().reason);
                } else if (workItem.getOperation().equalsIgnoreCase("deploy")) {
                    this.deploySoftware(workItem, status);
                    notes.put("version", workItem.getHost().version);
                    notes.put("reason", workItem.getHost().reason);
                } else if (workItem.getOperation().equalsIgnoreCase("restart")) {
                    this.restartHost(workItem, status);
                } else {
                    if (!workItem.getOperation().equalsIgnoreCase("delete")) throw new RuntimeException("Unknown callback " + workItem.getType() + " " + workItem.getOperation());
                    this.deleteHost(workItem, status);
                }
            } else if (workItem.getType().equalsIgnoreCase("vip")) {
                if (workItem.getOperation().equalsIgnoreCase("create")) {
                    notes.put("protocol", workItem.getVip().protocol);
                    this.createVip(workItem, status);
                } else if (workItem.getOperation().equalsIgnoreCase("update")) {
                    this.updateVip(workItem, status);
                } else {
                    if (!workItem.getOperation().equalsIgnoreCase("delete")) throw new RuntimeException("Unknown callback " + workItem.getType() + " " + workItem.getOperation());
                    this.deleteVip(workItem, status);
                }
            } else {
                if (!workItem.getType().equalsIgnoreCase("hostvip")) throw new RuntimeException("Unknown callback " + workItem.getType() + " " + workItem.getOperation());
                if (workItem.getOperation().equalsIgnoreCase("add")) {
                    this.addHostVip(workItem, status);
                } else {
                    if (!workItem.getOperation().equalsIgnoreCase("delete")) throw new RuntimeException("Unknown callback " + workItem.getType() + " " + workItem.getOperation());
                    this.deleteHostVip(workItem, status);
                }
            }
            if (status) {
                Audit audit = new Audit();
                audit.serviceId = workItem.getService().serviceId;
                audit.timePerformed = Util.getGmt();
                audit.timeRequested = workItem.getRequestDate();
                audit.requestor = workItem.getUsername();
                audit.type = workItem.getType();
                audit.operation = workItem.getOperation();
                if (workItem.getMainModule() != null) {
                    audit.moduleName = workItem.getMainModule().moduleName;
                }
                if (workItem.getHost() != null) {
                    audit.hostName = workItem.getHost().hostName;
                }
                if (workItem.getVip() != null) {
                    audit.vipName = workItem.getVip().vipName;
                }
                audit.notes = notes == null || notes.isEmpty() ? "" : this.gson.toJson(notes);
                this.dataAccess.saveAudit(audit, callbackData.output);
                return;
            } else {
                this.deleteNextWorkItem(workItem.getNextId());
            }
            return;
        }
        finally {
            context.stop();
        }
    }

    private void deleteNextWorkItem(String nextId) {
        if (nextId != null) {
            WorkItem nextWorkItem = this.dataAccess.getWorkItem(nextId);
            this.deleteNextWorkItem(nextWorkItem.getNextId());
            this.dataAccess.deleteWorkItem(nextId);
        }
    }

    private void createService(WorkItem workItem, boolean status) throws IOException {
        Service service = this.dataAccess.getService(workItem.getService().serviceId);
        if (service == null) {
            logger.warn("Could not find service {} being created", (Object)workItem.getService().serviceId);
            return;
        }
        if (!status) {
            logger.warn("Callback for {} failed with status {}", (Object)service.getServiceId(), (Object)status);
        }
    }

    private void createHost(WorkItem workItem, boolean status) throws IOException {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            logger.warn("Could not find host {} being created", (Object)workItem.getHost().hostId);
            return;
        }
        if (status) {
            if (workItem.getNextId() != null) {
                WorkItem nextWorkItem = this.dataAccess.getWorkItem(workItem.getNextId());
                if (nextWorkItem != null) {
                    host.setStatus("Deploying...");
                    this.dataAccess.updateHost(host);
                    this.sendWorkItem(nextWorkItem);
                } else {
                    logger.warn("Odd, the deploy work item {} for create host {} could not be found", (Object)workItem.getNextId(), (Object)host.getHostName());
                    host.setStatus("-");
                    this.dataAccess.updateHost(host);
                }
            } else {
                logger.warn("Odd, create host {} work item has no deploy work item id", (Object)host.getHostName());
            }
        } else {
            logger.warn("Callback for {} failed with status {}", (Object)host.getHostId(), (Object)status);
            this.dataAccess.deleteHost(host.getServiceId(), host.getHostId());
        }
    }

    private void deploySoftware(WorkItem workItem, boolean status) throws IOException {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            logger.warn("Could not find host {} being updated", (Object)workItem.getHost().hostId);
            return;
        }
        if (status) {
            host.setStatus("-");
            this.dataAccess.updateHost(host);
            if (workItem.getNextId() == null) {
                return;
            }
            WorkItem nextWorkItem = this.dataAccess.getWorkItem(workItem.getNextId());
            Host nextHost = this.dataAccess.getHost(nextWorkItem.getService().serviceId, nextWorkItem.getHost().hostId);
            if (nextHost == null) {
                logger.error("Finished updating {}, next work item is {}, but could not find it.", (Object)workItem.getHost().hostId, (Object)nextWorkItem.getHost().hostId);
                return;
            }
            nextHost.setStatus("Deploying...");
            this.dataAccess.saveHost(nextHost);
            this.sendWorkItem(nextWorkItem);
        } else {
            logger.warn("Callback for {} failed with status {}", (Object)workItem.getHost().hostId, (Object)status);
        }
    }

    private void restartHost(WorkItem workItem, boolean status) throws IOException {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            logger.warn("Could not find host {} being restarted", (Object)workItem.getHost().hostId);
            return;
        }
        if (status) {
            host.setStatus("-");
            this.dataAccess.updateHost(host);
            if (workItem.getNextId() == null) {
                return;
            }
            WorkItem nextWorkItem = this.dataAccess.getWorkItem(workItem.getNextId());
            Host nextHost = this.dataAccess.getHost(nextWorkItem.getService().serviceId, nextWorkItem.getHost().hostId);
            if (nextHost == null) {
                logger.error("Finished restarting {}, next work item is {}, but could not find it.", (Object)workItem.getHost().hostId, (Object)nextWorkItem.getHost().hostId);
                return;
            }
            nextHost.setStatus("Restarting...");
            this.dataAccess.saveHost(nextHost);
            this.sendWorkItem(nextWorkItem);
        } else {
            logger.warn("Callback for {} failed with status {}", (Object)workItem.getHost().hostId, (Object)status);
        }
    }

    private void deleteHost(WorkItem workItem, boolean status) throws IOException {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            logger.warn("Could not find host {} to delete.", (Object)workItem.getHost().hostId);
            return;
        }
        if (status) {
            this.dataAccess.deleteHost(host.getServiceId(), host.getHostId());
        } else {
            logger.warn("Callback for {} failed with status {}", (Object)host.getHostId(), (Object)status);
            host.setStatus("-");
            this.dataAccess.updateHost(host);
        }
    }

    private void createVip(WorkItem workItem, boolean status) throws IOException {
        Vip vip = this.dataAccess.getVip(workItem.getService().serviceId, workItem.getVip().vipId);
        if (vip == null) {
            logger.warn("Could not find vip {} being created", (Object)workItem.getVip().vipId);
            return;
        }
        if (status) {
            vip.setStatus("-");
            this.dataAccess.updateVip(vip);
        } else {
            logger.warn("Callback for {} failed with status {}", (Object)vip.getVipId(), (Object)status);
            this.dataAccess.deleteVip(vip.getServiceId(), vip.getVipId());
        }
    }

    private void updateVip(WorkItem workItem, boolean status) throws IOException {
        Vip vip = this.dataAccess.getVip(workItem.getService().serviceId, workItem.getVip().vipId);
        if (vip == null) {
            logger.warn("Could not find vip {} being updated", (Object)workItem.getVip().vipId);
            return;
        }
        if (status) {
            vip.setStatus("-");
            vip.setExternal(workItem.getNewVip().external);
            vip.setServicePort(workItem.getNewVip().servicePort);
            this.dataAccess.updateVip(vip);
        } else {
            logger.warn("Callback for {} failed with status {}", (Object)workItem.getVip().vipId, (Object)status);
        }
    }

    private void deleteVip(WorkItem workItem, boolean status) throws IOException {
        Vip vip = this.dataAccess.getVip(workItem.getService().serviceId, workItem.getVip().vipId);
        if (vip == null) {
            logger.error("Could not find end point {} to delete.", (Object)workItem.getVip().vipId);
            return;
        }
        if (status) {
            this.dataAccess.deleteVipRefs(vip.getVipId());
            this.dataAccess.deleteVip(vip.getServiceId(), vip.getVipId());
        } else {
            logger.warn("Callback for {} failed with status {}", (Object)vip.getVipId(), (Object)status);
            vip.setStatus("-");
            this.dataAccess.updateVip(vip);
        }
    }

    private void addHostVip(WorkItem workItem, boolean status) {
        VipRef vipRef = this.dataAccess.getVipRef(workItem.getHost().hostId, workItem.getVip().vipId);
        if (vipRef == null) {
            logger.error("Could not find end point ref {} {} to create.", (Object)workItem.getHost().hostId, (Object)workItem.getVip().vipId);
            return;
        }
        if (status) {
            vipRef.setStatus("-");
            this.dataAccess.updateVipRef(vipRef);
        } else {
            logger.warn("Callback for {} {} failed with status {}", new Object[]{vipRef.getHostId(), vipRef.getVipId(), status});
            this.dataAccess.deleteVipRef(vipRef.getHostId(), vipRef.getVipId());
        }
    }

    private void deleteHostVip(WorkItem workItem, boolean status) {
        VipRef vipRef = this.dataAccess.getVipRef(workItem.getHost().hostId, workItem.getVip().vipId);
        if (vipRef == null) {
            logger.error("Could not find end point ref {} {} to delete.", (Object)workItem.getHost().hostId, (Object)workItem.getVip().vipId);
            return;
        }
        if (status) {
            this.dataAccess.deleteVipRef(vipRef.getHostId(), vipRef.getVipId());
        } else {
            logger.warn("Callback for {} {} failed with status {}", new Object[]{vipRef.getHostId(), vipRef.getVipId(), status});
            vipRef.setStatus("-");
            this.dataAccess.updateVipRef(vipRef);
        }
    }
}

