/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem;

import com.northernwall.hadrian.Util;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import com.northernwall.hadrian.workItem.dao.CallbackData;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkItemCallbackHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(WorkItemCallbackHandler.class);
    private final WorkItemProcessor workItemProcess;

    public WorkItemCallbackHandler(WorkItemProcessor workItemProcess) {
        this.workItemProcess = workItemProcess;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        try {
            if (target.startsWith("/webhook/callback") && request.getMethod().equals("POST")) {
                logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                this.workItemProcess.processCallback(Util.fromJson(request, CallbackData.class));
                response.setStatus(200);
                request.setHandled(true);
            }
        }
        catch (Exception e) {
            logger.error("Exception {} while handling request for {}", new Object[]{e.getMessage(), target, e});
            response.setStatus(400);
        }
    }
}

